/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph;

import edu.uci.ics.jung.graph.Graph;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FGEdgeImpl;
import ghidra.app.plugin.core.functiongraph.graph.FGVertexType;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.layout.EmptyLayout;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayout;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProvider;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.ListingFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.mvc.EmptyFunctionGraphData;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphVertexAttributes;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.BasicBlockModel;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public class FunctionGraphFactory {
    public static FGData createClonedGraph(FGData data, FGController newController) {
        Function function = data.getFunction();
        FunctionGraph originalGraph = data.getFunctionGraph();
        FunctionGraph newGraph = FunctionGraphFactory.cloneGraph(originalGraph, newController);
        FunctionGraphFactory.cloneLayout(originalGraph, newGraph);
        return new FGData(function, newGraph);
    }

    private static FunctionGraph cloneGraph(FunctionGraph originalGraph, FGController newController) {
        Map<FGVertex, FGVertex> oldToNewCloneMap = FunctionGraphFactory.cloneVertices(originalGraph.getUngroupedVertices(), newController);
        Collection<FGVertex> vertices = oldToNewCloneMap.values();
        Set<FGEdge> originalEdges = originalGraph.getUngroupedEdges();
        Collection<FGEdge> edges = FunctionGraphFactory.cloneEdges(originalGraph, oldToNewCloneMap, originalEdges, newController);
        Program program = newController.getProgram();
        FunctionGraphVertexAttributes newSettings = FunctionGraphFactory.cloneSettings(originalGraph, program);
        Function function = originalGraph.getFunction();
        FunctionGraph newGraph = new FunctionGraph(function, newSettings, vertices, edges);
        newGraph.setOptions(originalGraph.getOptions());
        FGVertex entry = newGraph.getVertexForAddress(function.getEntryPoint());
        newGraph.setRootVertex(entry);
        return newGraph;
    }

    private static void cloneLayout(FunctionGraph originalGraph, FunctionGraph newGraph) {
        FGLayout originalLayout = originalGraph.getLayout();
        VisualGraphLayout newLayout = originalLayout.cloneLayout((VisualGraph)newGraph);
        newGraph.setGraphLayout((FGLayout)newLayout);
    }

    private static Map<FGVertex, FGVertex> cloneVertices(Collection<FGVertex> vertices, FGController newController) {
        HashMap<FGVertex, FGVertex> map = new HashMap<FGVertex, FGVertex>();
        for (FGVertex vertex : vertices) {
            FGVertex newVertex = vertex.cloneVertex(newController);
            map.put(vertex, newVertex);
        }
        return map;
    }

    private static Collection<FGEdge> cloneEdges(FunctionGraph currentGraph, Map<FGVertex, FGVertex> oldToNewCloneMap, Collection<FGEdge> originalEdges, FGController newController) {
        ArrayList<FGEdge> edges = new ArrayList<FGEdge>();
        for (FGEdge edge : originalEdges) {
            FGVertex newStartVertex = oldToNewCloneMap.get(edge.getStart());
            FGVertex newVertex = oldToNewCloneMap.get(edge.getEnd());
            if (newStartVertex == null || newVertex == null) {
                Msg.debug(null, (Object)"no nulls!");
            }
            FGEdge newEdge = edge.cloneEdge(newStartVertex, newVertex);
            edges.add(newEdge);
        }
        return edges;
    }

    private static FunctionGraphVertexAttributes cloneSettings(FunctionGraph originalFunctionGraph, Program program) {
        originalFunctionGraph.saveSettings();
        return new FunctionGraphVertexAttributes(program);
    }

    public static FGData createNewGraph(Function function, FGController controller, Program program, TaskMonitor monitor) throws CancelledException {
        FunctionGraph graph = FunctionGraphFactory.createGraph(function, controller, monitor);
        if (graph.getVertices().size() == 0) {
            return new EmptyFunctionGraphData("No data in function: " + function.getName());
        }
        if (!FunctionGraphFactory.isEntryPointValid(function, controller, monitor)) {
            return new EmptyFunctionGraphData("No instruction at function entry point: " + function.getName());
        }
        FGVertex functionEntryVertex = graph.getVertexForAddress(function.getEntryPoint());
        graph.setRootVertex(functionEntryVertex);
        graph.setOptions(controller.getFunctionGraphOptions());
        String errorMessage = FunctionGraphFactory.layoutGraph(function, controller, graph, monitor);
        return new FGData(function, graph, errorMessage);
    }

    private static boolean isEntryPointValid(Function function, FGController controller, TaskMonitor monitor) throws CancelledException {
        BasicBlockModel blockModel = new BasicBlockModel(controller.getProgram());
        CodeBlock[] codeBlock = blockModel.getCodeBlocksContaining(function.getEntryPoint(), monitor);
        if (codeBlock == null || codeBlock.length == 0) {
            monitor.setMessage("No instruction at function entry point.");
            return false;
        }
        return true;
    }

    private static String layoutGraph(Function function, FGController controller, FunctionGraph functionGraph, TaskMonitor monitor) throws CancelledException {
        if (!FunctionGraphFactory.performSwingThreadRequiredWork(functionGraph)) {
            return null;
        }
        monitor.setMessage("Performing graph layout...");
        FGLayoutProvider layoutProvider = controller.getLayoutProvider();
        try {
            FGLayout layout = layoutProvider.getLayout(functionGraph, monitor);
            functionGraph.setGraphLayout(layout);
            return null;
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (Exception e) {
            Msg.error(FunctionGraphFactory.class, (Object)("Exception performing graph layout for function " + String.valueOf(function)), (Throwable)e);
            controller.setStatusMessage("Problem performing graph layout--try another layout");
            functionGraph.setGraphLayout(new EmptyLayout(functionGraph));
            return "Problem performing graph layout using the \"" + layoutProvider.getLayoutName() + "\" (try another layout)";
        }
    }

    private static boolean performSwingThreadRequiredWork(FunctionGraph functionGraph) {
        Collection vertices = functionGraph.getVertices();
        try {
            SystemUtilities.runSwingNow(() -> {
                for (FGVertex v : vertices) {
                    v.getComponent();
                }
            });
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isEntry(CodeBlock codeBlock) {
        boolean isSource = true;
        try {
            CodeBlockReferenceIterator iter = codeBlock.getSources(TaskMonitor.DUMMY);
            while (iter.hasNext()) {
                isSource = false;
                if (!iter.next().getFlowType().isCall()) continue;
                return true;
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return isSource;
    }

    private static FunctionGraph createGraph(Function function, FGController controller, TaskMonitor monitor) throws CancelledException {
        BidiMap<CodeBlock, FGVertex> vertices = FunctionGraphFactory.createVertices(function, controller, monitor);
        Collection<FGEdge> edges = FunctionGraphFactory.createdEdges(vertices, controller, monitor);
        FunctionGraphVertexAttributes settings = new FunctionGraphVertexAttributes(controller.getProgram());
        FunctionGraph graph = new FunctionGraph(function, settings, vertices.values(), edges);
        for (FGVertex vertex : vertices.values()) {
            vertex.setVertexType(FunctionGraphFactory.getVertexType((Graph<FGVertex, FGEdge>)graph, vertex));
        }
        return graph;
    }

    private static Collection<FGEdge> createdEdges(BidiMap<CodeBlock, FGVertex> vertices, FGController controller, TaskMonitor monitor) throws CancelledException {
        ArrayList<FGEdge> edges = new ArrayList<FGEdge>();
        for (FGVertex startVertex : vertices.values()) {
            Collection<FGEdge> vertexEdges = FunctionGraphFactory.getEdgesForStartVertex(vertices, startVertex, controller, monitor);
            edges.addAll(vertexEdges);
        }
        return edges;
    }

    private static Collection<FGEdge> getEdgesForStartVertex(BidiMap<CodeBlock, FGVertex> blockToVertexMap, FGVertex startVertex, FGController controller, TaskMonitor monitor) throws CancelledException {
        ArrayList<FGEdge> edges = new ArrayList<FGEdge>();
        CodeBlock codeBlock = (CodeBlock)blockToVertexMap.getKey((Object)startVertex);
        CodeBlockReferenceIterator destinations = codeBlock.getDestinations(monitor);
        while (destinations.hasNext()) {
            CodeBlockReference reference = destinations.next();
            CodeBlock destinationBlock = reference.getDestinationBlock();
            FGVertex destinationVertex = (FGVertex)blockToVertexMap.get((Object)destinationBlock);
            if (destinationVertex == null) continue;
            edges.add(new FGEdgeImpl(startVertex, destinationVertex, reference.getFlowType(), controller.getFunctionGraphOptions()));
        }
        return edges;
    }

    private static BidiMap<CodeBlock, FGVertex> createVertices(Function function, FGController controller, TaskMonitor monitor) throws CancelledException {
        DualHashBidiMap vertices = new DualHashBidiMap();
        BasicBlockModel blockModel = new BasicBlockModel(controller.getProgram());
        AddressSetView addresses = function.getBody();
        CodeBlockIterator iterator = blockModel.getCodeBlocksContaining(addresses, monitor);
        monitor.initialize(addresses.getNumAddresses());
        while (iterator.hasNext()) {
            CodeBlock codeBlock = iterator.next();
            FlowType flowType = codeBlock.getFlowType();
            boolean isEntry = FunctionGraphFactory.isEntry(codeBlock);
            Address cbStart = codeBlock.getFirstStartAddress();
            if (cbStart.equals((Object)function.getEntryPoint())) {
                isEntry = true;
            }
            ListingFunctionGraphVertex vertex = new ListingFunctionGraphVertex(controller, (AddressSetView)codeBlock, flowType, isEntry);
            vertices.put((Object)codeBlock, (Object)vertex);
            long blockAddressCount = codeBlock.getNumAddresses();
            long currentProgress = monitor.getProgress();
            monitor.setProgress(currentProgress + blockAddressCount);
        }
        return vertices;
    }

    private static FGVertexType getVertexType(Graph<FGVertex, FGEdge> graph, FGVertex v) {
        boolean isEntry = v.isEntry();
        boolean isExit = false;
        FlowType flowType = v.getFlowType();
        if (flowType.isTerminal()) {
            isExit = true;
        }
        if (graph.getOutEdges((Object)v).isEmpty()) {
            isExit = true;
        }
        FGVertexType type = FGVertexType.BODY;
        if (isEntry) {
            type = isExit ? FGVertexType.SINGLETON : FGVertexType.ENTRY;
        } else if (isExit) {
            type = FGVertexType.EXIT;
        }
        return type;
    }
}

