/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.jungrapht;

import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.layout.AbstractFGLayout;
import ghidra.app.plugin.core.functiongraph.graph.layout.jungrapht.JgtLayoutFactory;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.layout.AbstractVisualGraphLayout;
import ghidra.graph.viewer.layout.Column;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.Row;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.util.exception.CancelledException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.EdgeArticulationFunctionSupplier;
import org.jungrapht.visualization.layout.model.DefaultLayoutModel;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;

public class JgtNamedLayout
extends AbstractFGLayout {
    private static Function<FGEdge, List<Point>> DUMMY_ARTICULATOR = e -> Collections.emptyList();

    JgtNamedLayout(FunctionGraph graph, String layoutName) {
        super(graph, layoutName);
    }

    @Override
    protected AbstractVisualGraphLayout<FGVertex, FGEdge> createClonedFGLayout(FunctionGraph newGraph) {
        return new JgtNamedLayout(newGraph, this.layoutName);
    }

    protected Point2D getVertexLocation(FGVertex v, Column col, Row<FGVertex> row, Rectangle bounds) {
        return this.getCenteredVertexLocation(v, col, row, bounds);
    }

    protected GridLocationMap<FGVertex, FGEdge> performInitialGridLayout(VisualGraph<FGVertex, FGEdge> visualGraph) throws CancelledException {
        FGEdgeComparator edgeComparator = new FGEdgeComparator(this);
        Predicate<FGEdge> favoredEdgePredicate = this.getFavoredEdgePredicate();
        Predicate rootPredicate = null;
        JgtLayoutFactory layoutProvider = new JgtLayoutFactory(edgeComparator, favoredEdgePredicate, rootPredicate);
        LayoutAlgorithm layout = layoutProvider.getLayout(this.layoutName);
        FGTempGraph jGraph = this.buildGraph(visualGraph);
        VisualGraphLayout vgLayout = visualGraph.getLayout();
        Dimension layoutSize = vgLayout.getSize();
        DefaultLayoutModel layoutModel = ((LayoutModel.Builder)((LayoutModel.Builder)LayoutModel.builder().graph((Graph)jGraph)).size(layoutSize.width, layoutSize.height)).build();
        layoutModel.accept(layout);
        GridLocationMap<FGVertex, FGEdge> grid = this.convertToGrid(jGraph, (LayoutModel<FGVertex>)layoutModel, layout);
        return grid;
    }

    private GridLocationMap<FGVertex, FGEdge> convertToGrid(FGTempGraph jGraph, LayoutModel<FGVertex> layoutModel, LayoutAlgorithm<FGVertex> layoutAlgorithm) throws CancelledException {
        GridLocationMap grid = new GridLocationMap();
        TreeMap<Double, Integer> columns = new TreeMap<Double, Integer>();
        TreeMap<Double, Integer> rows = new TreeMap<Double, Integer>();
        Set jungVertices = jGraph.vertexSet();
        for (FGVertex fgVertex : jungVertices) {
            this.monitor.checkCancelled();
            Point point = layoutModel.get((Object)fgVertex);
            columns.put(point.x, 0);
            rows.put(point.y, 0);
        }
        Function<FGEdge, List<Point>> articulator = this.getArticulator(layoutAlgorithm);
        Set edges = jGraph.edgeSet();
        for (FGEdge fgEdge : edges) {
            this.monitor.checkCancelled();
            List<Point> ariculations = articulator.apply(fgEdge);
            for (Point point : ariculations) {
                columns.put(point.x, 0);
                rows.put(point.y, 0);
            }
        }
        int counter = 0;
        for (Double x : columns.keySet()) {
            this.monitor.checkCancelled();
            columns.put(x, counter++);
        }
        counter = 0;
        for (Double y : rows.keySet()) {
            this.monitor.checkCancelled();
            rows.put(y, counter++);
        }
        jungVertices = jGraph.vertexSet();
        for (FGVertex fgVertex : jungVertices) {
            this.monitor.checkCancelled();
            Point point = layoutModel.get((Object)fgVertex);
            grid.set((Object)fgVertex, ((Integer)rows.get(point.y)).intValue(), ((Integer)columns.get(point.x)).intValue());
        }
        edges = jGraph.edgeSet();
        for (FGEdge fgEdge : edges) {
            this.monitor.checkCancelled();
            ArrayList<java.awt.Point> newPoints = new ArrayList<java.awt.Point>();
            List<Point> articulations = articulator.apply(fgEdge);
            for (Point point : articulations) {
                Integer col = (Integer)columns.get(point.x);
                Integer row = (Integer)rows.get(point.y);
                newPoints.add(new java.awt.Point(col, row));
            }
            if (!articulations.isEmpty()) {
                newPoints.remove(0);
                newPoints.remove(newPoints.size() - 1);
            }
            grid.setArticulations((Object)fgEdge, newPoints);
        }
        return grid;
    }

    private Function<FGEdge, List<Point>> getArticulator(LayoutAlgorithm<FGVertex> layout) {
        if (layout instanceof EdgeArticulationFunctionSupplier) {
            EdgeArticulationFunctionSupplier supplier = (EdgeArticulationFunctionSupplier)layout;
            return supplier.getEdgeArticulationFunction();
        }
        return DUMMY_ARTICULATOR;
    }

    private FGTempGraph buildGraph(VisualGraph<FGVertex, FGEdge> visualGraph) {
        FGTempGraph tempGraph = new FGTempGraph();
        Collection vertices = visualGraph.getVertices();
        for (FGVertex v : vertices) {
            tempGraph.addVertex(v);
        }
        Collection edges = visualGraph.getEdges();
        for (FGEdge e : edges) {
            tempGraph.addEdge((FGVertex)e.getStart(), (FGVertex)e.getEnd(), e);
        }
        return tempGraph;
    }

    private Predicate<FGEdge> getFavoredEdgePredicate() {
        return e -> e.getFlowType().equals((Object)RefType.FALL_THROUGH);
    }

    private class FGEdgeComparator
    implements Comparator<FGEdge> {
        public FGEdgeComparator(JgtNamedLayout jgtNamedLayout) {
        }

        @Override
        public int compare(FGEdge e1, FGEdge e2) {
            return this.priority(e1).compareTo(this.priority(e2));
        }

        private Integer priority(FGEdge e) {
            FlowType type = e.getFlowType();
            if (type == RefType.FALL_THROUGH) {
                return 1;
            }
            return 10;
        }
    }

    private class FGTempGraph
    extends AbstractBaseGraph<FGVertex, FGEdge> {
        protected FGTempGraph() {
            super(null, null, (GraphType)DefaultGraphType.directedPseudograph());
        }
    }
}

