/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer;

import docking.widgets.OptionDialog;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationServer;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FGEdgeImpl;
import ghidra.app.plugin.core.functiongraph.graph.FGVertexType;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayout;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupHistoryInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.ListingFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.app.plugin.core.functiongraph.mvc.FGView;
import ghidra.app.plugin.core.functiongraph.util.job.GroupVertexFunctionGraphJob;
import ghidra.app.plugin.core.functiongraph.util.job.MergeVertexFunctionGraphJob;
import ghidra.app.plugin.core.functiongraph.util.job.SplitVertexFunctionGraphJob;
import ghidra.app.plugin.core.functiongraph.util.job.UngroupAllVertexFunctionGraphJob;
import ghidra.app.plugin.core.functiongraph.util.job.UngroupVertexFunctionGraphJob;
import ghidra.graph.VisualGraph;
import ghidra.graph.job.GraphJob;
import ghidra.graph.job.RelayoutFunctionGraphJob;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.layout.LayoutListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;

public class FGViewUpdater
extends VisualGraphViewUpdater<FGVertex, FGEdge> {
    public FGViewUpdater(GraphViewer<FGVertex, FGEdge> viewer, VisualGraph<FGVertex, FGEdge> graph) {
        super(viewer, graph);
    }

    public void relayoutGraph(FGController controller) {
        FGView view = controller.getView();
        GraphViewer viewer = view.getPrimaryGraphViewer();
        VisualGraphViewUpdater updater = viewer.getViewUpdater();
        updater.scheduleViewChangeJob((GraphJob)new RelayoutFunctionGraphJob(viewer, this.isAnimationEnabled()));
    }

    public void ungroupVertex(FGController controller, GroupedFunctionGraphVertex groupedVertex) {
        this.ungroupVertex(controller, groupedVertex, false);
    }

    public void ungroupVertex(FGController controller, GroupedFunctionGraphVertex groupedVertex, boolean isUngroupAll) {
        FunctionGraph functionGraph;
        this.stopAllNonMutativeAnimation();
        FGData functionGraphData = controller.getFunctionGraphData();
        FunctionGraph graph = functionGraph = functionGraphData.getFunctionGraph();
        if (!graph.containsVertex(groupedVertex)) {
            throw new IllegalArgumentException("Cannot ungroup a vertex that is not in the graph!: " + groupedVertex.getUserText());
        }
        Set<FGVertex> vertices = groupedVertex.getVertices();
        for (FGVertex fGVertex : vertices) {
            graph.addVertex(fGVertex);
        }
        Set<FGEdge> ungroupedIncomingEdges = groupedVertex.getUngroupedEdges();
        for (FGEdge edge : ungroupedIncomingEdges) {
            this.validateAndAddEdge(controller, functionGraph, groupedVertex, edge);
        }
        UngroupVertexFunctionGraphJob ungroupVertexFunctionGraphJob = new UngroupVertexFunctionGraphJob(controller, groupedVertex, this.isAnimationEnabled(), isUngroupAll);
        this.scheduleViewChangeJob((GraphJob)ungroupVertexFunctionGraphJob);
    }

    private void validateAndAddEdge(FGController controller, FunctionGraph functionGraph, GroupedFunctionGraphVertex groupedVertex, FGEdge edge) {
        FunctionGraph graph = functionGraph;
        FGVertex startVertex = this.updateEdgeVertexForUngrouping(functionGraph, groupedVertex, (FGVertex)edge.getStart());
        FGVertex destinationVertex = this.updateEdgeVertexForUngrouping(functionGraph, groupedVertex, (FGVertex)edge.getEnd());
        if (edge.getStart() != startVertex || edge.getEnd() != destinationVertex) {
            edge = edge.cloneEdge(startVertex, destinationVertex);
        }
        graph.addEdge(edge, startVertex, destinationVertex);
    }

    public FGVertex updateEdgeVertexForUngrouping(FunctionGraph functionGraph, GroupedFunctionGraphVertex groupedVertex, FGVertex originalVertex) {
        FunctionGraph graph = functionGraph;
        if (graph.containsVertex(originalVertex)) {
            return originalVertex;
        }
        Address address = originalVertex.getVertexAddress();
        Collection vertices = graph.getVertices();
        for (FGVertex vertex : vertices) {
            if (!vertex.containsAddress(address) || vertex.equals(groupedVertex)) continue;
            return vertex;
        }
        throw new AssertException("Cannot find any vertex for address: " + String.valueOf(address));
    }

    public void ungroupAllVertices(FGController controller) {
        FunctionGraph functionGraph;
        FGData functionGraphData = controller.getFunctionGraphData();
        FunctionGraph graph = functionGraph = functionGraphData.getFunctionGraph();
        Collection vertices = graph.getVertices();
        HashSet<GroupedFunctionGraphVertex> groupVertices = new HashSet<GroupedFunctionGraphVertex>();
        for (FGVertex vertex : vertices) {
            if (!(vertex instanceof GroupedFunctionGraphVertex)) continue;
            groupVertices.add((GroupedFunctionGraphVertex)vertex);
        }
        if (groupVertices.size() == 0) {
            return;
        }
        this.ungroupVertex(controller, (GroupedFunctionGraphVertex)groupVertices.iterator().next(), true);
        this.scheduleViewChangeJob(new UngroupAllVertexFunctionGraphJob(controller));
    }

    public void addToGroup(FGController controller, GroupedFunctionGraphVertex groupVertex, Set<FGVertex> groupedVertices) {
        FunctionGraph functionGraph;
        JComponent viewComponent;
        String text;
        this.stopAllNonMutativeAnimation();
        groupedVertices.remove(groupVertex);
        String currentText = groupVertex.getUserText();
        String defaultText = GroupedFunctionGraphVertex.generateGroupVertexDescription(groupVertex.getVertices());
        if (currentText.equals(defaultText)) {
            HashSet<FGVertex> allGroupedVertices = new HashSet<FGVertex>(groupedVertices);
            allGroupedVertices.addAll(groupVertex.getVertices());
            currentText = GroupedFunctionGraphVertex.generateGroupVertexDescription(allGroupedVertices);
        }
        if ((text = this.promptUserForGroupVertexText(viewComponent = controller.getViewComponent(), currentText, groupedVertices)) == null) {
            return;
        }
        FGData functionGraphData = controller.getFunctionGraphData();
        FunctionGraph graph = functionGraph = functionGraphData.getFunctionGraph();
        HashSet<FGEdge> ungroupedEdges = new HashSet<FGEdge>();
        this.accumulateUngroupedIncidentEdges((Graph<FGVertex, FGEdge>)graph, groupedVertices, ungroupedEdges);
        this.createNewGroupedEdges(controller, groupVertex, ungroupedEdges);
        GroupedFunctionGraphVertex newGroupVertex = groupVertex.derriveGroupVertex(groupedVertices, text, ungroupedEdges);
        this.swapVertices(controller, groupVertex, newGroupVertex);
        GroupVertexFunctionGraphJob job = GroupVertexFunctionGraphJob.createUpdateGroupJob(controller, newGroupVertex, groupedVertices, this.isAnimationEnabled());
        this.scheduleViewChangeJob((GraphJob)job);
    }

    private void swapVertices(FGController controller, GroupedFunctionGraphVertex oldGroupVertex, GroupedFunctionGraphVertex newGroupVertex) {
        FunctionGraph functionGraph;
        FGData functionGraphData = controller.getFunctionGraphData();
        FunctionGraph graph = functionGraph = functionGraphData.getFunctionGraph();
        Collection inEdges = graph.getInEdges(oldGroupVertex);
        Collection outEdges = graph.getOutEdges(oldGroupVertex);
        graph.addVertex(newGroupVertex);
        FGView view = controller.getView();
        GraphViewer viewer = view.getPrimaryGraphViewer();
        Layout graphLayout = viewer.getGraphLayout();
        Point2D location = (Point2D)graphLayout.apply((Object)oldGroupVertex);
        graphLayout.setLocation((Object)newGroupVertex, (Point2D)location.clone());
        for (FGEdge edge : inEdges) {
            FGVertex startVertex = (FGVertex)edge.getStart();
            FGEdge clonedEdge = edge.cloneEdge(startVertex, newGroupVertex);
            graph.addEdge(clonedEdge, startVertex, newGroupVertex);
        }
        for (FGEdge edge : outEdges) {
            FGVertex destinationVertex = (FGVertex)edge.getEnd();
            graph.addEdge(edge.cloneEdge(newGroupVertex, destinationVertex), newGroupVertex, destinationVertex);
        }
        graph.removeVertex(oldGroupVertex);
    }

    public void regroupVertices(FGController controller, FGVertex vertex) {
        FGData functionGraphData = controller.getFunctionGraphData();
        FunctionGraph functionGraph = functionGraphData.getFunctionGraph();
        GroupHistoryInfo groupHistory = functionGraph.getGroupHistory(vertex);
        if (groupHistory == null) {
            throw new AssertException("Cannot find group history for regroup operation!");
        }
        HashSet<FGVertex> vertices = new HashSet<FGVertex>(groupHistory.getVertices());
        Point2D location = groupHistory.getGroupLocation();
        if (location == null) {
            FGView view = controller.getView();
            GraphViewer viewer = view.getPrimaryGraphViewer();
            Rectangle containingBounds = GraphViewerUtils.getBoundsForVerticesInLayoutSpace((VisualizationServer)viewer, vertices);
            location = new Point2D.Double(containingBounds.getCenterX(), containingBounds.getCenterY());
        }
        this.fixupVerticesForUncollapsedGroupMembers((Graph<FGVertex, FGEdge>)functionGraph, vertices);
        String text = groupHistory.getGroupDescription();
        this.groupVertices(controller, text, vertices, location, true);
    }

    private void fixupVerticesForUncollapsedGroupMembers(Graph<FGVertex, FGEdge> graph, Set<FGVertex> fixupVertices) {
        HashSet<FGVertex> updatedChildren = new HashSet<FGVertex>();
        Iterator<FGVertex> iterator = fixupVertices.iterator();
        while (iterator.hasNext()) {
            FGVertex vertex = iterator.next();
            if (graph.containsVertex((Object)vertex) || !(vertex instanceof GroupedFunctionGraphVertex)) continue;
            GroupedFunctionGraphVertex groupedVertex = (GroupedFunctionGraphVertex)vertex;
            HashSet<FGVertex> dependentVertices = new HashSet<FGVertex>(groupedVertex.getVertices());
            this.fixupVerticesForUncollapsedGroupMembers(graph, dependentVertices);
            iterator.remove();
            updatedChildren.addAll(dependentVertices);
        }
        fixupVertices.addAll(updatedChildren);
    }

    public void groupSelectedVertices(FGController controller) {
        this.groupSelectedVertices(controller, null);
    }

    public void groupSelectedVertices(FGController controller, Point2D location) {
        FGVertex vertex;
        Set<FGVertex> selectedVertices = controller.getSelectedVertices();
        int vertexCount = selectedVertices.size();
        if (vertexCount == 1 && (vertex = selectedVertices.iterator().next()) instanceof GroupedFunctionGraphVertex) {
            FGView view = controller.getView();
            Msg.showInfo(FGViewUpdater.class, (Component)view.getPrimaryGraphViewer(), (String)"Cannot Group a Single Group Vertex", (Object)"You cannot create a group vertex from a single group vertex");
            return;
        }
        JComponent viewComponent = controller.getViewComponent();
        String text = this.promptUserForGroupVertexText(viewComponent, null, selectedVertices);
        if (text == null) {
            return;
        }
        if (location == null) {
            FGView view = controller.getView();
            GraphViewer viewer = view.getPrimaryGraphViewer();
            Rectangle containingBounds = GraphViewerUtils.getBoundsForVerticesInLayoutSpace((VisualizationServer)viewer, selectedVertices);
            location = new Point2D.Double(containingBounds.getCenterX(), containingBounds.getCenterY());
        }
        this.groupVertices(controller, text, selectedVertices, location);
    }

    public String promptUserForGroupVertexText(JComponent centerOverComponent, String currentText, Set<FGVertex> selectedVertices) {
        String text = currentText == null ? GroupedFunctionGraphVertex.generateGroupVertexDescription(selectedVertices) : currentText;
        return OptionDialog.showInputMultilineDialog((Component)centerOverComponent, (String)"Enter Group Vertex Text", (String)"Text", (String)text);
    }

    public void groupVertices(FGController controller, String groupVertexText, Set<FGVertex> groupedVertices, Point2D groupVertexLocation) {
        this.groupVertices(controller, groupVertexText, groupedVertices, groupVertexLocation, false);
    }

    private void groupVertices(FGController controller, String groupVertexText, Set<FGVertex> groupedVertices, Point2D groupVertexLocation, boolean isRegroup) {
        FunctionGraph functionGraph;
        FGVertex vertex;
        int vertexCount = groupedVertices.size();
        if (vertexCount == 0) {
            return;
        }
        if (vertexCount == 1 && (vertex = groupedVertices.iterator().next()) instanceof GroupedFunctionGraphVertex) {
            Msg.showInfo(FGViewUpdater.class, null, (String)"Cannot Group a Single Group Vertex", (Object)"You cannot create a group vertex from a single group vertex");
            return;
        }
        FGData functionGraphData = controller.getFunctionGraphData();
        FunctionGraph graph = functionGraph = functionGraphData.getFunctionGraph();
        HashSet<FGEdge> ungroupedEdges = new HashSet<FGEdge>();
        this.accumulateUngroupedIncidentEdges((Graph<FGVertex, FGEdge>)graph, groupedVertices, ungroupedEdges);
        GroupedFunctionGraphVertex groupVertex = new GroupedFunctionGraphVertex(controller, groupVertexText, groupedVertices, ungroupedEdges);
        boolean relayoutOverride = false;
        this.installGroupVertex(controller, groupVertex, groupVertexLocation, relayoutOverride, this.isAnimationEnabled(), isRegroup);
    }

    public boolean installGroupVertex(FGController controller, GroupedFunctionGraphVertex groupVertex, Point2D groupVertexLocation) {
        return this.installGroupVertex(controller, groupVertex, groupVertexLocation, false, false, false);
    }

    private boolean installGroupVertex(FGController controller, GroupedFunctionGraphVertex groupVertex, Point2D groupVertexLocation, boolean relayoutOverride, boolean animate, boolean isRegroup) {
        boolean doAnimate = animate & this.isAnimationEnabled();
        if (groupVertex.getVertices().size() == 0) {
            return false;
        }
        this.stopAllNonMutativeAnimation();
        FGData data = controller.getFunctionGraphData();
        FunctionGraph graph = data.getFunctionGraph();
        FGLayout fgLayout = graph.getLayout();
        fgLayout.setLocation(groupVertex, groupVertexLocation, LayoutListener.ChangeType.TRANSIENT);
        graph.addVertex(groupVertex);
        Set<FGEdge> ungroupedEdges = groupVertex.getUngroupedEdges();
        this.createNewGroupedEdges(controller, groupVertex, ungroupedEdges);
        GroupVertexFunctionGraphJob job = isRegroup ? GroupVertexFunctionGraphJob.createRegroupJob(controller, groupVertex, groupVertexLocation, relayoutOverride, doAnimate) : GroupVertexFunctionGraphJob.createNewGroupJob(controller, groupVertex, groupVertexLocation, relayoutOverride, doAnimate);
        this.scheduleViewChangeJob((GraphJob)job);
        return true;
    }

    private void accumulateUngroupedIncidentEdges(Graph<FGVertex, FGEdge> graph, Set<FGVertex> ungroupedVertices, Set<FGEdge> ungroupedEdges) {
        for (FGVertex vertex : ungroupedVertices) {
            Collection inEdges = graph.getInEdges((Object)vertex);
            if (inEdges == null) {
                throw new AssertException("cannot group vertex--it is not in the graph: " + vertex.getTitle());
            }
            for (FGEdge edge : inEdges) {
                ungroupedEdges.add(edge);
            }
            Collection outEdges = graph.getOutEdges((Object)vertex);
            for (FGEdge edge : outEdges) {
                ungroupedEdges.add(edge);
            }
        }
    }

    private void createNewGroupedEdges(FGController controller, GroupedFunctionGraphVertex groupVertex, Set<FGEdge> ungroupedEdges) {
        FGEdge clonedEdge;
        FGData functionGraphData = controller.getFunctionGraphData();
        FunctionGraph graph = functionGraphData.getFunctionGraph();
        Set<FGVertex> vertices = groupVertex.getVertices();
        for (FGEdge edge : ungroupedEdges) {
            FGVertex startVertex = (FGVertex)edge.getStart();
            if (vertices.contains(startVertex) || !graph.containsVertex(startVertex) && vertices.contains(startVertex = graph.findMatchingVertex(startVertex)) || startVertex == groupVertex) continue;
            clonedEdge = edge.cloneEdge(startVertex, groupVertex);
            graph.addEdge(clonedEdge, startVertex, groupVertex);
        }
        for (FGEdge edge : ungroupedEdges) {
            FGVertex destinationVertex = (FGVertex)edge.getEnd();
            if (vertices.contains(destinationVertex) || !graph.containsVertex(destinationVertex) && vertices.contains(destinationVertex = graph.findMatchingVertex(destinationVertex)) || destinationVertex == groupVertex) continue;
            clonedEdge = edge.cloneEdge(groupVertex, destinationVertex);
            graph.addEdge(clonedEdge, groupVertex, destinationVertex);
        }
    }

    public void splitVertex(FGController controller, FGVertex vertexToSplit, Address newVertexMinAddress) {
        if (vertexToSplit instanceof GroupedFunctionGraphVertex) {
            return;
        }
        this.stopAllAnimation();
        FGView view = controller.getView();
        GraphViewer primaryViewer = view.getPrimaryGraphViewer();
        Layout graphLayout = primaryViewer.getGraphLayout();
        Graph graph = graphLayout.getGraph();
        boolean isOldVertexAnEntry = vertexToSplit.isEntry();
        FlowType oldFlowType = vertexToSplit.getFlowType();
        FGVertexType oldVertexType = vertexToSplit.getVertexType();
        AddressSetView oldAddresses = vertexToSplit.getAddresses();
        AddressSet newParentAddresses = new AddressSet();
        AddressSet newChildAddresses = new AddressSet();
        AddressIterator iterator = oldAddresses.getAddresses(newVertexMinAddress, true);
        while (iterator.hasNext()) {
            Address address = iterator.next();
            newChildAddresses.addRange(address, address);
        }
        newParentAddresses = oldAddresses.subtract((AddressSetView)newChildAddresses);
        ListingFunctionGraphVertex parentVertex = new ListingFunctionGraphVertex(controller, (AddressSetView)newParentAddresses, oldFlowType, isOldVertexAnEntry);
        ListingFunctionGraphVertex childVertex = new ListingFunctionGraphVertex(controller, (AddressSetView)newChildAddresses, RefType.FALL_THROUGH, false);
        if (oldVertexType == FGVertexType.SINGLETON) {
            parentVertex.setVertexType(FGVertexType.ENTRY);
            childVertex.setVertexType(FGVertexType.EXIT);
        } else if (oldVertexType.isEntry()) {
            parentVertex.setVertexType(oldVertexType);
            childVertex.setVertexType(FGVertexType.BODY);
        } else if (oldVertexType.isExit()) {
            parentVertex.setVertexType(FGVertexType.BODY);
            childVertex.setVertexType(oldVertexType);
        } else {
            parentVertex.setVertexType(oldVertexType);
            childVertex.setVertexType(oldVertexType);
        }
        graph.addVertex((Object)parentVertex);
        graph.addVertex((Object)childVertex);
        ArrayList oldInEdges = graph.getInEdges((Object)vertexToSplit);
        ArrayList oldOutEdges = graph.getOutEdges((Object)vertexToSplit);
        oldInEdges = new ArrayList(oldInEdges);
        oldOutEdges = new ArrayList(oldOutEdges);
        for (FGEdge edge : oldInEdges) {
            FGVertex oldStartVertex = (FGVertex)edge.getStart();
            FGEdge newEdge = edge.cloneEdge(oldStartVertex, parentVertex);
            graph.addEdge((Object)newEdge, (Object)oldStartVertex, (Object)parentVertex);
        }
        for (FGEdge edge : oldOutEdges) {
            FGVertex oldDestinationVertex = (FGVertex)edge.getEnd();
            graph.addEdge((Object)edge.cloneEdge(childVertex, oldDestinationVertex), (Object)childVertex, (Object)oldDestinationVertex);
        }
        FGEdgeImpl edge = new FGEdgeImpl(parentVertex, childVertex, RefType.FALL_THROUGH, controller.getFunctionGraphOptions());
        graph.addEdge((Object)edge, (Object)parentVertex, (Object)childVertex);
        SplitVertexFunctionGraphJob job = new SplitVertexFunctionGraphJob(controller, (VisualizationServer<FGVertex, FGEdge>)primaryViewer, vertexToSplit, parentVertex, childVertex, this.isAnimationEnabled());
        this.scheduleViewChangeJob((GraphJob)job);
    }

    public void mergeVertexWithParent(FGController controller, FGVertex childVertex) {
        if (childVertex instanceof GroupedFunctionGraphVertex) {
            return;
        }
        this.stopAllAnimation();
        FGView view = controller.getView();
        GraphViewer primaryViewer = view.getPrimaryGraphViewer();
        Layout graphLayout = primaryViewer.getGraphLayout();
        Graph graph = graphLayout.getGraph();
        Collection parentChildEdges = graph.getInEdges((Object)childVertex);
        FGEdge parentChildEdge = (FGEdge)parentChildEdges.iterator().next();
        FGVertex parentVertex = (FGVertex)parentChildEdge.getStart();
        if (parentVertex instanceof GroupedFunctionGraphVertex) {
            return;
        }
        AddressSet newAddresses = new AddressSet();
        newAddresses.add(parentVertex.getAddresses());
        newAddresses.add(childVertex.getAddresses());
        FlowType flowType = parentVertex.getFlowType();
        boolean isEntry = parentVertex.isEntry();
        ListingFunctionGraphVertex newVertex = new ListingFunctionGraphVertex(controller, (AddressSetView)newAddresses, flowType, isEntry);
        FGVertexType parentVertexType = parentVertex.getVertexType();
        FGVertexType childVertexType = childVertex.getVertexType();
        if (parentVertexType.isEntry() && childVertexType.isExit()) {
            newVertex.setVertexType(FGVertexType.SINGLETON);
        } else if (parentVertexType.isEntry()) {
            newVertex.setVertexType(FGVertexType.ENTRY);
        } else if (childVertexType.isExit()) {
            newVertex.setVertexType(FGVertexType.EXIT);
        } else {
            newVertex.setVertexType(parentVertexType);
        }
        graph.addVertex((Object)newVertex);
        ArrayList parentInEdges = graph.getInEdges((Object)parentVertex);
        parentInEdges = new ArrayList(parentInEdges);
        for (Object edge : parentInEdges) {
            FGVertex oldStartVertex = (FGVertex)edge.getStart();
            graph.addEdge((Object)edge.cloneEdge(oldStartVertex, newVertex), (Object)oldStartVertex, (Object)newVertex);
        }
        ArrayList childOutEdges = graph.getOutEdges((Object)childVertex);
        childOutEdges = new ArrayList(childOutEdges);
        for (FGEdge edge : childOutEdges) {
            FGVertex oldDestinationVertex = (FGVertex)edge.getEnd();
            graph.addEdge((Object)edge.cloneEdge(newVertex, oldDestinationVertex), (Object)newVertex, (Object)oldDestinationVertex);
        }
        MergeVertexFunctionGraphJob job = new MergeVertexFunctionGraphJob(controller, (VisualizationServer<FGVertex, FGEdge>)primaryViewer, newVertex, parentVertex, childVertex, this.isAnimationEnabled());
        this.scheduleViewChangeJob((GraphJob)job);
    }
}

