/*
 * Decompiled with CFR 0.152.
 */
package generic.test;

import generic.test.AbstractGenericTest;
import generic.test.ConcurrentTestExceptionHandler;
import generic.test.TestReportingException;
import generic.test.TestThread;
import ghidra.framework.ApplicationConfiguration;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.TaskUtilities;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import ghidra.util.task.AbstractSwingUpdateManager;
import ghidra.util.task.SwingUpdateManager;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import sun.awt.AppContext;
import utility.function.ExceptionalCallback;

public class AbstractGuiTest
extends AbstractGenericTest {
    protected ApplicationConfiguration createApplicationConfiguration() {
        return new ApplicationConfiguration(this){

            public boolean isHeadless() {
                return false;
            }
        };
    }

    public static Set<Window> getAllWindows() {
        Window[] windows;
        HashSet<Window> set = new HashSet<Window>();
        Frame sharedOwnerFrame = (Frame)AppContext.getAppContext().get(new StringBuffer("SwingUtilities.sharedOwnerFrame"));
        if (sharedOwnerFrame != null) {
            set.addAll(AbstractGuiTest.getAllWindows(sharedOwnerFrame));
        }
        for (Frame frame : Frame.getFrames()) {
            set.addAll(AbstractGuiTest.getAllWindows(frame));
        }
        for (Window window : windows = Window.getWindows()) {
            set.add(window);
        }
        return set;
    }

    private static List<Window> getAllWindows(Window parent) {
        ArrayList<Window> list = new ArrayList<Window>();
        list.add(parent);
        for (Window w : parent.getOwnedWindows()) {
            list.add(w);
        }
        return list;
    }

    public static void waitForTasks() {
        AbstractGuiTest.waitForTasks(PRIVATE_LONG_WAIT_TIMEOUT);
    }

    public static void waitForTasks(long timeout) {
        AbstractGuiTest.waitForSwing();
        long time = 0L;
        while (TaskUtilities.isExecutingTasks()) {
            if ((time += AbstractGuiTest.sleep((long)DEFAULT_WAIT_DELAY)) < timeout) continue;
            Msg.error(AbstractGenericTest.class, (Object)AbstractGuiTest.createStackTraceForAllThreads());
            throw new AssertionFailedError("Time expired waiting for tasks to complete.");
        }
        AbstractGuiTest.waitForSwing();
    }

    @Deprecated(forRemoval=true, since="10.3")
    public static void waitForPostedSwingRunnables() {
        AbstractGuiTest.waitForSwing();
    }

    public static <T extends Component> T findComponent(Container parent, Class<T> desiredClass) {
        return AbstractGuiTest.findComponent(parent, desiredClass, false);
    }

    public static <T extends Component> T findComponent(Container parent, Class<T> desiredClass, boolean checkOwnedWindows) {
        Component[] comps;
        for (Component element : comps = parent.getComponents()) {
            T c;
            if (element == null) continue;
            if (desiredClass.isAssignableFrom(element.getClass())) {
                return (T)((Component)desiredClass.cast(element));
            }
            if (!(element instanceof Container) || (c = AbstractGuiTest.findComponent((Container)element, desiredClass, checkOwnedWindows)) == null) continue;
            return (T)((Component)desiredClass.cast(c));
        }
        if (checkOwnedWindows && parent instanceof Window) {
            Window[] windows = ((Window)parent).getOwnedWindows();
            for (int i = windows.length - 1; i >= 0; --i) {
                T c = AbstractGuiTest.findComponent(windows[i], desiredClass, checkOwnedWindows);
                if (c == null) continue;
                return (T)((Component)desiredClass.cast(c));
            }
        }
        return null;
    }

    public static <T extends Component> List<T> findComponents(Container parent, Class<T> desiredClass) {
        return AbstractGuiTest.findComponents(parent, desiredClass, false);
    }

    public static <T extends Component> List<T> findComponents(Container parent, Class<T> desiredClass, boolean checkOwnedWindows) {
        Component[] comps = parent.getComponents();
        ArrayList<Component> list = new ArrayList<Component>();
        for (Component element : comps) {
            T c;
            if (element == null) continue;
            if (desiredClass.isAssignableFrom(element.getClass())) {
                list.add((Component)desiredClass.cast(element));
                continue;
            }
            if (!(element instanceof Container) || (c = AbstractGuiTest.findComponent((Container)element, desiredClass, checkOwnedWindows)) == null) continue;
            list.add((Component)desiredClass.cast(c));
        }
        if (checkOwnedWindows && parent instanceof Window) {
            Window[] windows = ((Window)parent).getOwnedWindows();
            for (int i = windows.length - 1; i >= 0; --i) {
                T c = AbstractGuiTest.findComponent(windows[i], desiredClass, checkOwnedWindows);
                if (c == null) continue;
                list.add((Component)desiredClass.cast(c));
            }
        }
        return list;
    }

    public static void findOwnedWindows(Window win, Set<Window> winList) {
        Window[] children;
        for (Window element : children = win.getOwnedWindows()) {
            winList.add(element);
            AbstractGuiTest.findOwnedWindows(element, winList);
        }
    }

    public static void pressButtonByText(Container container, String buttonText) {
        AbstractGuiTest.pressButtonByText(container, buttonText, true);
    }

    public static void pressButtonByText(Container container, String buttonText, boolean waitForCompletion) {
        AbstractButton button = AbstractGuiTest.findAbstractButtonByText(container, buttonText);
        if (button == null) {
            throw new AssertionError((Object)("Couldn't find button " + buttonText + "."));
        }
        if (!AbstractGuiTest.runSwing(() -> button.isShowing()).booleanValue()) {
            throw new AssertionError((Object)("Button " + buttonText + " is not showing."));
        }
        if (!AbstractGuiTest.runSwing(() -> button.isEnabled()).booleanValue()) {
            throw new AssertionError((Object)("Button " + buttonText + " is not enabled."));
        }
        AbstractGuiTest.pressButton(button, waitForCompletion);
    }

    public static void pressButtonByName(Container container, String buttonName) {
        AbstractGuiTest.pressButtonByName(container, buttonName, true);
    }

    public static void pressButtonByName(Container container, String buttonName, boolean waitForCompletion) {
        AbstractButton button = (AbstractButton)AbstractGuiTest.findComponentByName(container, buttonName);
        if (button == null) {
            throw new AssertionError((Object)("Couldn't find button " + buttonName + "."));
        }
        if (!AbstractGuiTest.runSwing(() -> button.isShowing()).booleanValue()) {
            throw new AssertionError((Object)("Button " + buttonName + " is not showing."));
        }
        if (!AbstractGuiTest.runSwing(() -> button.isEnabled()).booleanValue()) {
            throw new AssertionError((Object)("Button " + buttonName + " is not enabled."));
        }
        AbstractGuiTest.pressButton(button, waitForCompletion);
    }

    public static void pressButton(AbstractButton button) {
        if (!button.isEnabled()) {
            throw new AssertException("Attempted to press a disabled button");
        }
        AbstractGuiTest.pressButton(button, true);
    }

    public static void pressButton(AbstractButton button, boolean waitForCompletion) {
        Runnable r = () -> button.doClick(0);
        AbstractGuiTest.runSwing(r, waitForCompletion);
    }

    public static Component findComponentByName(Container container, String componentName) {
        return AbstractGuiTest.findComponentByName(container, componentName, false);
    }

    public static Component findComponentByName(Container container, String componentName, boolean checkOwnedWindows) {
        Component[] comps;
        String containerName = container.getName();
        if (containerName != null && container.getName().equals(componentName)) {
            return container;
        }
        for (Component element : comps = container.getComponents()) {
            Component comp;
            if (element == null) continue;
            String name = element.getName();
            if (name != null && name.equals(componentName)) {
                return element;
            }
            if (!(element instanceof Container) || (comp = AbstractGuiTest.findComponentByName((Container)element, componentName, checkOwnedWindows)) == null) continue;
            return comp;
        }
        if (checkOwnedWindows && container instanceof Window) {
            Window[] windows = ((Window)container).getOwnedWindows();
            for (int i = windows.length - 1; i >= 0; --i) {
                Component c = AbstractGuiTest.findComponentByName(windows[i], componentName, checkOwnedWindows);
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }

    public static JButton findButtonByIcon(Container container, Icon icon) {
        Component[] comps;
        for (Component element : comps = container.getComponents()) {
            JButton button;
            Icon buttonIcon;
            if (!(element instanceof JButton ? icon.equals(buttonIcon = (button = (JButton)element).getIcon()) : element instanceof Container && (button = AbstractGuiTest.findButtonByIcon((Container)element, icon)) != null)) continue;
            return button;
        }
        return null;
    }

    public static JButton findButtonByText(Container container, String text) {
        Component[] comps;
        for (Component element : comps = container.getComponents()) {
            JButton button;
            if (!(element instanceof JButton ? (button = (JButton)element).getText() != null && button.getText().equals(text) : element instanceof Container && (button = AbstractGuiTest.findButtonByText((Container)element, text)) != null)) continue;
            return button;
        }
        return null;
    }

    public static AbstractButton findButtonByName(Container container, String name) {
        return AbstractGuiTest.findAbstractButtonByName(container, name);
    }

    public static AbstractButton findAbstractButtonByText(Container container, String text) {
        Component[] comp;
        for (Component element : comp = container.getComponents()) {
            AbstractButton b;
            if (element instanceof AbstractButton && text.equals(((AbstractButton)element).getText())) {
                return (AbstractButton)element;
            }
            if (!(element instanceof Container) || (b = AbstractGuiTest.findAbstractButtonByText((Container)element, text)) == null) continue;
            return b;
        }
        return null;
    }

    public static AbstractButton findAbstractButtonByName(Container container, String name) {
        Component[] comp;
        for (Component element : comp = container.getComponents()) {
            AbstractButton b;
            if (element instanceof AbstractButton && name.equals(((AbstractButton)element).getName())) {
                return (AbstractButton)element;
            }
            if (!(element instanceof Container) || (b = AbstractGuiTest.findAbstractButtonByName((Container)element, name)) == null) continue;
            return b;
        }
        return null;
    }

    public static void leftClick(JComponent comp, int x, int y) {
        AbstractGuiTest.clickMouse(comp, 1, x, y, 1, 0);
    }

    public static void middleClick(JComponent comp, int x, int y) {
        AbstractGuiTest.clickMouse(comp, 2, x, y, 1, 0);
    }

    public static void rightClick(JComponent comp, int x, int y) {
        AbstractGuiTest.clickMouse(comp, 3, x, y, 1, 0, true);
    }

    public static void doubleClick(JComponent comp, int x, int y) {
        AbstractGuiTest.clickMouse(comp, 1, x, y, 2, 0);
    }

    public static void clickMouse(Component comp, int button, int x, int y, int clickCount, int modifiers, boolean popupTrigger) {
        int nonRelesedModifiers = AbstractGuiTest.convertToExtendedModifiers(modifiers, button, false);
        int relesedModifiers = AbstractGuiTest.convertToExtendedModifiers(modifiers, button, true);
        for (int cnt = 1; cnt <= clickCount; ++cnt) {
            AbstractGuiTest.postEvent(new MouseEvent(comp, 501, System.currentTimeMillis(), nonRelesedModifiers, x, y, cnt, false, button));
            AbstractGuiTest.postEvent(new MouseEvent(comp, 500, System.currentTimeMillis(), nonRelesedModifiers, x, y, cnt, false, button));
            AbstractGuiTest.postEvent(new MouseEvent(comp, 502, System.currentTimeMillis(), relesedModifiers, x, y, cnt, popupTrigger, button));
        }
    }

    public static void clickMouse(Component comp, int button, int x, int y, int clickCount, int modifiers) {
        AbstractGuiTest.clickMouse(comp, button, x, y, clickCount, modifiers, false);
    }

    public static void dragMouse(Component comp, int button, int startX, int startY, int endX, int endY, int modifiers) {
        int nonRelesedModifiers = AbstractGuiTest.convertToExtendedModifiers(modifiers, button, false);
        int relesedModifiers = AbstractGuiTest.convertToExtendedModifiers(modifiers, button, true);
        AbstractGuiTest.postEvent(new MouseEvent(comp, 501, System.currentTimeMillis(), nonRelesedModifiers, startX, startY, 1, false, button));
        AbstractGuiTest.postEvent(new MouseEvent(comp, 506, System.currentTimeMillis(), nonRelesedModifiers, endX, endY, 1, false, button));
        AbstractGuiTest.postEvent(new MouseEvent(comp, 502, System.currentTimeMillis(), relesedModifiers, endX, endY, 1, false, button));
    }

    public static void moveMouse(Component comp, int x, int y) {
        AbstractGuiTest.postEvent(new MouseEvent(comp, 503, System.currentTimeMillis(), 0, x, y, 0, false));
    }

    private static int convertToExtendedModifiers(int modifiers, int button, boolean isRelease) {
        int controlMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        if ((modifiers & 0x80) == 128) {
            modifiers ^= 0x80;
            modifiers |= controlMask;
        }
        if ((modifiers & 2) == 2) {
            modifiers ^= 2;
            modifiers |= controlMask;
        }
        if ((modifiers & 2) == 2) {
            modifiers ^= 2;
            modifiers |= controlMask;
        }
        if ((modifiers & 1) == 1) {
            modifiers ^= 1;
            modifiers |= 0x40;
        }
        if ((modifiers & 8) == 8) {
            modifiers ^= 8;
            modifiers |= 0x200;
        }
        if ((modifiers & 4) == 4) {
            modifiers ^= 4;
            modifiers |= 0x100;
        }
        if (!isRelease) {
            switch (button) {
                case 1: {
                    modifiers |= 0x400;
                    break;
                }
                case 2: {
                    modifiers |= 0x800;
                    break;
                }
                case 3: {
                    modifiers |= 0x1000;
                }
            }
        }
        return modifiers;
    }

    public static void postEvent(AWTEvent ev) {
        AbstractGuiTest.runSwing(() -> {
            EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eq.postEvent(ev);
        });
        AbstractGuiTest.waitForSwing();
    }

    public static <T> T getSwing(Supplier<T> s) {
        AtomicReference ref = new AtomicReference();
        AbstractGuiTest.runSwing(() -> ref.set(s.get()));
        return (T)ref.get();
    }

    public static <T> T runSwing(Supplier<T> s) {
        return AbstractGuiTest.getSwing(s);
    }

    public static void runSwing(Runnable r) {
        AbstractGuiTest.runSwing(r, true);
    }

    public void runSwingLater(Runnable r) {
        AbstractGuiTest.runSwing(r, false);
    }

    public static <E extends Exception> void runSwingWithException(ExceptionalCallback<E> callback) throws Exception {
        if (Swing.isSwingThread()) {
            throw new AssertException("Unexpectedly called from the Swing thread");
        }
        ExceptionHandlingRunner exceptionHandlingRunner = new ExceptionHandlingRunner(callback);
        Throwable throwable = exceptionHandlingRunner.getException();
        if (throwable == null) {
            return;
        }
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        throw new AssertException(throwable);
    }

    public static void runSwing(Runnable runnable, boolean wait) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
            return;
        }
        if (wait) {
            AbstractGuiTest.runSwingAndWait(runnable);
            return;
        }
        Runnable swingExceptionCatcher = () -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                ConcurrentTestExceptionHandler.handle((Thread)Thread.currentThread(), (Throwable)t);
            }
        };
        SwingUtilities.invokeLater(swingExceptionCatcher);
    }

    private static void runSwingAndWait(Runnable runnable) {
        ExceptionHandlingRunner exceptionHandlingRunner = new ExceptionHandlingRunner(runnable);
        Throwable throwable = exceptionHandlingRunner.getException();
        if (throwable == null) {
            return;
        }
        if (!TestThread.isTestThread()) {
            ConcurrentTestExceptionHandler.handle((Thread)Thread.currentThread(), (Throwable)throwable);
            return;
        }
        String message = "Exception in Swing thread via runSwingAndWait():";
        if (!BATCH_MODE) {
            TestReportingException exception = TestReportingException.fromSwingThread((String)message, (Throwable)throwable);
            throw exception;
        }
        String string = TestReportingException.getSwingThreadTraceString((Throwable)throwable);
        Assert.fail((String)(message + "\n" + string + "\nTest Thread stack at that time:"));
    }

    public static void executeOnSwingWithoutBlocking(final Runnable runnable) {
        final AtomicBoolean didRun = new AtomicBoolean();
        new Thread(){

            @Override
            public void run() {
                didRun.set(true);
                AbstractGuiTest.runSwing(runnable);
            }
        }.start();
        AbstractGuiTest.waitForSwing();
        AbstractGuiTest.waitForCondition(() -> didRun.get());
        AbstractGuiTest.sleep((long)DEFAULT_WAIT_DELAY);
        AbstractGuiTest.waitForSwing();
    }

    public static void clickTableCell(JTable table, int row, int col, int clickCount) {
        AbstractGuiTest.runSwing(() -> table.setRowSelectionInterval(row, row));
        AbstractGuiTest.waitForSwing();
        Rectangle rect = table.getCellRect(row, col, true);
        AbstractGuiTest.clickMouse(table, 1, rect.x + 10, rect.y + 10, clickCount, 0);
        AbstractGuiTest.waitForSwing();
    }

    public static void clickListRange(JList<?> list, int row, int count) {
        AbstractGuiTest.waitForSwing();
        for (int i = row; i < row + count; ++i) {
            Rectangle rect = list.getCellBounds(i, i);
            AbstractGuiTest.clickMouse(list, 1, rect.x + 10, rect.y + 10, 1, 64);
        }
        AbstractGuiTest.waitForSwing();
    }

    public static void clickTableRange(JTable table, int row, int count) {
        AbstractGuiTest.waitForSwing();
        for (int i = row; i < row + count; ++i) {
            Rectangle rect = table.getCellRect(i, 0, true);
            AbstractGuiTest.clickMouse(table, 1, rect.x + 10, rect.y + 10, 1, 64);
        }
        AbstractGuiTest.waitForSwing();
    }

    public static TableCellEditor editCell(JTable table, int row, int col) {
        AbstractGuiTest.waitForSwing();
        AbstractGuiTest.runSwing(() -> table.setRowSelectionInterval(row, row));
        AbstractGuiTest.waitForSwing();
        AbstractGuiTest.runSwing(() -> table.editCellAt(row, col));
        AbstractGuiTest.waitForSwing();
        TableCellEditor editor = table.getCellEditor(row, col);
        Assert.assertNotNull((String)("Unable to edit table cell at " + row + ", " + col), (Object)editor);
        return editor;
    }

    public static String getRenderedTableCellValue(JTable table, int row, int column) {
        return AbstractGuiTest.runSwing(() -> {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            if (renderer == null) {
                throw new IllegalArgumentException("No renderer registered for row/col: " + row + "/" + column);
            }
            Component component = table.prepareRenderer(renderer, row, column);
            if (!(component instanceof JLabel)) {
                throw new IllegalArgumentException("Do not know how to get text from a renderer that is not a JLabel");
            }
            return ((JLabel)component).getText();
        });
    }

    public static <T> void setComboBoxSelection(JComboBox<T> comboField, T selection) {
        AbstractGuiTest.runSwing(() -> comboField.setSelectedItem(selection));
        AbstractGuiTest.waitForSwing();
    }

    public static void setText(JTextComponent field, String text) {
        AbstractGuiTest.runSwing(() -> field.setText(text));
        AbstractGuiTest.waitForSwing();
    }

    public static String getText(JTextComponent field) {
        return AbstractGuiTest.runSwing(() -> field.getText());
    }

    public static TreePath findTreePathToText(JTree tree, String text) {
        TreeModel tm = tree.getModel();
        TreeNode rootNode = (TreeNode)tm.getRoot();
        TreePath rootPath = new TreePath(rootNode);
        return AbstractGuiTest.findPathToText(tree, rootPath, text);
    }

    protected static TreePath findPathToText(JTree tree, TreePath startTreePath, String text) {
        if (text.equals(startTreePath.getLastPathComponent().toString())) {
            return startTreePath;
        }
        tree.expandPath(startTreePath);
        int len = startTreePath.getPathCount();
        Object[] tpObjects = new Object[len + 1];
        System.arraycopy(startTreePath.getPath(), 0, tpObjects, 0, len);
        TreeNode treeNode = (TreeNode)startTreePath.getLastPathComponent();
        int num = treeNode.getChildCount();
        for (int i = 0; i < num; ++i) {
            TreeNode childNode = treeNode.getChildAt(i);
            tpObjects[len] = childNode;
            TreePath childPath = new TreePath(tpObjects);
            TreePath treePath = AbstractGuiTest.findPathToText(tree, childPath, text);
            if (treePath == null) continue;
            return treePath;
        }
        return null;
    }

    public static void fixupGUI() throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                // empty catch block
            }
        });
        Font f = new Font("monospaced", 0, 12);
        UIManager.put("PasswordField.font", f);
        UIManager.put("TextArea.font", f);
    }

    public void assertColorsEqual(Color expected, Color actual) {
        if (expected.getRGB() == actual.getRGB()) {
            return;
        }
        Assert.fail((String)("Expected: [" + expected.getClass().getSimpleName() + "]" + String.valueOf(expected) + ", but got: [" + actual.getClass().getSimpleName() + "]" + String.valueOf(actual)));
    }

    public static void printMemory() {
        AbstractGuiTest.yieldToSwing();
        System.gc();
        AbstractGuiTest.yieldToSwing();
        System.gc();
        AbstractGuiTest.yieldToSwing();
        System.gc();
        Runtime runTime = Runtime.getRuntime();
        System.out.println("----------------------");
        System.out.printf("Max:   %,10dK\n", runTime.maxMemory() / 1000L);
        System.out.printf("Total: %,10dK\n", runTime.totalMemory() / 1000L);
        System.out.printf("Free:  %,10dK\n", runTime.freeMemory() / 1000L);
        System.out.printf("Used:  %,10dK\n", (runTime.totalMemory() - runTime.freeMemory()) / 1000L);
    }

    public static boolean waitForSwing() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new AssertException("Can't wait for swing from within the swing thread!");
        }
        HashSet<AbstractSwingUpdateManager> set = new HashSet<AbstractSwingUpdateManager>();
        AbstractGuiTest.runSwing(() -> {
            WeakSet s = (WeakSet)AbstractGuiTest.getInstanceField((String)"instances", SwingUpdateManager.class);
            for (AbstractSwingUpdateManager manager : s) {
                set.add(manager);
            }
        });
        boolean wasEverBusy = AbstractGuiTest.waitForSwing(set, true);
        return wasEverBusy;
    }

    private static boolean waitForSwing(Set<AbstractSwingUpdateManager> managers, boolean flush) {
        int MAX_SWING_TIMEOUT = 15000;
        int totalTime = 0;
        AbstractGuiTest.flushAllManagers(managers, flush);
        boolean wasEverBusy = false;
        boolean keepGoing = true;
        while (keepGoing) {
            AbstractGuiTest.yieldToSwing();
            keepGoing = false;
            for (AbstractSwingUpdateManager manager : managers) {
                if (!manager.isBusy()) continue;
                AbstractGuiTest.doFlush(flush, manager);
                boolean isBusy = true;
                while (isBusy) {
                    keepGoing = true;
                    wasEverBusy = true;
                    if ((totalTime = (int)((long)totalTime + AbstractGuiTest.sleep((long)DEFAULT_WAIT_DELAY))) >= MAX_SWING_TIMEOUT) {
                        Msg.debug(AbstractGenericTest.class, (Object)("Timed-out waitinig for Swing after " + totalTime + " ms.  The currently waited SwingUpdateManager:\n" + manager.toStringDebug()));
                        return true;
                    }
                    isBusy = manager.isBusy();
                }
            }
            AbstractGuiTest.yieldToSwing();
        }
        return wasEverBusy;
    }

    private static void flushAllManagers(Set<AbstractSwingUpdateManager> managers, boolean flush) {
        int n = 3;
        for (int i = 0; i < n; ++i) {
            for (AbstractSwingUpdateManager manager : managers) {
                AbstractGuiTest.doFlush(flush, manager);
            }
        }
    }

    private static void doFlush(boolean doFlush, AbstractSwingUpdateManager manager) {
        if (!doFlush) {
            return;
        }
        AbstractGuiTest.runSwing(() -> manager.flush(), false);
        AbstractGuiTest.yieldToSwing();
    }

    @Deprecated
    public static void privatewaitForSwing_SwingSafe() {
        AbstractGuiTest.yieldToSwing();
    }

    protected static void yieldToSwing() {
        if (SwingUtilities.isEventDispatchThread()) {
            Msg.error(AbstractGenericTest.class, (Object)"Incorrectly called yieldToSwing() from the Swing thread");
            return;
        }
        Runnable empty = () -> {};
        for (int i = 0; i < 3; ++i) {
            try {
                SwingUtilities.invokeAndWait(empty);
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    protected static class ExceptionHandlingRunner {
        private final ExceptionalCallback<? extends Exception> delegateCallback;
        private Throwable exception;

        ExceptionHandlingRunner(Runnable delegateRunnable) {
            this.delegateCallback = () -> delegateRunnable.run();
            this.run();
        }

        ExceptionHandlingRunner(ExceptionalCallback<? extends Exception> delegateCallback) {
            this.delegateCallback = delegateCallback;
            this.run();
        }

        Throwable getException() {
            return this.exception;
        }

        String getExceptionMessage() {
            Throwable throwable = this.getException();
            String message = throwable.getMessage();
            if (message != null) {
                return message;
            }
            return this.getCauseExceptionMessage(throwable);
        }

        protected String getCauseExceptionMessage(Throwable t) {
            if (t == null) {
                return "<No Exception Message>";
            }
            if (t instanceof AssertionError) {
                return t.getMessage();
            }
            String message = t.getMessage();
            if (message != null) {
                return message;
            }
            return this.getCauseExceptionMessage(t.getCause());
        }

        private void run() {
            Runnable swingExceptionCatcher = () -> {
                try {
                    this.delegateCallback.call();
                }
                catch (Throwable t) {
                    this.exception = t;
                }
            };
            try {
                this.doRun(swingExceptionCatcher);
            }
            catch (InterruptedException e) {
                Msg.debug((Object)this, (Object)"\n>>>>>>>>>>>>>>>> Test thread interrupted.  Unusual/unexpected errors may follow.\n\n");
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        private void doRun(Runnable runnable) throws InvocationTargetException, InterruptedException {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
    }
}

