/*
 * Decompiled with CFR 0.152.
 */
package generic.theme.laf;

import generic.theme.Gui;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.Component;
import java.awt.Font;
import java.util.Iterator;
import java.util.Objects;

public class ComponentFontRegistry {
    private WeakSet<StyledComponent> components = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private String fontId;

    public ComponentFontRegistry(String fontId) {
        this.fontId = fontId;
    }

    public void addComponent(Component component) {
        this.addComponent(component, 0);
    }

    public void addComponent(Component component, int fontStyle) {
        StyledComponent sc = new StyledComponent(component, fontStyle);
        sc.setFont(Gui.getFont(this.fontId));
        this.components.add((Object)sc);
    }

    public void removeComponent(Component component) {
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            StyledComponent sc = (StyledComponent)it.next();
            if (component != sc.component) continue;
            it.remove();
            break;
        }
    }

    public void updateComponentFonts() {
        Font font = Gui.getFont(this.fontId);
        for (StyledComponent c : this.components) {
            c.setFont(font);
        }
    }

    private record StyledComponent(Component component, int fontStyle) {
        void setFont(Font font) {
            Font existingFont = this.component.getFont();
            Font styledFont = font;
            int style = this.fontStyle();
            if (style != 0) {
                styledFont = font.deriveFont(style);
            }
            if (!Objects.equals(existingFont, styledFont)) {
                this.component.setFont(styledFont);
            }
        }
    }
}

