/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.AbstractOptions;
import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.Option;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ThemeColorOption;
import ghidra.framework.options.ThemeFontOption;
import ghidra.framework.options.WrappedActionTrigger;
import ghidra.framework.options.WrappedColor;
import ghidra.framework.options.WrappedCustomOption;
import ghidra.framework.options.WrappedDate;
import ghidra.framework.options.WrappedFile;
import ghidra.framework.options.WrappedFont;
import ghidra.framework.options.WrappedKeyStroke;
import ghidra.framework.options.WrappedOption;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jdom.Content;
import org.jdom.Element;

public class ToolOptions
extends AbstractOptions {
    private static final String CLASS_ATTRIBUTE = "CLASS";
    private static final String NAME_ATTRIBUTE = "NAME";
    private static final String WRAPPED_OPTION_NAME = "WRAPPED_OPTION";
    private static final String CLEARED_VALUE_ELEMENT_NAME = "CLEARED_VALUE";
    public static final Set<Class<?>> PRIMITIVE_CLASSES = ToolOptions.buildPrimitiveClassSet();
    public static final Set<Class<?>> WRAPPABLE_CLASSES = ToolOptions.buildWrappableClassSet();
    public static final String XML_ELEMENT_NAME = "CATEGORY";

    private static Set<Class<?>> buildPrimitiveClassSet() {
        HashSet set = new HashSet();
        set.add(Byte.class);
        set.add(Short.class);
        set.add(Integer.class);
        set.add(Long.class);
        set.add(Float.class);
        set.add(Double.class);
        set.add(Boolean.class);
        set.add(String.class);
        return set;
    }

    private static Set<Class<?>> buildWrappableClassSet() {
        HashSet set = new HashSet();
        set.add(Color.class);
        set.add(Font.class);
        set.add(KeyStroke.class);
        set.add(File.class);
        return set;
    }

    public ToolOptions(String name) {
        super(name);
    }

    public ToolOptions copy() {
        return new ToolOptions(this.getXmlRoot(true));
    }

    public ToolOptions(Element root) {
        this(root.getAttributeValue(NAME_ATTRIBUTE));
        SaveState saveState = new SaveState(root);
        this.readNonWrappedOptions(saveState);
        try {
            this.readWrappedOptions(root);
        }
        catch (ReflectiveOperationException exc) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + exc.getMessage()), (Throwable)exc);
        }
    }

    private void readNonWrappedOptions(SaveState saveState) {
        for (String optionName : saveState.getNames()) {
            Object object = saveState.getObject(optionName);
            Option option = this.createUnregisteredOption(optionName, OptionType.getOptionType(object), null);
            option.doSetCurrentValue(object);
            this.valueMap.put(optionName, option);
        }
    }

    private void readWrappedOptions(Element root) throws ReflectiveOperationException {
        for (Element element : root.getChildren(WRAPPED_OPTION_NAME)) {
            WrappedCustomOption wrappedCustom;
            List children = element.getChildren();
            if (children.isEmpty()) continue;
            String optionName = element.getAttributeValue(NAME_ATTRIBUTE);
            Class<?> c = Class.forName(element.getAttributeValue(CLASS_ATTRIBUTE));
            Constructor<?> constructor = c.getDeclaredConstructor(new Class[0]);
            WrappedOption wo = (WrappedOption)constructor.newInstance(new Object[0]);
            wo.readState(new SaveState(element));
            if (wo instanceof WrappedCustomOption && !(wrappedCustom = (WrappedCustomOption)wo).isValid()) continue;
            if (wo instanceof WrappedKeyStroke) {
                WrappedKeyStroke wrappedKs = (WrappedKeyStroke)wo;
                wo = wrappedKs.toWrappedActionTrigger();
            }
            Option option = this.createUnregisteredOption(optionName, wo.getOptionType(), null);
            this.valueMap.put(optionName, option);
            Element child = (Element)children.get(0);
            String elementName = child.getName();
            if (CLEARED_VALUE_ELEMENT_NAME.equals(elementName)) {
                option.doSetCurrentValue(null);
                continue;
            }
            option.doSetCurrentValue(wo.getObject());
        }
    }

    public Element getXmlRoot(boolean includeDefaultBindings) {
        SaveState saveState = new SaveState(XML_ELEMENT_NAME);
        this.writeNonWrappedOptions(includeDefaultBindings, saveState);
        Element root = saveState.saveToXml();
        root.setAttribute(NAME_ATTRIBUTE, this.name);
        this.writeWrappedOptions(includeDefaultBindings, root);
        return root;
    }

    private void writeNonWrappedOptions(boolean includeDefaultBindings, SaveState saveState) {
        for (String optionName : this.valueMap.keySet()) {
            Object value;
            Option optionValue = (Option)this.valueMap.get(optionName);
            if (!includeDefaultBindings && optionValue.isDefault() || !this.isSupportedBySaveState(value = optionValue.getValue(null))) continue;
            saveState.putObject(optionName, value);
        }
    }

    private void writeWrappedOptions(boolean includeDefaultBindings, Element root) {
        for (String optionName : this.valueMap.keySet()) {
            WrappedOption wrappedOption;
            Object value;
            Option option = (Option)this.valueMap.get(optionName);
            if (option instanceof ThemeColorOption || option instanceof ThemeFontOption || !includeDefaultBindings && option.isDefault() || this.isSupportedBySaveState(value = option.getCurrentValue()) || (wrappedOption = this.wrapOption(option)) == null) continue;
            SaveState ss = new SaveState(WRAPPED_OPTION_NAME);
            Element elem = null;
            if (value == null) {
                elem = ss.saveToXml();
                elem.addContent((Content)new Element(CLEARED_VALUE_ELEMENT_NAME));
            } else {
                wrappedOption.writeState(ss);
                elem = ss.saveToXml();
            }
            elem.setAttribute(NAME_ATTRIBUTE, optionName);
            elem.setAttribute(CLASS_ATTRIBUTE, wrappedOption.getClass().getName());
            root.addContent((Content)elem);
        }
    }

    private boolean isSupportedBySaveState(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Enum) {
            return true;
        }
        if (obj instanceof byte[]) {
            return true;
        }
        return PRIMITIVE_CLASSES.contains(obj.getClass());
    }

    private WrappedOption wrapOption(Option option) {
        Object value = null;
        value = option.getCurrentValue();
        if (value == null) {
            value = option.getDefaultValue();
        }
        if (value == null) {
            return null;
        }
        if (value instanceof CustomOption) {
            return new WrappedCustomOption((CustomOption)value);
        }
        if (value instanceof Color) {
            return new WrappedColor((Color)value);
        }
        if (value instanceof Font) {
            return new WrappedFont((Font)value);
        }
        if (value instanceof KeyStroke) {
            return new WrappedKeyStroke((KeyStroke)value);
        }
        if (value instanceof ActionTrigger) {
            return new WrappedActionTrigger((ActionTrigger)value);
        }
        if (value instanceof File) {
            return new WrappedFile((File)value);
        }
        if (value instanceof Date) {
            return new WrappedDate((Date)value);
        }
        throw new AssertException("Attempted to wrap object of unexpected class type: " + String.valueOf(value.getClass()));
    }

    public void addOptionsChangeListener(OptionsChangeListener l) {
        this.listeners.add((Object)l);
    }

    public void takeListeners(ToolOptions oldOptions) {
        this.listeners = oldOptions.listeners;
        oldOptions.listeners = null;
    }

    public void removeOptionsChangeListener(OptionsChangeListener l) {
        this.listeners.remove((Object)l);
    }

    public void removeUnusedOptions() {
        ArrayList optionNames = new ArrayList(this.valueMap.keySet());
        for (String optionName : optionNames) {
            Option optionState = (Option)this.valueMap.get(optionName);
            if (optionState.isRegistered()) continue;
            this.removeOption(optionName);
        }
    }

    public void copyOptions(Options newOptions) {
        List<String> optionNames = newOptions.getOptionNames();
        for (String optionName : optionNames) {
            Object value = newOptions.getObject(optionName, null);
            if (value == null) continue;
            this.putObject(optionName, value);
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToolOptions other = (ToolOptions)obj;
        if (!SystemUtilities.isEqual((Object)this.name, (Object)other.name)) {
            return false;
        }
        List<String> optionNames = this.getOptionNames();
        List<String> otherOptionNames = other.getOptionNames();
        if (optionNames.size() != otherOptionNames.size()) {
            return false;
        }
        Object dummy = new Object();
        for (String string : optionNames) {
            Object otherValue;
            Object myValue = this.getObject(string, dummy);
            if (SystemUtilities.isEqual((Object)myValue, (Object)(otherValue = other.getObject(string, dummy)))) continue;
            return false;
        }
        return true;
    }

    public void validateOptions() {
        if (!SystemUtilities.isInDevelopmentMode()) {
            return;
        }
        Set keySet = this.valueMap.keySet();
        for (String propertyName : keySet) {
            Option optionState = (Option)this.valueMap.get(propertyName);
            if (optionState.isRegistered()) continue;
            Msg.warn((Object)this, (Object)("Unregistered property \"" + propertyName + "\" in Options \"" + this.name + "\"\n     " + optionState.getInceptionInformation()));
        }
    }

    public void registerOptions(ToolOptions oldOptions) {
        Set optionNameSet = oldOptions.valueMap.keySet();
        for (String optionName : optionNameSet) {
            Option option = (Option)oldOptions.valueMap.get(optionName);
            if (!option.isRegistered()) continue;
            this.registerOption(optionName, option.getOptionType(), option.getDefaultValue(), option.getHelpLocation(), option.getDescription());
        }
    }

    @Override
    protected Option createRegisteredOption(String optionName, OptionType type, String description, HelpLocation help, Object defaultValue, PropertyEditor editor) {
        return new ToolOption(optionName, type, description, help, defaultValue, true, editor);
    }

    @Override
    protected Option createUnregisteredOption(String optionName, OptionType type, Object defaultValue) {
        if (type == OptionType.KEYSTROKE_TYPE) {
            type = OptionType.ACTION_TRIGGER;
            if (defaultValue instanceof KeyStroke) {
                KeyStroke keyStroke = (KeyStroke)defaultValue;
                defaultValue = new ActionTrigger(keyStroke);
            }
        }
        return new ToolOption(optionName, type, null, null, defaultValue, false, null);
    }

    @Override
    protected boolean notifyOptionChanged(String optionName, Object oldValue, Object newValue) {
        NotifyListenersRunnable runnable = new NotifyListenersRunnable(optionName, oldValue, newValue);
        Swing.runNow((Runnable)runnable);
        OptionsVetoException veto = runnable.getVetoException();
        if (veto != null) {
            throw veto;
        }
        return true;
    }

    private static class ToolOption
    extends Option {
        private Object currentValue;

        ToolOption(String name, OptionType type, String description, HelpLocation helpLocation, Object defaultValue, boolean isRegistered, PropertyEditor editor) {
            super(name, type, description, helpLocation, defaultValue, isRegistered, editor);
            this.currentValue = defaultValue;
        }

        @Override
        public Object getCurrentValue() {
            return this.currentValue;
        }

        @Override
        public void doSetCurrentValue(Object value) {
            this.currentValue = value;
        }
    }

    private class NotifyListenersRunnable
    implements Runnable {
        private String optionName;
        private Object oldValue;
        private Object newValue;
        private OptionsVetoException veto;

        NotifyListenersRunnable(String optionName, Object oldValue, Object newValue) {
            this.optionName = optionName;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void run() {
            ArrayList<OptionsChangeListener> notifiedListeners = new ArrayList<OptionsChangeListener>();
            try {
                for (OptionsChangeListener listener : ToolOptions.this.listeners) {
                    listener.optionsChanged(ToolOptions.this, this.optionName, this.oldValue, this.newValue);
                    notifiedListeners.add(listener);
                }
            }
            catch (OptionsVetoException e) {
                this.veto = e;
                for (OptionsChangeListener notifiedListener : notifiedListeners) {
                    notifiedListener.optionsChanged(ToolOptions.this, this.optionName, this.newValue, this.oldValue);
                }
            }
        }

        OptionsVetoException getVetoException() {
            return this.veto;
        }
    }
}

