/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng;

import agent.dbgeng.dbgeng.err.DbgEngRuntimeException;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import ghidra.util.Msg;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class DbgEngUtil {
    public static final WinDef.ULONG DEBUG_ANY_ID = new WinDef.ULONG(-1L);

    private DbgEngUtil() {
    }

    public static <I, T> I tryPreferredInterfaces(Class<I> cls, List<Preferred<T>> preferred, InterfaceSupplier supplier) {
        PointerByReference ppClient = new PointerByReference();
        for (Preferred<T> pref : preferred) {
            try {
                COMUtils.checkRC((WinNT.HRESULT)supplier.get(pref.refiid, ppClient));
                if (ppClient.getValue() == null) continue;
                Object impl = pref.cls.getConstructor(Pointer.class).newInstance(ppClient.getValue());
                Method instanceFor = cls.getMethod("instanceFor", pref.cls);
                Object instance = instanceFor.invoke(null, impl);
                return (I)instance;
            }
            catch (COMException e) {
                Msg.debug(DbgEngUtil.class, (Object)(String.valueOf((Object)e) + " (" + String.valueOf(pref.cls) + ")"));
            }
            catch (Exception e) {
                throw new AssertionError("INTERNAL: Unexpected exception", e);
            }
        }
        throw new DbgEngRuntimeException("None of the preferred interfaces are supported");
    }

    public static <T extends Unknown, U> U lazyWeakCache(Map<Pointer, U> cache, T unk, Function<T, U> forNew) {
        U present = cache.get(unk.getPointer());
        if (present != null) {
            unk.Release();
            return present;
        }
        U absent = forNew.apply(unk);
        cache.put(unk.getPointer(), absent);
        return absent;
    }

    public static void dbgline() {
        System.out.println(new Exception().getStackTrace()[1]);
        System.out.flush();
    }

    public record Preferred<T>(Guid.REFIID refiid, Class<? extends T> cls) {
        public Preferred(Guid.IID iid, Class<? extends T> cls) {
            this(new Guid.REFIID(iid), cls);
        }
    }

    public static interface InterfaceSupplier {
        public WinNT.HRESULT get(Guid.REFIID var1, PointerByReference var2);
    }
}

