/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.symbols;

import agent.dbgeng.dbgeng.COMUtilsExtra;
import agent.dbgeng.dbgeng.DbgEng;
import agent.dbgeng.dbgeng.DebugModule;
import agent.dbgeng.dbgeng.DebugModuleInfo;
import agent.dbgeng.dbgeng.DebugSymbolEntry;
import agent.dbgeng.dbgeng.DebugSymbolId;
import agent.dbgeng.dbgeng.DebugSymbolName;
import agent.dbgeng.impl.dbgeng.DbgEngUtil;
import agent.dbgeng.impl.dbgeng.symbols.DebugModuleImpl;
import agent.dbgeng.impl.dbgeng.symbols.DebugSymbolsInternal;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.jna.dbgeng.symbols.IDebugSymbols;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.util.Iterator;
import java.util.List;

public class DebugSymbolsImpl1
implements DebugSymbolsInternal {
    private final DbgEng.OpaqueCleanable cleanable;
    private final IDebugSymbols jnaSymbols;

    public DebugSymbolsImpl1(IDebugSymbols jnaSymbols) {
        this.cleanable = DbgEng.releaseWhenPhantom((Object)this, jnaSymbols);
        this.jnaSymbols = jnaSymbols;
    }

    @Override
    public int getNumberLoadedModules() {
        WinDef.ULONGByReference pulLoaded = new WinDef.ULONGByReference();
        WinDef.ULONGByReference pulUnloaded = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetNumberModules(pulLoaded, pulUnloaded));
        return pulLoaded.getValue().intValue();
    }

    @Override
    public int getNumberUnloadedModules() {
        WinDef.ULONGByReference pulLoaded = new WinDef.ULONGByReference();
        WinDef.ULONGByReference pulUnloaded = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetNumberModules(pulLoaded, pulUnloaded));
        return pulUnloaded.getValue().intValue();
    }

    @Override
    public DebugModule getModuleByIndex(int index) {
        WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
        WinDef.ULONGLONGByReference pullBase = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetModuleByIndex(ulIndex, pullBase));
        return new DebugModuleImpl(this, index, pullBase.getValue().longValue());
    }

    @Override
    public DebugModule getModuleByModuleName(String name, int startIndex) {
        WinDef.ULONG ulStartIndex = new WinDef.ULONG((long)startIndex);
        WinDef.ULONGByReference pulIndex = new WinDef.ULONGByReference();
        WinDef.ULONGLONGByReference pullBase = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetModuleByModuleName(name, ulStartIndex, pulIndex, pullBase));
        return new DebugModuleImpl(this, pulIndex.getValue().intValue(), pullBase.getValue().longValue());
    }

    @Override
    public DebugModule getModuleByOffset(long offset, int startIndex) {
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulStartIndex = new WinDef.ULONG((long)startIndex);
        WinDef.ULONGByReference pulIndex = new WinDef.ULONGByReference();
        WinDef.ULONGLONGByReference pullBase = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetModuleByOffset(ullOffset, ulStartIndex, pulIndex, pullBase));
        return new DebugModuleImpl(this, pulIndex.getValue().intValue(), pullBase.getValue().longValue());
    }

    protected void callNamesForWhich(DebugModule.DebugModuleName which, WinDef.ULONG Index, WinDef.ULONGLONG Base, byte[] Buffer2, WinDef.ULONG BufferSize, WinDef.ULONGByReference NameSize) {
        switch (which) {
            case IMAGE: {
                COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetModuleNames(Index, Base, Buffer2, BufferSize, NameSize, null, new WinDef.ULONG(0L), null, null, new WinDef.ULONG(0L), null));
            }
            case MODULE: {
                COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetModuleNames(Index, Base, null, new WinDef.ULONG(0L), null, Buffer2, BufferSize, NameSize, null, new WinDef.ULONG(0L), null));
            }
            case LOADED_IMAGE: {
                COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetModuleNames(Index, Base, null, new WinDef.ULONG(0L), null, null, new WinDef.ULONG(0L), null, Buffer2, BufferSize, NameSize));
            }
        }
        throw new UnsupportedOperationException("Interface does not support " + String.valueOf((Object)which));
    }

    @Override
    public String getModuleName(DebugModule.DebugModuleName which, DebugModule module) {
        WinDef.ULONGLONG ullBase = new WinDef.ULONGLONG(module.getBase());
        WinDef.ULONGByReference pulNameSize = new WinDef.ULONGByReference();
        this.callNamesForWhich(which, DbgEngUtil.DEBUG_ANY_ID, ullBase, null, new WinDef.ULONG(0L), pulNameSize);
        byte[] aBuffer = new byte[pulNameSize.getValue().intValue()];
        this.callNamesForWhich(which, DbgEngUtil.DEBUG_ANY_ID, ullBase, aBuffer, pulNameSize.getValue(), null);
        return Native.toString((byte[])aBuffer);
    }

    @Override
    public DebugModuleInfo getModuleParameters(int count, int startIndex) {
        WinDef.ULONG ulCount = new WinDef.ULONG((long)count);
        WinDef.ULONG ulStartIndex = new WinDef.ULONG((long)startIndex);
        DbgEngNative.DEBUG_MODULE_PARAMETERS.ByReference pInfo = new DbgEngNative.DEBUG_MODULE_PARAMETERS.ByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetModuleParameters(ulCount, null, ulStartIndex, pInfo));
        return new DebugModuleInfo(0L, pInfo.Base.longValue(), pInfo.Size.intValue(), "", "", pInfo.Checksum.intValue(), pInfo.TimeDateStamp.intValue());
    }

    @Override
    public Iterable<DebugSymbolName> iterateSymbolMatches(final String pattern) {
        final WinDef.ULONGLONGByReference pullHandle = new WinDef.ULONGLONGByReference();
        return new Iterable<DebugSymbolName>(){

            @Override
            public Iterator<DebugSymbolName> iterator() {
                COMUtils.checkRC((WinNT.HRESULT)DebugSymbolsImpl1.this.jnaSymbols.StartSymbolMatch(pattern, pullHandle));
                return new Iterator<DebugSymbolName>(){
                    WinDef.ULONGByReference pulMatchSize = new WinDef.ULONGByReference();
                    WinDef.ULONGLONGByReference pullOffset = new WinDef.ULONGLONGByReference();

                    @Override
                    public boolean hasNext() {
                        try {
                            COMUtils.checkRC((WinNT.HRESULT)DebugSymbolsImpl1.this.jnaSymbols.GetNextSymbolMatch(pullHandle.getValue(), null, new WinDef.ULONG(0L), this.pulMatchSize, null));
                        }
                        catch (COMException e) {
                            if (!COMUtilsExtra.isE_NOINTERFACE(e)) {
                                throw e;
                            }
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public DebugSymbolName next() {
                        try {
                            if (this.pulMatchSize.getValue().intValue() == 0) {
                                COMUtils.checkRC((WinNT.HRESULT)DebugSymbolsImpl1.this.jnaSymbols.GetNextSymbolMatch(pullHandle.getValue(), null, new WinDef.ULONG(0L), this.pulMatchSize, null));
                            }
                            byte[] aBuffer = new byte[this.pulMatchSize.getValue().intValue()];
                            COMUtils.checkRC((WinNT.HRESULT)DebugSymbolsImpl1.this.jnaSymbols.GetNextSymbolMatch(pullHandle.getValue(), aBuffer, this.pulMatchSize.getValue(), null, this.pullOffset));
                            DebugSymbolName debugSymbolName = new DebugSymbolName(Native.toString((byte[])aBuffer), this.pullOffset.getValue().longValue());
                            return debugSymbolName;
                        }
                        catch (COMException e) {
                            if (!COMUtilsExtra.isE_NOINTERFACE(e)) {
                                throw e;
                            }
                            DebugSymbolName debugSymbolName = null;
                            return debugSymbolName;
                        }
                        finally {
                            this.pulMatchSize.getValue().setValue(0L);
                        }
                    }

                    protected void finalize() throws Throwable {
                        COMUtils.checkRC((WinNT.HRESULT)DebugSymbolsImpl1.this.jnaSymbols.EndSymbolMatch(pullHandle.getValue()));
                    }
                };
            }
        };
    }

    @Override
    public List<DebugSymbolId> getSymbolIdsByName(String pattern) {
        throw new UnsupportedOperationException("Not supported by this interface");
    }

    @Override
    public DebugSymbolEntry getSymbolEntry(DebugSymbolId id) {
        throw new UnsupportedOperationException("Not supported by this interface");
    }

    @Override
    public String getSymbolPath() {
        WinDef.ULONGByReference pulPathLength = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetSymbolPath(null, new WinDef.ULONG(0L), pulPathLength));
        byte[] aBuffer = new byte[pulPathLength.getValue().intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetSymbolPath(aBuffer, pulPathLength.getValue(), null));
        return Native.toString((byte[])aBuffer);
    }

    @Override
    public void setSymbolPath(String path) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.SetSymbolPath(path));
    }

    @Override
    public int getSymbolOptions() {
        WinDef.ULONGByReference pulOptions = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetSymbolPath(null, new WinDef.ULONG(0L), pulOptions));
        return pulOptions.getValue().intValue();
    }

    @Override
    public void setSymbolOptions(int options) {
        WinDef.ULONG ulOptions = new WinDef.ULONG((long)options);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.SetSymbolOptions(ulOptions));
    }

    @Override
    public int getCurrentScopeFrameIndex() {
        throw new UnsupportedOperationException("Not supported by this interface");
    }

    @Override
    public void setCurrentScopeFrameIndex(int index) {
        throw new UnsupportedOperationException("Not supported by this interface");
    }
}

