/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.breakpoint;

import agent.dbgeng.dbgeng.DebugProcessId;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DbgBreakpointLocation {
    private final long number;
    private final long sub;
    private final boolean enabled;
    private final String addr;
    private final List<DebugProcessId> processIds;

    DbgBreakpointLocation(long number, long sub, boolean enabled, String addr, List<DebugProcessId> processIds) {
        this.number = number;
        this.sub = sub;
        this.enabled = enabled;
        this.addr = addr;
        this.processIds = Collections.unmodifiableList(processIds);
    }

    public String toString() {
        return "<Loc number=" + this.number + "." + this.sub + ",enabled=" + this.enabled + ",addr=" + this.addr + ",iids=" + String.valueOf(this.processIds) + ">";
    }

    public long getNumber() {
        return this.number;
    }

    public long getSub() {
        return this.sub;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getAddr() {
        return this.addr;
    }

    public long addrAsLong() {
        return Long.parseUnsignedLong(this.addr, 16);
    }

    public List<DebugProcessId> getProcessIds() {
        return this.processIds;
    }

    public int hashCode() {
        return Objects.hash(this.number, this.sub, this.enabled, this.addr, this.processIds);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DbgBreakpointLocation)) {
            return false;
        }
        DbgBreakpointLocation that = (DbgBreakpointLocation)obj;
        if (this.number != that.number) {
            return false;
        }
        if (this.sub != that.sub) {
            return false;
        }
        if (this.enabled != that.enabled) {
            return false;
        }
        if (!Objects.equals(this.addr, that.addr)) {
            return false;
        }
        return Objects.equals(this.processIds, that.processIds);
    }
}

