/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugFilterInformation;
import agent.dbgeng.dbgeng.DebugSpecificFilterInformation;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.manager.DbgEventFilter;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgEventFilterImpl;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import java.util.ArrayList;
import java.util.List;

public class DbgListEventFiltersCommand
extends AbstractDbgCommand<List<DbgEventFilter>> {
    private List<DbgEventFilter> result;

    public DbgListEventFiltersCommand(DbgManagerImpl manager) {
        super(manager);
    }

    @Override
    public List<DbgEventFilter> complete(DbgPendingCommand<?> pending) {
        return this.result;
    }

    @Override
    public void invoke() {
        this.result = new ArrayList<DbgEventFilter>();
        DebugControl control = this.manager.getControl();
        DebugFilterInformation info = control.getNumberEventFilters();
        DebugSpecificFilterInformation exc = control.getSpecificFilterParameters(0, info.getNumberEvents());
        for (int i = 0; i < info.getNumberEvents(); ++i) {
            DbgEngNative.DEBUG_SPECIFIC_FILTER_PARAMETERS p = exc.getParameter(i);
            String text = control.getEventFilterText(i, p.TextSize.intValue());
            String cmd = control.getEventFilterCommand(i, p.CommandSize.intValue());
            String arg = control.getSpecificFilterArgument(i, p.ArgumentSize.intValue());
            DbgEventFilterImpl f = new DbgEventFilterImpl(i, text, cmd, arg, p.ExecutionOption.intValue(), p.ContinueOption.intValue());
            this.result.add(f);
        }
    }
}

