/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.dbgeng.DebugThreadRecord;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgConsoleOutputEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DbgListOSThreadsCommand
extends AbstractDbgCommand<Map<DebugThreadId, DbgThread>> {
    protected final DbgProcessImpl process;
    private List<DebugThreadId> updatedThreadIds = new ArrayList<DebugThreadId>();

    public DbgListOSThreadsCommand(DbgManagerImpl manager, DbgProcessImpl process) {
        super(manager);
        this.process = process;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            return true;
        }
        if (evt instanceof DbgConsoleOutputEvent) {
            pending.steal(evt);
        }
        return false;
    }

    @Override
    public Map<DebugThreadId, DbgThread> complete(DbgPendingCommand<?> pending) {
        StringBuilder builder = new StringBuilder();
        for (DbgConsoleOutputEvent out : pending.findAllOf(DbgConsoleOutputEvent.class)) {
            builder.append(out.getOutput());
        }
        this.parse(builder.toString());
        Msg.warn((Object)this, (Object)("Completed OS thread list for pid=" + Long.toHexString(this.process.getPid())));
        Map<DebugThreadId, DbgThread> threads = this.process.getKnownThreads();
        return threads;
    }

    private void parse(String result) {
        String[] lines = result.split("\n");
        Long offset = null;
        for (int i = 0; i < lines.length; ++i) {
            String[] fields;
            String line = lines[i];
            if (!line.contains("THREAD") || (fields = line.trim().split("\\s+")).length <= 4 || !fields[0].equals("THREAD")) continue;
            BigInteger val = new BigInteger(fields[1], 16);
            offset = val.longValue();
            String[] split = fields[3].split("\\.");
            if (split.length != 2) continue;
            Long tid = Long.parseLong(split[1], 16);
            DbgThreadImpl mirror = this.manager.getThreadComputeIfAbsent(new DebugThreadRecord(tid), this.process, tid, false);
            if (offset == null) continue;
            mirror.setOffset(offset);
            this.updatedThreadIds.add(mirror.getId());
        }
    }

    @Override
    public void invoke() {
        Msg.warn((Object)this, (Object)("Retrieving OS thread list for pid=" + Long.toHexString(this.process.getPid())));
        DebugControl control = this.manager.getControl();
        control.execute("!process " + Long.toHexString(this.process.getOffset()) + " 2");
    }
}

