/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugSessionId;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgSession;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DbgListSessionsCommand
extends AbstractDbgCommand<Map<DebugSessionId, DbgSession>> {
    private List<DebugSessionId> updatedSessionIds = new ArrayList<DebugSessionId>();

    public DbgListSessionsCommand(DbgManagerImpl manager) {
        super(manager);
    }

    @Override
    public Map<DebugSessionId, DbgSession> complete(DbgPendingCommand<?> pending) {
        Map<DebugSessionId, DbgSession> allSessions = this.manager.getKnownSessions();
        Set<DebugSessionId> cur = allSessions.keySet();
        for (DebugSessionId id : this.updatedSessionIds) {
            if (cur.contains(id)) continue;
            Msg.warn((Object)this, (Object)("Resync: Was missing group: i" + String.valueOf(id)));
            this.manager.getSessionComputeIfAbsent(id, true);
        }
        for (DebugSessionId id : new ArrayList<DebugSessionId>(cur)) {
            if (this.updatedSessionIds.contains(id)) continue;
            Msg.warn((Object)this, (Object)("Resync: Had extra group: i" + String.valueOf(id)));
            this.manager.removeSession(id, DbgCause.Causes.UNCLAIMED);
        }
        return allSessions;
    }

    @Override
    public void invoke() {
        DebugSystemObjects so = this.manager.getSystemObjects();
        this.updatedSessionIds = so.getSessions();
    }
}

