/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgCommand;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.cmd.DbgCommandError;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgCommandErrorEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class DbgPendingCommand<T>
extends CompletableFuture<T>
implements DbgCause {
    private final DbgCommand<? extends T> cmd;
    private final Set<DbgEvent<?>> evts = new LinkedHashSet();

    public DbgPendingCommand(DbgCommand<? extends T> cmd) {
        this.cmd = cmd;
    }

    public DbgCommand<? extends T> getCommand() {
        return this.cmd;
    }

    public void finish() {
        try {
            T result = this.cmd.complete(this);
            this.complete(result);
        }
        catch (Throwable e) {
            this.completeExceptionally(e);
        }
    }

    public boolean handle(DbgEvent<?> evt) {
        return this.cmd.handle(evt, this);
    }

    public void claim(DbgEvent<?> evt) {
        evt.claim(this);
        this.evts.add(evt);
    }

    public void steal(DbgEvent<?> evt) {
        this.claim(evt);
        evt.steal();
    }

    public <E extends DbgEvent<?>> E castSingleEvent(Class<E> cls) {
        if (this.evts.size() != 1) {
            throw new IllegalStateException("Command did not claim exactly one event");
        }
        return (E)((DbgEvent)cls.cast(this.evts.iterator().next()));
    }

    public <E extends DbgEvent<?>> E findFirstOf(Class<E> cls) {
        for (DbgEvent<?> evt : this.evts) {
            if (!cls.isAssignableFrom(evt.getClass())) continue;
            return (E)((DbgEvent)cls.cast(evt));
        }
        throw new IllegalStateException("Command did not claim any " + String.valueOf(cls));
    }

    public <E extends DbgEvent<?>> List<E> findAllOf(Class<E> cls) {
        ArrayList<DbgEvent> found = new ArrayList<DbgEvent>();
        for (DbgEvent<?> evt : this.evts) {
            if (!cls.isAssignableFrom(evt.getClass())) continue;
            found.add((DbgEvent)cls.cast(evt));
        }
        return found;
    }

    public <E extends DbgEvent<?>> E findSingleOf(Class<E> cls) {
        List<E> found = this.findAllOf(cls);
        if (found.size() != 1) {
            throw new IllegalStateException("Command did not claim exactly one " + String.valueOf(cls) + ". Have " + String.valueOf(this.evts));
        }
        return (E)((DbgEvent)found.get(0));
    }

    @SafeVarargs
    public final <E extends AbstractDbgCompletedCommandEvent> E checkCompletion(Class<E> ... classes) {
        AbstractDbgCompletedCommandEvent completion = this.findSingleOf(AbstractDbgCompletedCommandEvent.class);
        for (Class<E> cls : classes) {
            if (cls != completion.getClass()) continue;
            return (E)((AbstractDbgCompletedCommandEvent)cls.cast(completion));
        }
        if (completion instanceof DbgCommandErrorEvent) {
            throw new DbgCommandError(completion.getInfo(), this.cmd);
        }
        for (Class<E> cls : classes) {
            if (!cls.isAssignableFrom(completion.getClass())) continue;
            return (E)((AbstractDbgCompletedCommandEvent)cls.cast(completion));
        }
        throw new IllegalStateException("Command completed with " + String.valueOf(completion) + ", not any of " + String.valueOf(Arrays.asList(classes)));
    }

    @Override
    public String toString() {
        return super.toString() + "(" + String.valueOf(this.cmd) + ")";
    }
}

