/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.evt;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.cmd.DbgPendingCommand;

public abstract class AbstractDbgEvent<T>
implements DbgEvent<T> {
    private final T info;
    protected DbgCause cause = DbgCause.Causes.UNCLAIMED;
    protected boolean stolen = false;
    protected DebugClient.DebugStatus status = DebugClient.DebugStatus.NO_CHANGE;

    protected AbstractDbgEvent(T info) {
        this.info = info;
    }

    @Override
    public T getInfo() {
        return this.info;
    }

    @Override
    public void claim(DbgPendingCommand<?> cmd) {
        if (this.cause != DbgCause.Causes.UNCLAIMED) {
            throw new IllegalStateException("Event is already claimed by " + String.valueOf(this.cause));
        }
        this.cause = cmd;
    }

    @Override
    public DbgCause getCause() {
        return this.cause;
    }

    public DbgReason getReason() {
        return DbgReason.getReason(null);
    }

    @Override
    public void steal() {
        this.stolen = true;
    }

    @Override
    public boolean isStolen() {
        return this.stolen;
    }

    public String toString() {
        return "<" + this.getClass().getSimpleName() + " " + String.valueOf(this.info) + " >";
    }

    @Override
    public DbgState newState() {
        return null;
    }
}

