/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.impl;

import agent.dbgeng.dbgeng.DebugEventInformation;
import agent.dbgeng.dbgeng.DebugRegisters;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.jna.dbgeng.WinNTExtra;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgEventsListener;
import agent.dbgeng.manager.DbgManager;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgStackFrame;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.breakpoint.DbgBreakpointInfo;
import agent.dbgeng.manager.breakpoint.DbgBreakpointType;
import agent.dbgeng.manager.cmd.DbgConsoleExecCommand;
import agent.dbgeng.manager.cmd.DbgContinueCommand;
import agent.dbgeng.manager.cmd.DbgDetachCommand;
import agent.dbgeng.manager.cmd.DbgEvaluateCommand;
import agent.dbgeng.manager.cmd.DbgInsertBreakpointCommand;
import agent.dbgeng.manager.cmd.DbgKillCommand;
import agent.dbgeng.manager.cmd.DbgListRegisterDescriptionsCommand;
import agent.dbgeng.manager.cmd.DbgReadMemoryCommand;
import agent.dbgeng.manager.cmd.DbgReadRegistersCommand;
import agent.dbgeng.manager.cmd.DbgStackListFramesCommand;
import agent.dbgeng.manager.cmd.DbgStepCommand;
import agent.dbgeng.manager.cmd.DbgStepToAddressCommand;
import agent.dbgeng.manager.cmd.DbgTraceToAddressCommand;
import agent.dbgeng.manager.cmd.DbgWriteMemoryCommand;
import agent.dbgeng.manager.cmd.DbgWriteRegistersCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.manager.impl.DbgRegister;
import agent.dbgeng.manager.impl.DbgRegisterSet;
import generic.ULongSpan;
import ghidra.async.AsyncLazyValue;
import ghidra.async.AsyncReference;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class DbgThreadImpl
implements DbgThread {
    DbgManagerImpl manager;
    private DbgProcessImpl process;
    private DebugThreadId id;
    private Long tid;
    private DebugEventInformation info;
    private Long offset;
    private final AsyncReference<DbgState, CauseReasonPair> state = new AsyncReference((Object)DbgState.STOPPED);
    private final AsyncLazyValue<DbgRegisterSet> registers = new AsyncLazyValue(this::doListRegisters);

    public DbgThreadImpl(DbgManagerImpl manager, DbgProcessImpl process, DebugThreadId id, long tid) {
        this.manager = manager;
        this.process = process;
        this.id = id;
        this.tid = tid;
    }

    public String toString() {
        return "<DbgThread tid=" + String.valueOf(this.id) + ",process=" + String.valueOf(this.process) + ",state=" + String.valueOf(this.state.get()) + ">";
    }

    @Override
    public DebugThreadId getId() {
        return this.id;
    }

    @Override
    public DbgProcess getProcess() {
        return this.process;
    }

    @Override
    public Long getTid() {
        return this.tid;
    }

    public void add() {
        this.manager.threads.put(this.id, this);
        this.process.addThread(this);
        this.state.addChangeListener((oldState, newState, pair) -> ((DbgEventsListener)this.manager.getEventListeners().invoke()).threadStateChanged(this, (DbgState)((Object)newState), pair.cause, pair.reason));
    }

    public void remove() {
        try {
            this.process.removeThread(this.id);
            this.manager.removeThread(this.id);
        }
        catch (IllegalArgumentException e) {
            Msg.warn((Object)this, (Object)("Thread " + String.valueOf(this.id) + " already removed"));
        }
    }

    @Override
    public DbgState getState() {
        return (DbgState)((Object)this.state.get());
    }

    @Override
    public boolean setState(DbgState state, DbgCause cause, DbgReason reason) {
        return this.state.set((Object)state, (Object)new CauseReasonPair(cause, reason));
    }

    @Override
    public CompletableFuture<Void> setActive() {
        return this.manager.setActiveThread(this);
    }

    @Override
    public CompletableFuture<String> evaluate(String expression) {
        return this.manager.execute(new DbgEvaluateCommand(this.manager, expression));
    }

    @Override
    public CompletableFuture<DbgRegisterSet> listRegisters() {
        return this.registers.request();
    }

    private CompletableFuture<DbgRegisterSet> doListRegisters() {
        CompletableFuture<List<DebugRegisters.DebugRegisterDescription>> listCmd = this.manager.execute(new DbgListRegisterDescriptionsCommand(this.manager));
        return listCmd.thenApply(descs -> {
            if (descs == null) {
                return new DbgRegisterSet(Set.of());
            }
            ArrayList<DbgRegister> regs = new ArrayList<DbgRegister>();
            for (DebugRegisters.DebugRegisterDescription desc : descs) {
                regs.add(new DbgRegister(desc));
            }
            return new DbgRegisterSet(regs);
        });
    }

    @Override
    public CompletableFuture<List<DbgStackFrame>> listStackFrames() {
        return this.manager.execute(new DbgStackListFramesCommand(this.manager, this));
    }

    @Override
    public CompletableFuture<Map<DbgRegister, BigInteger>> readRegisters(Set<DbgRegister> regs) {
        return this.manager.execute(new DbgReadRegistersCommand(this.manager, this, null, regs));
    }

    @Override
    public CompletableFuture<Void> writeRegisters(Map<DbgRegister, BigInteger> regVals) {
        return this.manager.execute(new DbgWriteRegistersCommand(this.manager, this, null, regVals));
    }

    @Override
    public CompletableFuture<ULongSpan.ULongSpanSet> readMemory(long addr, ByteBuffer buf, int len) {
        return this.manager.execute(new DbgReadMemoryCommand(this.manager, addr, buf, len));
    }

    @Override
    public CompletableFuture<Void> writeMemory(long addr, ByteBuffer buf, int len) {
        return this.manager.execute(new DbgWriteMemoryCommand(this.manager, addr, buf, len));
    }

    @Override
    public CompletableFuture<DbgBreakpointInfo> insertBreakpoint(long loc, int len, DbgBreakpointType type) {
        return this.manager.execute(new DbgInsertBreakpointCommand(this.manager, loc, len, type));
    }

    @Override
    public CompletableFuture<Void> console(String command) {
        return this.manager.execute(new DbgConsoleExecCommand(this.manager, command, DbgConsoleExecCommand.Output.CONSOLE)).thenApply(e -> null);
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command) {
        return this.manager.execute(new DbgConsoleExecCommand(this.manager, command, DbgConsoleExecCommand.Output.CAPTURE));
    }

    @Override
    public CompletableFuture<Void> cont() {
        return this.setActive().thenCompose(__ -> this.manager.execute(new DbgContinueCommand(this.manager)));
    }

    @Override
    public CompletableFuture<Void> step(DbgManager.ExecSuffix suffix) {
        return this.setActive().thenCompose(__ -> this.manager.execute(new DbgStepCommand(this.manager, this.id, suffix)));
    }

    @Override
    public CompletableFuture<Void> step(Map<String, ?> args) {
        return this.setActive().thenCompose(__ -> this.manager.execute(new DbgStepCommand(this.manager, this.id, args)));
    }

    @Override
    public CompletableFuture<Void> stepToAddress(String address) {
        return this.setActive().thenCompose(__ -> this.manager.execute(new DbgStepToAddressCommand(this.manager, this.id, address)));
    }

    @Override
    public CompletableFuture<Void> traceToAddress(String address) {
        return this.setActive().thenCompose(__ -> this.manager.execute(new DbgTraceToAddressCommand(this.manager, this.id, address)));
    }

    @Override
    public CompletableFuture<Void> kill() {
        return this.setActive().thenCompose(__ -> this.manager.execute(new DbgKillCommand(this.manager)));
    }

    @Override
    public CompletableFuture<Void> detach() {
        return this.setActive().thenCompose(__ -> this.manager.execute(new DbgDetachCommand(this.manager, this.process)));
    }

    public DebugEventInformation getInfo() {
        return this.info;
    }

    public void setInfo(DebugEventInformation info) {
        WinNTExtra.Machine oldType;
        WinNTExtra.Machine newType = WinNTExtra.Machine.getByNumber(info.getExecutingProcessorType());
        if (!newType.equals((Object)(oldType = this.getExecutingProcessorType()))) {
            this.registers.forget();
        }
        this.info = info;
    }

    @Override
    public WinNTExtra.Machine getExecutingProcessorType() {
        if (this.info == null) {
            return WinNTExtra.Machine.IMAGE_FILE_MACHINE_AMD64;
        }
        int executingProcessorType = this.info.getExecutingProcessorType();
        return WinNTExtra.Machine.getByNumber(executingProcessorType);
    }

    @Override
    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }

    private static class CauseReasonPair {
        private final DbgCause cause;
        private final DbgReason reason;

        CauseReasonPair(DbgCause cause, DbgReason reason) {
            this.cause = cause;
            this.reason = reason;
        }
    }
}

