/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface2;

import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgEventsListenerAdapter;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import agent.dbgeng.model.iface1.DbgModelSelectableObject;
import agent.dbgeng.model.iface1.DbgModelTargetAccessConditioned;
import agent.dbgeng.model.iface1.DbgModelTargetExecutionStateful;
import agent.dbgeng.model.iface1.DbgModelTargetSteppable;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.impl.DbgModelTargetStackImpl;
import ghidra.dbg.target.TargetAggregate;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import java.util.concurrent.CompletableFuture;

public interface DbgModelTargetThread
extends TargetThread,
TargetAggregate,
DbgModelTargetAccessConditioned,
DbgModelTargetExecutionStateful,
DbgModelTargetSteppable,
DbgEventsListenerAdapter,
DbgModelSelectableObject {
    default public DbgThread getThread() {
        return this.getThread(false);
    }

    default public DbgThread getThread(boolean fire) {
        DbgManagerImpl manager = this.getManager();
        try {
            DbgModelTargetProcess parentProcess = this.getParentProcess();
            DbgProcessImpl process = parentProcess == null ? null : (DbgProcessImpl)parentProcess.getProcess();
            String index = PathUtils.parseIndex((String)this.getName());
            Long tid = Long.decode(index);
            DebugSystemObjects so = manager.getSystemObjects();
            DebugThreadId id = so.getThreadIdBySystemId(tid.intValue());
            if (id == null) {
                id = so.getCurrentThreadId();
            }
            DbgThreadImpl thread = manager.getThreadComputeIfAbsent(id, process, tid, fire);
            return thread;
        }
        catch (IllegalArgumentException e) {
            return manager.getCurrentThread();
        }
    }

    @TargetMethod.Export(value="Step to Address (pa)")
    default public CompletableFuture<Void> stepToAddress(@TargetMethod.Param(description="The target address", display="StopAddress", name="address") Address address) {
        return this.getModel().gateFuture(this.getThread().stepToAddress(address.toString(false)));
    }

    @TargetMethod.Export(value="Trace to Address (ta)")
    default public CompletableFuture<Void> traceToAddress(@TargetMethod.Param(description="The target address", display="StopAddress", name="address") Address address) {
        return this.getModel().gateFuture(this.getThread().traceToAddress(address.toString(false)));
    }

    @Override
    default public CompletableFuture<Void> setActive() {
        DbgManagerImpl manager = this.getManager();
        DbgProcessImpl process = (DbgProcessImpl)this.getParentProcess().getProcess();
        manager.setActiveProcess(process);
        return manager.setActiveThread(this.getThread());
    }

    public DbgModelTargetStackImpl getStack();

    public String getExecutingProcessorType();

    public void threadStateChangedSpecific(DbgState var1, DbgReason var2);
}

