/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.DbgModuleMemory;
import agent.dbgeng.model.iface2.DbgModelTargetMemoryContainer;
import agent.dbgeng.model.iface2.DbgModelTargetMemoryRegion;
import agent.dbgeng.model.impl.DbgModelTargetMemoryContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="MemoryRegion", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="_memory", type=DbgModelTargetMemoryContainerImpl.class), @TargetAttributeType(name="BaseAddress", type=Address.class), @TargetAttributeType(name="EndAddress", type=Address.class), @TargetAttributeType(name="RegionSize", type=String.class), @TargetAttributeType(name="AllocationBase", type=Address.class), @TargetAttributeType(name="AllocationProtect", type=String.class), @TargetAttributeType(name="Protect", type=String.class), @TargetAttributeType(name="State", type=String.class), @TargetAttributeType(name="Type", type=String.class), @TargetAttributeType(type=Void.class)})
public class DbgModelTargetMemoryRegionImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetMemoryRegion {
    protected final DbgModuleMemory section;
    protected final AddressRange range;
    protected final List<String> protect;
    protected final List<String> allocProtect;
    private boolean isRead;
    private boolean isWrite;
    private boolean isExec;

    protected static String indexSection(DbgModuleMemory section) {
        return section.getName();
    }

    protected static String keySection(DbgModuleMemory section) {
        return PathUtils.makeKey((String)DbgModelTargetMemoryRegionImpl.indexSection(section));
    }

    public DbgModelTargetMemoryRegionImpl(DbgModelTargetMemoryContainer memory, DbgModuleMemory region) {
        super(memory.getModel(), (TargetObject)memory, DbgModelTargetMemoryRegionImpl.keySection(region), "Region");
        this.getModel().addModelObject(region, (TargetObject)this);
        this.section = region;
        this.range = this.doGetRange(this.section);
        this.allocProtect = region.getAllocationProtect();
        Object apx = "";
        for (String string : this.allocProtect) {
            apx = (String)apx + string + ":";
        }
        if (((String)apx).length() > 1) {
            apx = ((String)apx).substring(0, ((String)apx).length() - 1);
        }
        this.protect = region.getProtect();
        Object ipx = "";
        for (String p : this.protect) {
            ipx = (String)ipx + p + ":";
        }
        if (((String)ipx).length() > 1) {
            ipx = ((String)ipx).substring(0, ((String)ipx).length() - 1);
        }
        this.isRead = region.isRead();
        this.isWrite = region.isWrite();
        this.isExec = region.isExec();
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.computeDisplay(region), "_memory", memory, "_range", this.doGetRange(this.section), "_readable", this.isReadable(), "_writable", this.isWritable(), "_executable", this.isExecutable()), "Initialized");
        AddressSpace addressSpace = this.getModel().getAddressSpace("ram");
        this.changeAttributes(List.of(), List.of(), Map.of("BaseAddress", addressSpace.getAddress(region.getVmaStart()), "EndAddress", addressSpace.getAddress(region.getVmaEnd()), "RegionSize", Long.toHexString(region.getVmaEnd() - region.getVmaStart()), "AllocationBase", addressSpace.getAddress(region.getAllocationBase()), "AllocationProtect", apx, "Protect", ipx, "State", region.getState(), "Type", region.getType()), "Initialized");
    }

    protected String computeDisplay(DbgModuleMemory region) {
        return region.getType() + " " + this.getName();
    }

    protected AddressRange doGetRange(DbgModuleMemory s) {
        AddressSpace addressSpace = this.getModel().getAddressSpace("ram");
        Address min = addressSpace.getAddress(s.getVmaStart());
        Address max = addressSpace.getAddress(s.getVmaEnd() - 1L);
        return new AddressRangeImpl(min, max);
    }

    @Override
    public AddressRange getRange() {
        return this.range;
    }

    @Override
    public boolean isReadable() {
        return this.isRead;
    }

    @Override
    public boolean isWritable() {
        return this.isWrite;
    }

    @Override
    public boolean isExecutable() {
        return this.isExec;
    }

    public boolean isSame(DbgModuleMemory section) {
        return this.range.equals((Object)this.doGetRange(section));
    }
}

