/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface2.DbgModelTargetDebugContainer;
import agent.dbgeng.model.iface2.DbgModelTargetMemoryContainer;
import agent.dbgeng.model.iface2.DbgModelTargetModuleContainer;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetProcessContainer;
import agent.dbgeng.model.iface2.DbgModelTargetThreadContainer;
import agent.dbgeng.model.impl.DbgModelTargetDebugContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetMemoryContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetModuleContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import agent.dbgeng.model.impl.DbgModelTargetThreadContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetThreadImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Process", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Debug", type=DbgModelTargetDebugContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Memory", type=DbgModelTargetMemoryContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Modules", type=DbgModelTargetModuleContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Threads", type=DbgModelTargetThreadContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="_exit_code", type=Long.class), @TargetAttributeType(type=Void.class)})
public class DbgModelTargetProcessImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetProcess {
    public static final String PID_ATTRIBUTE_NAME = "_pid";
    public static final String EXIT_CODE_ATTRIBUTE_NAME = "_exit_code";
    public static final TargetAttacher.TargetAttachKindSet SUPPORTED_KINDS = TargetAttacher.TargetAttachKindSet.of((TargetAttacher.TargetAttachKind[])new TargetAttacher.TargetAttachKind[]{TargetAttacher.TargetAttachKind.BY_OBJECT_REF, TargetAttacher.TargetAttachKind.BY_ID});
    protected final DbgProcess process;
    protected final DbgModelTargetDebugContainer debug;
    protected final DbgModelTargetMemoryContainer memory;
    protected final DbgModelTargetModuleContainer modules;
    protected final DbgModelTargetThreadContainer threads;
    private Integer base = 16;

    protected static String indexProcess(DebugProcessId debugProcessId) {
        return debugProcessId.id();
    }

    protected static String indexProcess(DbgProcess process) {
        return DbgModelTargetProcessImpl.indexProcess(process.getId());
    }

    protected static String keyProcess(DbgProcess process) {
        return PathUtils.makeKey((String)DbgModelTargetProcessImpl.indexProcess(process));
    }

    public DbgModelTargetProcessImpl(DbgModelTargetProcessContainer processes, DbgProcess process) {
        super(processes.getModel(), (TargetObject)processes, DbgModelTargetProcessImpl.keyProcess(process), "Process");
        this.getModel().addModelObject(process, (TargetObject)this);
        this.getModel().addModelObject(process.getId(), (TargetObject)this);
        this.process = process;
        this.debug = new DbgModelTargetDebugContainerImpl(this);
        this.memory = new DbgModelTargetMemoryContainerImpl(this);
        this.modules = new DbgModelTargetModuleContainerImpl(this);
        this.threads = new DbgModelTargetThreadContainerImpl(this);
        this.accessible = false;
        this.changeAttributes(List.of(), List.of(this.debug, this.memory, this.modules, this.threads), Map.of("_accessible", false, "_display", this.getDisplay(), "_supported_attach_kinds", SUPPORTED_KINDS, "_supported_step_kinds", DbgModelTargetThreadImpl.SUPPORTED_KINDS), "Initialized");
        if (this.getManager().isKernelMode()) {
            TargetExecutionStateful.TargetExecutionState state = process.getPid() > 0L ? TargetExecutionStateful.TargetExecutionState.INACTIVE : TargetExecutionStateful.TargetExecutionState.ALIVE;
            this.setExecutionState(state, "Initialized");
        } else {
            this.setExecutionState(TargetExecutionStateful.TargetExecutionState.ALIVE, "Initialized");
        }
        this.getManager().addEventsListener(this);
    }

    public String getDisplay() {
        String name;
        DebugProcessId id = this.process.getId();
        Long pid = this.process.getPid();
        if (this.getManager().isKernelMode()) {
            Long offset;
            if (id.isSystem()) {
                return "[" + id.id() + "]";
            }
            Object pidstr = Long.toString(pid, this.base);
            if (this.base == 16) {
                pidstr = "0x" + (String)pidstr;
            }
            return (offset = this.process.getOffset()) == null ? "[" + (String)pidstr + "]" : "[" + (String)pidstr + " : " + Long.toHexString(offset) + "]";
        }
        if (pid < 0L) {
            return "[" + id.id() + "]";
        }
        Object pidstr = Long.toString(pid, this.base);
        if (this.base == 16) {
            pidstr = "0x" + (String)pidstr;
        }
        return (name = this.process.getExecutableName()) == null ? "[" + id.id() + ":" + (String)pidstr + "]" : "[" + id.id() + ":" + (String)pidstr + "] : " + name;
    }

    @Override
    public void threadStateChangedSpecific(DbgThread thread, DbgState state) {
        TargetExecutionStateful.TargetExecutionState targetState = this.convertState(state);
        this.setExecutionState(targetState, "ThreadStateChanged");
    }

    @Override
    public CompletableFuture<Void> resume() {
        return this.model.gateFuture(this.process.cont());
    }

    @Override
    public CompletableFuture<Void> kill() {
        return this.model.gateFuture(this.process.kill());
    }

    @Override
    public CompletableFuture<Void> attach(TargetAttachable attachable) {
        this.getModel().assertMine(TargetObject.class, (TargetObject)attachable);
        return this.model.gateFuture(this.process.reattach(attachable)).thenApply(set -> null);
    }

    @Override
    public CompletableFuture<Void> attach(long pid) {
        return this.model.gateFuture(this.process.attach(pid)).thenApply(set -> null);
    }

    @Override
    public CompletableFuture<Void> detach() {
        return this.model.gateFuture(this.process.detach());
    }

    @Override
    public CompletableFuture<Void> delete() {
        return this.model.gateFuture(this.process.remove());
    }

    @Override
    public CompletableFuture<Void> step(TargetSteppable.TargetStepKind kind) {
        switch (kind) {
            case SKIP: {
                throw new UnsupportedOperationException(kind.name());
            }
        }
        return this.model.gateFuture(this.process.step(this.convertToDbg(kind)));
    }

    @Override
    public CompletableFuture<Void> step(Map<String, ?> args) {
        return this.model.gateFuture(this.process.step(args));
    }

    @Override
    public void processStarted(Long pid) {
        if (pid != null) {
            this.changeAttributes(List.of(), List.of(), Map.of(PID_ATTRIBUTE_NAME, pid, "_display", this.getDisplay()), "Started");
        }
        this.setExecutionState(TargetExecutionStateful.TargetExecutionState.ALIVE, "Started");
    }

    @Override
    public void processExited(DbgProcess proc, DbgCause cause) {
        if (proc.equals(this.process)) {
            this.changeAttributes(List.of(), List.of(), Map.of("_state", TargetExecutionStateful.TargetExecutionState.TERMINATED, EXIT_CODE_ATTRIBUTE_NAME, proc.getExitCode()), "Exited");
            this.broadcast().event((TargetObject)this.getProxy(), null, TargetEventScope.TargetEventType.PROCESS_EXITED, "Process " + String.valueOf(proc.getId()) + " exited code=" + proc.getExitCode(), List.of(this.getProxy()));
        }
    }

    @Override
    public void memoryChanged(DbgProcess proc, long addr, int len, DbgCause cause) {
        if (proc.equals(this.process)) {
            this.broadcast().invalidateCacheRequested((TargetObject)this.memory);
        }
    }

    @Override
    public CompletableFuture<Void> setActive() {
        DbgManagerImpl manager = this.getManager();
        return manager.setActiveProcess(this.process);
    }

    @Override
    public DbgModelTargetThreadContainer getThreads() {
        return this.threads;
    }

    @Override
    public DbgModelTargetModuleContainer getModules() {
        return this.modules;
    }

    @Override
    public DbgModelTargetMemoryContainer getMemory() {
        return this.memory;
    }

    @Override
    public DbgProcess getProcess() {
        return this.process;
    }

    @Override
    public boolean isAccessible() {
        return this.accessible;
    }

    public void setBase(Object value) {
        this.base = (Integer)value;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay()), "Started");
    }

    public CompletableFuture<Void> resync(DebuggerObjectModel.RefreshBehavior refreshAttributes, DebuggerObjectModel.RefreshBehavior refreshElements) {
        if (this.memory != null) {
            this.memory.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
        }
        return super.resync(refreshAttributes, refreshElements);
    }
}

