/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.impl.dbgeng.client.DebugClientInternal;
import agent.dbgeng.jna.dbgeng.WinNTExtra;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgSession;
import agent.dbgeng.model.iface2.DbgModelTargetSessionAttributes;
import agent.dbgeng.model.iface2.DbgModelTargetSessionAttributesMachine;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForProducer;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

@TargetObjectSchemaInfo(name="SessionAttributesMachine", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Arch", type=String.class), @TargetAttributeType(name="Debugger", type=String.class), @TargetAttributeType(name="OS", type=String.class), @TargetAttributeType(name="Mode", type=String.class), @TargetAttributeType(type=Void.class)})
public class DbgModelTargetSessionAttributesMachineImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetSessionAttributesMachine {
    static String ARCH_ATTRIBUTE_NAME = "Arch";
    static String DEBUGGER_ATTRIBUTE_NAME = "Debugger";
    static String OS_ATTRIBUTE_NAME = "OS";

    public DbgModelTargetSessionAttributesMachineImpl(DbgModelTargetSessionAttributes attributes) {
        super(attributes.getModel(), (TargetObject)attributes, "Machine", "SessionMachineAttributes");
        this.changeAttributes(List.of(), List.of(), Map.of(ARCH_ATTRIBUTE_NAME, "x86_64", DEBUGGER_ATTRIBUTE_NAME, "dbgeng", OS_ATTRIBUTE_NAME, "Windows"), "Initialized");
        this.getManager().addEventsListener(this);
    }

    @Override
    public void sessionAdded(DbgSession session, DbgCause cause) {
        this.refreshInternal();
    }

    @Override
    public void processAdded(DbgProcess process, DbgCause cause) {
        this.refreshInternal();
    }

    public void refreshInternal() {
        DebugControl control = this.getManager().getControl();
        int processorType = control.getActualProcessorType();
        if (processorType < 0) {
            return;
        }
        WinNTExtra.Machine machine = WinNTExtra.Machine.getByNumber(processorType);
        int debuggeeType = control.getDebuggeeType();
        DebugClientInternal.DebugClass debugClass = DebugClientInternal.DebugClass.values()[debuggeeType];
        this.changeAttributes(List.of(), List.of(), Map.of(ARCH_ATTRIBUTE_NAME, machine.description, "Mode", debugClass.toString()), "Refreshed");
        AtomicReference capture = new AtomicReference();
        AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> this.getManager().consoleCapture("vertarget").handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1)), capture).then(seq -> this.changeAttributes(List.of(), List.of(), Map.of(OS_ATTRIBUTE_NAME, (String)capture.get()), "Refreshed")).finish();
    }
}

