/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.ComponentProvider;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ProgramByteViewerComponentProvider;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import utility.function.Callback;

public abstract class AbstractByteViewerPlugin<P extends ProgramByteViewerComponentProvider>
extends Plugin {
    protected Program currentProgram;
    private boolean areEventsDisabled;
    protected ProgramLocation currentLocation;
    protected P connectedProvider;
    protected List<P> disconnectedProviders = new ArrayList<P>();

    public AbstractByteViewerPlugin(PluginTool tool) {
        super(tool);
        this.connectedProvider = this.createProvider(true);
    }

    protected abstract P createProvider(boolean var1);

    protected void showConnectedProvider() {
        this.tool.showComponentProvider(this.connectedProvider, true);
    }

    public P createNewDisconnectedProvider() {
        P newProvider = this.createProvider(false);
        this.addProvider(newProvider);
        this.tool.showComponentProvider(newProvider, true);
        return newProvider;
    }

    protected void init() {
        ClipboardService clipboardService = (ClipboardService)this.tool.getService(ClipboardService.class);
        if (clipboardService != null) {
            ((ProgramByteViewerComponentProvider)((Object)this.connectedProvider)).setClipboardService(clipboardService);
            for (ProgramByteViewerComponentProvider provider : this.disconnectedProviders) {
                provider.setClipboardService(clipboardService);
            }
        }
    }

    public void dispose() {
        this.removeProvider((ByteViewerComponentProvider)((Object)this.connectedProvider));
        for (ProgramByteViewerComponentProvider provider : this.disconnectedProviders) {
            this.removeProvider(provider);
        }
        this.disconnectedProviders.clear();
    }

    public void writeConfigState(SaveState saveState) {
        ((ByteViewerComponentProvider)((Object)this.connectedProvider)).writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        ((ByteViewerComponentProvider)((Object)this.connectedProvider)).readConfigState(saveState);
    }

    public void readDataState(SaveState saveState) {
        this.doWithEventsDisabled(() -> {
            ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
            ((ProgramByteViewerComponentProvider)((Object)((Object)this.connectedProvider))).readDataState(saveState);
            int numDisconnected = saveState.getInt("Num Disconnected", 0);
            for (int i = 0; i < numDisconnected; ++i) {
                Program program;
                Element xmlElement = saveState.getXmlElement("Provider" + i);
                SaveState providerSaveState = new SaveState(xmlElement);
                String programPath = providerSaveState.getString("Program Path", "");
                DomainFile file = this.tool.getProject().getProjectData().getFile(programPath);
                if (file == null || (program = programManagerService.openProgram(file)) == null) continue;
                P provider = this.createProvider(false);
                ((ProgramByteViewerComponentProvider)((Object)((Object)provider))).doSetProgram(program);
                ((ByteViewerComponentProvider)((Object)((Object)provider))).readConfigState(providerSaveState);
                ((ProgramByteViewerComponentProvider)((Object)((Object)provider))).readDataState(providerSaveState);
                this.tool.showComponentProvider(provider, true);
                this.addProvider(provider);
            }
        });
    }

    public void writeDataState(SaveState saveState) {
        ((ProgramByteViewerComponentProvider)((Object)this.connectedProvider)).writeDataState(saveState);
        saveState.putInt("Num Disconnected", this.disconnectedProviders.size());
        int i = 0;
        for (ProgramByteViewerComponentProvider provider : this.disconnectedProviders) {
            SaveState providerSaveState = new SaveState();
            DomainFile df = provider.getProgram().getDomainFile();
            if (df.getParent() == null) continue;
            String programPathname = df.getPathname();
            providerSaveState.putString("Program Path", programPathname);
            provider.writeConfigState(providerSaveState);
            provider.writeDataState(providerSaveState);
            String elementName = "Provider" + i;
            saveState.putXmlElement(elementName, providerSaveState.saveToXml());
            ++i;
        }
    }

    public Object getUndoRedoState(DomainObject domainObject) {
        HashMap<Long, Object> stateMap = new HashMap<Long, Object>();
        this.addUndoRedoState(stateMap, domainObject, this.connectedProvider);
        for (ProgramByteViewerComponentProvider provider : this.disconnectedProviders) {
            this.addUndoRedoState(stateMap, domainObject, provider);
        }
        if (stateMap.isEmpty()) {
            return null;
        }
        return stateMap;
    }

    private void addUndoRedoState(Map<Long, Object> stateMap, DomainObject domainObject, P provider) {
        if (provider == null) {
            return;
        }
        Object state = ((ProgramByteViewerComponentProvider)((Object)provider)).getUndoRedoState(domainObject);
        if (state != null) {
            stateMap.put(provider.getInstanceID(), state);
        }
    }

    public void restoreUndoRedoState(DomainObject domainObject, Object state) {
        Map stateMap = (Map)state;
        this.restoreUndoRedoState(stateMap, domainObject, this.connectedProvider);
        for (ProgramByteViewerComponentProvider provider : this.disconnectedProviders) {
            this.restoreUndoRedoState(stateMap, domainObject, provider);
        }
    }

    private void restoreUndoRedoState(Map<Long, Object> stateMap, DomainObject domainObject, P provider) {
        if (provider == null) {
            return;
        }
        Object state = stateMap.get(provider.getInstanceID());
        if (state != null) {
            ((ProgramByteViewerComponentProvider)((Object)provider)).restoreUndoRedoState(domainObject, state);
        }
    }

    public Object getTransientState() {
        Object[] state = new Object[2];
        SaveState ss = new SaveState();
        ((ProgramByteViewerComponentProvider)((Object)this.connectedProvider)).writeDataState(ss);
        state[0] = ss;
        state[1] = ((ProgramByteViewerComponentProvider)((Object)this.connectedProvider)).getCurrentSelection();
        return state;
    }

    public void restoreTransientState(Object objectState) {
        this.doWithEventsDisabled(() -> {
            Object[] state = (Object[])objectState;
            ((ProgramByteViewerComponentProvider)((Object)((Object)this.connectedProvider))).restoreLocation((SaveState)state[0]);
            ((ProgramByteViewerComponentProvider)((Object)((Object)this.connectedProvider))).setSelection((ProgramSelection)state[1]);
        });
    }

    private void doWithEventsDisabled(Callback callback) {
        this.areEventsDisabled = true;
        try {
            callback.call();
        }
        finally {
            this.areEventsDisabled = false;
        }
    }

    protected boolean eventsDisabled() {
        return this.areEventsDisabled;
    }

    void setStatusMessage(String msg) {
        this.tool.setStatusInfo(msg);
    }

    void addProvider(P provider) {
        this.disconnectedProviders.add(provider);
        ((ProgramByteViewerComponentProvider)((Object)provider)).setClipboardService((ClipboardService)this.tool.getService(ClipboardService.class));
    }

    Program getProgram() {
        return this.currentProgram;
    }

    public P getProvider() {
        return this.connectedProvider;
    }

    public abstract void updateSelection(ByteViewerComponentProvider var1, ProgramSelectionPluginEvent var2, Program var3);

    public abstract void highlightChanged(ByteViewerComponentProvider var1, ProgramSelection var2);

    public void closeProvider(ByteViewerComponentProvider provider) {
        if (provider == this.connectedProvider) {
            this.tool.showComponentProvider((ComponentProvider)provider, false);
        } else {
            this.disconnectedProviders.remove((Object)provider);
            this.removeProvider(provider);
        }
    }

    protected void exportLocation(Program program, ProgramLocation location) {
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            service.goTo(location, program);
        }
    }

    protected void removeProvider(ByteViewerComponentProvider provider) {
        this.tool.removeComponentProvider((ComponentProvider)provider);
        provider.dispose();
    }

    protected abstract void updateLocation(ProgramByteViewerComponentProvider var1, ProgramLocationPluginEvent var2, boolean var3);

    protected abstract void fireProgramLocationPluginEvent(ProgramByteViewerComponentProvider var1, ProgramLocationPluginEvent var2);
}

