/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.SolverException;
import ghidra.app.plugin.assembler.sleigh.util.AsmUtil;
import ghidra.app.plugin.processors.sleigh.ContextOp;
import ghidra.app.plugin.processors.sleigh.expression.ContextField;
import ghidra.app.plugin.processors.sleigh.expression.TokenField;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.pattern.PatternBlock;
import ghidra.program.model.lang.RegisterValue;
import ghidra.util.NumericUtilities;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;

public class AssemblyPatternBlock
implements Comparable<AssemblyPatternBlock> {
    protected static final String SHIFT_STR = "SS:";
    protected static final String SHIFT_STR_END = "SS";
    private final int offset;
    private final byte[] mask;
    private final byte[] vals;

    protected AssemblyPatternBlock(int offset, byte[] mask, byte[] vals) {
        assert (mask.length == vals.length);
        this.offset = offset;
        this.mask = mask;
        this.vals = vals;
    }

    protected AssemblyPatternBlock(int offset, int capacity) {
        this.offset = offset;
        this.mask = new byte[capacity];
        this.vals = new byte[capacity];
    }

    public static AssemblyPatternBlock nop() {
        return new AssemblyPatternBlock(0, 0);
    }

    public static AssemblyPatternBlock fromBytes(int offset, byte[] vals) {
        byte[] mask = new byte[vals.length];
        for (int i = 0; i < mask.length; ++i) {
            mask[i] = -1;
        }
        AssemblyPatternBlock res = new AssemblyPatternBlock(offset, mask, vals);
        return res;
    }

    public static AssemblyPatternBlock fromString(String str) {
        int newpos;
        if ("[]".equals(str)) {
            return new AssemblyPatternBlock(0, new byte[0], new byte[0]);
        }
        int pos = 0;
        int offset = 0;
        while (str.regionMatches(pos, SHIFT_STR, 0, SHIFT_STR.length())) {
            pos += SHIFT_STR.length();
            ++offset;
        }
        if (str.regionMatches(pos, SHIFT_STR_END, 0, SHIFT_STR_END.length())) {
            return new AssemblyPatternBlock(offset, new byte[0], new byte[0]);
        }
        int length = 1;
        int p = pos;
        while (p < str.length() && (newpos = str.indexOf(58, p)) != -1) {
            ++length;
            p = newpos + 1;
        }
        byte[] mask = new byte[length];
        byte[] vals = new byte[length];
        AtomicLong msk = new AtomicLong();
        AtomicLong val = new AtomicLong();
        int i = 0;
        for (String hex : str.substring(pos).split(":")) {
            NumericUtilities.convertHexStringToMaskedValue((AtomicLong)msk, (AtomicLong)val, (String)hex, (int)2, (int)0, null);
            mask[i] = (byte)msk.get();
            vals[i] = (byte)val.get();
            ++i;
        }
        return new AssemblyPatternBlock(offset, mask, vals);
    }

    public static AssemblyPatternBlock fromPattern(DisjointPattern pat, int minLen, boolean context) {
        int i;
        PatternBlock block = pat.getBlock(context);
        if (block == null || block.alwaysTrue()) {
            return new AssemblyPatternBlock(0, minLen);
        }
        if (block.alwaysFalse()) {
            return null;
        }
        int offset = block.getOffset();
        int nzlen = Math.max(block.getLength(), minLen) - offset;
        int[] vec = block.getMaskVector();
        ByteBuffer buf = ByteBuffer.allocate(vec.length * 4);
        int datlen = Math.min(nzlen, buf.capacity());
        for (int i2 = 0; i2 < vec.length; ++i2) {
            buf.putInt(i2 * 4, vec[i2]);
        }
        byte[] mask = new byte[nzlen];
        for (i = 0; i < datlen; ++i) {
            mask[i] = buf.get(i);
        }
        vec = block.getValueVector();
        for (i = 0; i < vec.length; ++i) {
            buf.putInt(i * 4, vec[i]);
        }
        byte[] vals = new byte[nzlen];
        for (int i3 = 0; i3 < datlen; ++i3) {
            vals[i3] = buf.get(i3);
        }
        return new AssemblyPatternBlock(offset, mask, vals);
    }

    public static AssemblyPatternBlock fromTokenField(TokenField tf, MaskedLong val) {
        int size = tf.getByteEnd() - tf.getByteStart() + 1;
        val = val.mask(tf.maxValue());
        try {
            val = val.invShiftRightLogical(tf.getShift());
        }
        catch (SolverException e) {
            throw new AssertionError((Object)e);
        }
        if (!tf.isBigEndian()) {
            val = val.byteSwap(size);
        }
        byte[] mask = new byte[size];
        byte[] vals = new byte[size];
        long lmsk = val.getMask();
        long lval = val.longValue();
        for (int i = size - 1; i >= 0; --i) {
            mask[i] = (byte)(lmsk & 0xFFL);
            vals[i] = (byte)(lval & 0xFFL);
            lmsk >>= 8;
            lval >>= 8;
        }
        return new AssemblyPatternBlock(tf.getByteStart(), mask, vals);
    }

    public static AssemblyPatternBlock fromContextField(ContextField cf, MaskedLong val) {
        int size = cf.getByteEnd() - cf.getByteStart() + 1;
        val = val.mask(cf.maxValue());
        try {
            val = val.invShiftRightLogical(cf.getShift());
        }
        catch (SolverException e) {
            throw new AssertionError((Object)e);
        }
        byte[] mask = new byte[size];
        byte[] vals = new byte[size];
        long lmsk = val.getMask();
        long lval = val.longValue();
        for (int i = size - 1; i >= 0; --i) {
            mask[i] = (byte)(lmsk & 0xFFL);
            vals[i] = (byte)(lval & 0xFFL);
            lmsk >>= 8;
            lval >>= 8;
        }
        return new AssemblyPatternBlock(cf.getByteStart(), mask, vals);
    }

    public static AssemblyPatternBlock fromRegisterValue(RegisterValue rv) {
        byte[] mb = rv.toBytes();
        byte[] mask = new byte[mb.length / 2];
        byte[] vals = new byte[mb.length / 2];
        System.arraycopy(mb, 0, mask, 0, mb.length / 2);
        System.arraycopy(mb, mb.length / 2, vals, 0, mb.length / 2);
        return new AssemblyPatternBlock(0, mask, vals);
    }

    public static AssemblyPatternBlock fromLength(int length) {
        byte[] mask = new byte[length];
        byte[] vals = new byte[length];
        return new AssemblyPatternBlock(0, mask, vals);
    }

    public AssemblyPatternBlock copy() {
        return new AssemblyPatternBlock(this.offset, Arrays.copyOf(this.mask, this.mask.length), Arrays.copyOf(this.vals, this.vals.length));
    }

    public int length() {
        return this.offset + this.mask.length;
    }

    public AssemblyPatternBlock shift(int amt) {
        if (amt == 0) {
            return this;
        }
        return new AssemblyPatternBlock(this.offset + amt, this.mask, this.vals);
    }

    public AssemblyPatternBlock truncate(int amt) {
        if (amt == 0) {
            return this;
        }
        if (this.offset >= amt) {
            return new AssemblyPatternBlock(this.offset - amt, this.mask, this.vals);
        }
        int toCut = amt - this.offset;
        if (toCut >= this.mask.length) {
            return AssemblyPatternBlock.nop();
        }
        byte[] newMask = Arrays.copyOfRange(this.mask, toCut, this.mask.length);
        byte[] newVals = Arrays.copyOfRange(this.vals, toCut, this.vals.length);
        return new AssemblyPatternBlock(0, newMask, newVals);
    }

    public AssemblyPatternBlock combine(AssemblyPatternBlock that) {
        int i;
        int i2;
        int i3;
        int newOffset = Math.min(this.offset, that.offset);
        int buflen = Math.max(this.length(), that.length()) - newOffset;
        byte[] cmsk = new byte[buflen];
        int diff = this.offset - newOffset;
        for (i3 = 0; i3 < this.mask.length; ++i3) {
            cmsk[diff + i3] = this.mask[i3];
        }
        diff = that.offset - newOffset;
        for (i3 = 0; i3 < that.mask.length; ++i3) {
            int n = diff + i3;
            cmsk[n] = (byte)(cmsk[n] & that.mask[i3]);
        }
        byte[] chek = new byte[buflen];
        diff = this.offset - newOffset;
        for (i2 = 0; i2 < this.vals.length; ++i2) {
            chek[diff + i2] = (byte)(cmsk[diff + i2] & this.vals[i2]);
        }
        diff = that.offset - newOffset;
        for (i2 = 0; i2 < that.vals.length; ++i2) {
            if (chek[diff + i2] == (byte)(cmsk[diff + i2] & that.vals[i2])) continue;
            return null;
        }
        byte[] newMask = new byte[buflen];
        byte[] newVals = new byte[buflen];
        diff = this.offset - newOffset;
        for (i = 0; i < this.mask.length; ++i) {
            newMask[diff + i] = this.mask[i];
            newVals[diff + i] = this.vals[i];
        }
        diff = that.offset - newOffset;
        for (i = 0; i < that.mask.length; ++i) {
            int n = diff + i;
            newMask[n] = (byte)(newMask[n] | that.mask[i]);
            int n2 = diff + i;
            newVals[n2] = (byte)(newVals[n2] | that.vals[i]);
        }
        return new AssemblyPatternBlock(newOffset, newMask, newVals);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.offset; ++i) {
            sb.append(SHIFT_STR);
        }
        if (this.mask.length == 0) {
            if (sb.length() == 0) {
                return "[]";
            }
            return sb.substring(0, sb.length() - 1);
        }
        for (i = 0; i < this.mask.length; ++i) {
            if (i != 0) {
                sb.append(':');
            }
            sb.append(NumericUtilities.convertMaskedValueToHexString((long)this.mask[i], (long)this.vals[i], (int)2, (boolean)false, (int)0, null));
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = this.offset;
        for (int i = 0; i < this.mask.length; ++i) {
            result *= 31;
            result += this.mask[i];
            result *= 31;
            result += this.vals[i];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AssemblyPatternBlock)) {
            return false;
        }
        AssemblyPatternBlock that = (AssemblyPatternBlock)obj;
        int ckOffset = Math.min(this.offset, that.offset);
        int length = Math.max(this.length(), that.length());
        for (int i = ckOffset; i < length; ++i) {
            if (AssemblyPatternBlock.checkRead(this.mask, i - this.offset, 0) != AssemblyPatternBlock.checkRead(that.mask, i - that.offset, 0)) {
                return false;
            }
            if (AssemblyPatternBlock.checkRead(this.vals, i - this.offset, 0) == AssemblyPatternBlock.checkRead(that.vals, i - that.offset, 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(AssemblyPatternBlock that) {
        int result = this.offset - that.offset;
        if (result != 0) {
            return result;
        }
        result = AsmUtil.compareArrays(this.mask, that.mask);
        if (result != 0) {
            return result;
        }
        result = AsmUtil.compareArrays(this.vals, that.vals);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    protected static int checkRead(byte[] arr, int idx, int def) {
        if (idx >= arr.length || idx < 0) {
            return 0xFF & def;
        }
        return 0xFF & arr[idx];
    }

    public AssemblyPatternBlock writeContextOp(ContextOp cop, MaskedLong val) {
        long vval = val.longValue();
        long vmsk = val.getMask();
        long cmsk = (long)cop.getMask() & 0xFFFFFFFFL;
        vval <<= cop.getShift();
        vmsk <<= cop.getShift();
        vval &= cmsk;
        vmsk &= cmsk;
        int idx = cop.getWordIndex();
        int newOffset = Math.min(idx * 4, this.offset);
        int length = Math.max(idx * 4 + 4, this.length());
        byte[] newMask = new byte[length - newOffset];
        byte[] newVals = new byte[length - newOffset];
        System.arraycopy(this.mask, 0, newMask, this.offset - newOffset, this.mask.length);
        System.arraycopy(this.vals, 0, newVals, this.offset - newOffset, this.vals.length);
        for (int i = 3; i >= 0; --i) {
            int n = idx * 4 + i;
            newMask[n] = (byte)((long)newMask[n] & ((cmsk ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFL));
            int n2 = idx * 4 + i;
            newMask[n2] = (byte)((long)newMask[n2] | vmsk & 0xFFL);
            int n3 = idx * 4 + i;
            newVals[n3] = (byte)((long)newVals[n3] & ((cmsk ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFL));
            int n4 = idx * 4 + i;
            newVals[n4] = (byte)((long)newVals[n4] | vval & 0xFFL);
            vval >>= 8;
            vmsk >>= 8;
            cmsk >>= 8;
        }
        return new AssemblyPatternBlock(newOffset, newMask, newVals);
    }

    public MaskedLong readContextOp(ContextOp cop) {
        int idx = cop.getWordIndex();
        long cmsk = (long)cop.getMask() & 0xFFFFFFFFL;
        long lmsk = 0L;
        for (int i = 0; i < 4; ++i) {
            lmsk <<= 8;
            lmsk |= (long)AssemblyPatternBlock.checkRead(this.mask, idx * 4 + i - this.offset, 0);
        }
        long rmsk = lmsk & cmsk;
        if (rmsk == 0L) {
            return MaskedLong.UNKS;
        }
        long rval = 0L;
        for (int i = 0; i < 4; ++i) {
            rval <<= 8;
            rval |= (long)AssemblyPatternBlock.checkRead(this.vals, idx * 4 + i - this.offset, 0);
        }
        return MaskedLong.fromMaskAndValue(rmsk >>> cop.getShift(), rval >>> cop.getShift());
    }

    public AssemblyPatternBlock maskOut(ContextOp cop) {
        byte[] newMask = Arrays.copyOf(this.mask, this.mask.length);
        byte[] newVals = Arrays.copyOf(this.vals, this.vals.length);
        int idx = cop.getWordIndex();
        int imsk = cop.getMask();
        for (int i = 3; i >= 0; --i) {
            byte bmsk = (byte)(~(imsk & 0xFF));
            int index = idx * 4 + i - this.offset;
            if (index < newMask.length && index >= 0) {
                int n = index;
                newMask[n] = (byte)(newMask[n] & bmsk);
                int n2 = index;
                newVals[n2] = (byte)(newVals[n2] & bmsk);
            }
            imsk >>= 8;
        }
        return new AssemblyPatternBlock(this.offset, newMask, newVals);
    }

    public AssemblyPatternBlock maskOut(AssemblyPatternBlock other) {
        assert (this.length() >= other.length());
        byte[] newMask = Arrays.copyOf(this.mask, this.mask.length);
        byte[] newVals = Arrays.copyOf(this.vals, this.vals.length);
        for (int i = this.offset; i < Math.min(this.length(), other.length()); ++i) {
            if (i < this.offset || i < other.offset) continue;
            int n = i - this.offset;
            newMask[n] = (byte)(newMask[n] & (~other.mask[i - other.offset] & 0xFF));
            int n2 = i - this.offset;
            newVals[n2] = (byte)(newVals[n2] & (~other.mask[i - other.offset] & 0xFF));
        }
        return new AssemblyPatternBlock(this.offset, newMask, newVals);
    }

    static byte[] bitShiftRightByteArray(byte[] input, int amount) {
        byte[] newMask = new byte[input.length];
        for (int i = input.length - 1; i >= 0; --i) {
            if (i < input.length - 1) {
                newMask[i + 1] = (byte)(newMask[i + 1] | input[i] << 8 - amount & 0xFF);
            }
            newMask[i] = (byte)((input[i] & 0xFF) >> amount);
        }
        return newMask;
    }

    public AssemblyPatternBlock trim() {
        int minNonZeroMask = Integer.MAX_VALUE;
        int maxNonZeroMask = -1;
        for (int i = 0; i < this.mask.length; ++i) {
            if (this.mask[i] == 0) continue;
            minNonZeroMask = Math.min(minNonZeroMask, i);
            maxNonZeroMask = i;
        }
        if (maxNonZeroMask == -1) {
            return AssemblyPatternBlock.nop();
        }
        int bitShiftAmount = Integer.numberOfTrailingZeros(this.mask[maxNonZeroMask]);
        byte[] newMask = AssemblyPatternBlock.bitShiftRightByteArray(Arrays.copyOfRange(this.mask, minNonZeroMask, maxNonZeroMask + 1), bitShiftAmount);
        byte[] newVals = AssemblyPatternBlock.bitShiftRightByteArray(Arrays.copyOfRange(this.vals, minNonZeroMask, maxNonZeroMask + 1), bitShiftAmount);
        if (newMask[0] == 0) {
            newMask = Arrays.copyOfRange(newMask, 1, newMask.length);
            newVals = Arrays.copyOfRange(newVals, 1, newVals.length);
        }
        return new AssemblyPatternBlock(0, newMask, newVals);
    }

    public byte[] getValsAll() {
        int i;
        byte[] out = new byte[this.offset + this.vals.length];
        for (i = 0; i < this.offset; ++i) {
            out[i] = 0;
        }
        for (i = 0; i < this.vals.length; ++i) {
            out[this.offset + i] = this.vals[i];
        }
        return out;
    }

    public byte[] getMaskAll() {
        int i;
        byte[] out = new byte[this.offset + this.mask.length];
        for (i = 0; i < this.offset; ++i) {
            out[i] = 0;
        }
        for (i = 0; i < this.mask.length; ++i) {
            out[this.offset + i] = this.mask[i];
        }
        return out;
    }

    public byte[] getVals() {
        return this.vals;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public AssemblyPatternBlock getMaskedValue(byte[] unmasked) {
        assert (this.offset + this.mask.length <= unmasked.length);
        byte[] newVals = Arrays.copyOfRange(unmasked, this.offset, this.offset + this.mask.length);
        for (int i = 0; i < newVals.length; ++i) {
            newVals[i] = (byte)(newVals[i] & this.mask[i] & 0xFF);
        }
        return new AssemblyPatternBlock(this.offset, this.mask, newVals);
    }

    public int getOffset() {
        return this.offset;
    }

    public long readValBytes(int start, int len) {
        long res = 0L;
        for (int i = 0; i < len; ++i) {
            res <<= 8;
            int index = start + i - this.offset;
            if (0 > index || index >= this.vals.length) continue;
            res |= (long)(0xFF & this.vals[index]);
        }
        return res;
    }

    public long readMaskBytes(int start, int len) {
        long res = 0L;
        for (int i = 0; i < len; ++i) {
            res <<= 8;
            int index = start + i - this.offset;
            if (0 > index || index >= this.mask.length) continue;
            res |= (long)(0xFF & this.mask[index]);
        }
        return res;
    }

    public MaskedLong readBytes(int start, int len) {
        return MaskedLong.fromMaskAndValue(this.readMaskBytes(start, len), this.readValBytes(start, len));
    }

    public AssemblyPatternBlock fillMask() {
        byte[] newMask = new byte[this.mask.length];
        for (int i = 0; i < newMask.length; ++i) {
            newMask[i] = -1;
        }
        return new AssemblyPatternBlock(this.offset, newMask, this.vals);
    }

    public boolean isFullMask() {
        if (this.offset != 0) {
            return false;
        }
        for (byte element : this.mask) {
            if (element == -1) continue;
            return false;
        }
        return true;
    }

    public boolean isZero() {
        if (!this.isFullMask()) {
            return false;
        }
        for (byte val : this.vals) {
            if (val == 0) continue;
            return false;
        }
        return true;
    }

    public BigInteger toBigInteger(int n) {
        BigInteger res = new BigInteger(1, this.vals);
        res = n < this.length() ? res.shiftRight((this.length() - n) * 8) : res.shiftLeft((n - this.length()) * 8);
        return res;
    }

    public int getSpecificity() {
        int result = 0;
        for (byte element : this.mask) {
            result += Integer.bitCount(0xFF & element);
        }
        return result;
    }

    public int countPossibleVals() {
        int count0 = 0;
        byte[] byArray = this.mask;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte element;
            byte m = element = byArray[i];
            for (int j = 0; j < 8; ++j) {
                if ((m & 0x80) == 0) {
                    ++count0;
                }
                m = (byte)(m << 1);
            }
        }
        return 1 << count0;
    }

    public Iterable<byte[]> possibleVals() {
        return () -> {
            final byte[] cur = new byte[this.vals.length];
            System.arraycopy(this.vals, 0, cur, 0, this.vals.length);
            final int max = this.countPossibleVals();
            return new Iterator<byte[]>(){
                int c = 0;

                @Override
                public boolean hasNext() {
                    return this.c < max;
                }

                @Override
                public byte[] next() {
                    int cm = max >> 1;
                    for (int i = 0; i < AssemblyPatternBlock.this.mask.length; ++i) {
                        byte m = AssemblyPatternBlock.this.mask[i];
                        for (int j = 0; j < 8; ++j) {
                            if ((m & 0x80) == 0) {
                                byte b = (byte)(128 >> j);
                                if ((this.c & cm) == 0) {
                                    int n = i;
                                    cur[n] = (byte)(cur[n] & ~b);
                                } else {
                                    int n = i;
                                    cur[n] = (byte)(cur[n] | b);
                                }
                                cm >>= 1;
                            }
                            m = (byte)(m << 1);
                        }
                    }
                    ++this.c;
                    return cur;
                }
            };
        };
    }
}

