/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ContextChange;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;

public class ContextCommit
implements ContextChange {
    private TripleSymbol sym = null;
    private int num;
    private int mask;

    @Override
    public void apply(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException {
        walker.getParserContext().addCommit(walker.getState(), this.sym, this.num, this.mask);
        if (debug != null) {
            debug.dumpGlobalSet(walker.getParserContext(), walker.getState(), this.sym, this.num, this.mask, walker.getParserContext().getContextBytes()[this.num] & this.mask);
        }
    }

    @Override
    public void decode(Decoder decoder, SleighLanguage lang) throws DecoderException {
        int el = decoder.openElement(SlaFormat.ELEM_COMMIT);
        int id = (int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_ID);
        this.sym = (TripleSymbol)lang.getSymbolTable().findSymbol(id);
        this.num = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_NUMBER);
        this.mask = (int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_MASK);
        decoder.closeElement(el);
    }
}

