/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ConstructState;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.ContextCache;
import ghidra.app.plugin.processors.sleigh.DecisionNode;
import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.OpTplWalker;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.PcodeEmitObjects;
import ghidra.app.plugin.processors.sleigh.PcodeEmitPacked;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.app.plugin.processors.sleigh.template.ConstTpl;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.app.plugin.processors.sleigh.template.HandleTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.plugin.processors.sleigh.template.VarnodeTpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Mask;
import ghidra.program.model.lang.MaskImpl;
import ghidra.program.model.lang.ParserContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.ReadOnlyProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.UnknownContextException;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.WrappedMemBuffer;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.PatchEncoder;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOverride;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.util.Msg;
import ghidra.util.exception.NotYetImplementedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SleighInstructionPrototype
implements InstructionPrototype {
    public static final int RETURN = 1;
    public static final int CALL_INDIRECT = 2;
    public static final int BRANCH_INDIRECT = 4;
    public static final int CALL = 8;
    public static final int JUMPOUT = 16;
    public static final int NO_FALLTHRU = 32;
    public static final int BRANCH_TO_END = 64;
    public static final int CROSSBUILD = 128;
    public static final int LABEL = 256;
    private SleighLanguage language;
    private boolean isindelayslot;
    private FlowType flowType;
    private int[] opresolve;
    private RefType[] opRefTypes;
    private List<FlowRecord> flowStateList;
    private int delaySlotByteCnt;
    private boolean hasCrossBuilds;
    private ArrayList<ArrayList<FlowRecord>> flowStateListNamed;
    private static final PcodeOp[] emptyPCode = new PcodeOp[0];
    private static final Object[] emptyObject = new Object[0];
    private static final Address[] emptyFlow = new Address[0];
    private ContextCache contextCache;
    private int length;
    private ConstructState rootState;
    private ConstructState mnemonicState;
    private int hashcode;
    private Mask instrMask;
    private Mask[] operandMasks;

    public SleighInstructionPrototype(SleighLanguage lang, MemBuffer buf, ProcessorContextView context, ContextCache cache, boolean inDelaySlot, SleighDebugLogger debug) throws UnknownInstructionException, MemoryAccessException {
        this.language = lang;
        this.contextCache = cache;
        this.isindelayslot = inDelaySlot;
        this.rootState = new ConstructState(null);
        SleighParserContext protoContext = new SleighParserContext(buf, this, context);
        this.resolve(lang.getRootDecisionNode(), protoContext, debug);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    ConstructState getMnemonicState() {
        return this.mnemonicState;
    }

    private void cacheMnemonicState() {
        this.mnemonicState = this.rootState;
        Constructor ct = this.mnemonicState.getConstructor();
        int index = ct.getFlowthruIndex();
        while (index >= 0) {
            this.mnemonicState = this.mnemonicState.getSubState(index);
            ct = this.mnemonicState.getConstructor();
            index = ct.getFlowthruIndex();
        }
        this.opresolve = ct.getOpsPrintOrder();
        this.opRefTypes = new RefType[this.opresolve.length];
        Arrays.fill(this.opRefTypes, null);
    }

    @Override
    public boolean hasDelaySlots() {
        return this.delaySlotByteCnt != 0;
    }

    @Override
    public boolean hasCrossBuildDependency() {
        return this.hasCrossBuilds;
    }

    private static void addExplicitFlow(ConstructState state, OpTpl op, int flags, FlowSummary summary) {
        if (summary.flowState == null) {
            summary.flowState = new ArrayList();
        }
        FlowRecord res = new FlowRecord();
        summary.flowState.add(res);
        res.flowFlags = flags;
        res.op = op;
        res.addressnode = null;
        VarnodeTpl dest = op.getInput()[0];
        if ((flags & 0x98) == 0) {
            return;
        }
        if (state == null) {
            return;
        }
        if ((flags & 0x80) != 0) {
            res.addressnode = state;
        } else if (dest.getOffset().getType() == 1) {
            int oper = dest.getOffset().getHandleIndex();
            Constructor ct = state.getConstructor();
            OperandSymbol sym = ct.getOperand(oper);
            if (sym.isCodeAddress()) {
                res.addressnode = state.getSubState(oper);
            }
        }
    }

    public static FlowSummary walkTemplates(OpTplWalker walker) {
        FlowSummary res = new FlowSummary();
        while (walker.isState()) {
            Object state = walker.nextOpTpl();
            if (state == null) {
                walker.popBuild();
                continue;
            }
            if (state instanceof Integer) {
                walker.pushBuild((Integer)state);
                continue;
            }
            res.lastop = (OpTpl)state;
            switch (res.lastop.getOpcode()) {
                case 66: {
                    res.hasCrossBuilds = true;
                    SleighInstructionPrototype.addExplicitFlow(walker.getState(), res.lastop, 128, res);
                    break;
                }
                case 6: {
                    SleighInstructionPrototype.addExplicitFlow(null, res.lastop, 36, res);
                    break;
                }
                case 4: {
                    int destType = res.lastop.getInput()[0].getOffset().getType();
                    int flags = destType == 3 ? 64 : (destType == 2 ? 32 : (destType == 8 ? 32 : 48));
                    SleighInstructionPrototype.addExplicitFlow(walker.getState(), res.lastop, flags, res);
                    break;
                }
                case 5: {
                    int destType = res.lastop.getInput()[0].getOffset().getType();
                    int flags = destType == 3 ? 64 : (destType == 4 ? 16 : (destType != 2 && destType != 8 ? 16 : 0));
                    SleighInstructionPrototype.addExplicitFlow(walker.getState(), res.lastop, flags, res);
                    break;
                }
                case 7: {
                    SleighInstructionPrototype.addExplicitFlow(walker.getState(), res.lastop, 8, res);
                    break;
                }
                case 8: {
                    SleighInstructionPrototype.addExplicitFlow(null, res.lastop, 2, res);
                    break;
                }
                case 10: {
                    SleighInstructionPrototype.addExplicitFlow(null, res.lastop, 33, res);
                    break;
                }
                case 65: {
                    SleighInstructionPrototype.addExplicitFlow(null, res.lastop, 256, res);
                    break;
                }
                case 61: {
                    int destType = (int)res.lastop.getInput()[0].getOffset().getReal();
                    if (destType <= res.delay) break;
                    res.delay = destType;
                }
            }
        }
        return res;
    }

    public static FlowType flowListToFlowType(List<FlowRecord> flowstate) {
        if (flowstate == null) {
            return RefType.FALL_THROUGH;
        }
        int flags = 0;
        for (FlowRecord rec : flowstate) {
            flags &= 0xFFFFFE5F;
            flags |= rec.flowFlags;
        }
        return SleighInstructionPrototype.convertFlowFlags(flags);
    }

    private void cacheTreeInfo() {
        OpTplWalker walker = new OpTplWalker(this.rootState, -1);
        FlowSummary summary = SleighInstructionPrototype.walkTemplates(walker);
        this.delaySlotByteCnt = summary.delay;
        this.hasCrossBuilds = summary.hasCrossBuilds;
        if (summary.flowState != null) {
            this.flowStateList = summary.flowState;
            this.flowType = SleighInstructionPrototype.flowListToFlowType(summary.flowState);
        } else {
            this.flowStateList = new ArrayList<FlowRecord>();
            this.flowType = RefType.FALL_THROUGH;
        }
        this.flowStateListNamed = null;
        int numsects = this.language.numSections();
        if (numsects > 0) {
            this.flowStateListNamed = new ArrayList();
            for (int i = 0; i < numsects; ++i) {
                this.flowStateListNamed.add(null);
                walker = new OpTplWalker(this.rootState, i);
                summary = SleighInstructionPrototype.walkTemplates(walker);
                this.flowStateListNamed.set(i, summary.flowState);
            }
        }
    }

    private static FlowType convertFlowFlags(int flowFlags) {
        if ((flowFlags & 0x100) != 0) {
            flowFlags |= 0x40;
        }
        switch (flowFlags &= 0xFFFFFE7F) {
            case 0: 
            case 64: {
                return RefType.FALL_THROUGH;
            }
            case 8: {
                return RefType.UNCONDITIONAL_CALL;
            }
            case 41: {
                return RefType.CALL_TERMINATOR;
            }
            case 35: {
                return RefType.COMPUTED_CALL_TERMINATOR;
            }
            case 72: {
                return RefType.CONDITIONAL_CALL;
            }
            case 56: {
                return RefType.COMPUTED_JUMP;
            }
            case 105: {
                return RefType.UNCONDITIONAL_CALL;
            }
            case 2: {
                return RefType.COMPUTED_CALL;
            }
            case 36: {
                return RefType.COMPUTED_JUMP;
            }
            case 68: 
            case 100: 
            case 116: {
                return RefType.CONDITIONAL_COMPUTED_JUMP;
            }
            case 66: 
            case 98: {
                return RefType.CONDITIONAL_COMPUTED_CALL;
            }
            case 33: {
                return RefType.TERMINATOR;
            }
            case 65: 
            case 97: {
                return RefType.CONDITIONAL_TERMINATOR;
            }
            case 16: {
                return RefType.CONDITIONAL_JUMP;
            }
            case 48: {
                return RefType.UNCONDITIONAL_JUMP;
            }
            case 112: {
                return RefType.CONDITIONAL_JUMP;
            }
            case 49: {
                return RefType.JUMP_TERMINATOR;
            }
            case 52: {
                return RefType.COMPUTED_JUMP;
            }
            case 37: {
                return RefType.JUMP_TERMINATOR;
            }
            case 32: {
                return RefType.TERMINATOR;
            }
            case 80: {
                return RefType.CONDITIONAL_JUMP;
            }
            case 96: {
                return RefType.FALL_THROUGH;
            }
        }
        return RefType.INVALID;
    }

    void cacheInfo(MemBuffer memBuf, ProcessorContextView context, boolean computeMasks) {
        this.length = this.rootState.getLength();
        this.cacheTreeInfo();
        this.cacheMnemonicState();
        if (computeMasks) {
            this.cacheInstructionMasks(memBuf, context);
        }
    }

    private void cacheInstructionMasks(MemBuffer memBuf, ProcessorContextView context) {
        SleighDebugLogger sdl = new SleighDebugLogger(memBuf, context, this.language, SleighDebugLogger.SleighDebugMode.MASKS_ONLY);
        if (!sdl.parseFailed()) {
            this.operandMasks = new Mask[this.getNumOperands()];
            this.instrMask = new MaskImpl(sdl.getInstructionMask());
            for (int i = 0; i < this.operandMasks.length; ++i) {
                this.operandMasks[i] = new MaskImpl(sdl.getOperandValueMask(i));
            }
        }
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    @Override
    public Mask getInstructionMask() {
        return this.instrMask;
    }

    @Override
    public Mask getOperandValueMask(int operandIndex) {
        if (this.operandMasks == null) {
            return null;
        }
        return this.operandMasks[operandIndex];
    }

    @Override
    public FlowType getFlowType(InstructionContext context) {
        if (!this.hasCrossBuilds) {
            return this.flowType;
        }
        int flags = 0;
        try {
            flags = this.gatherFlags(0, context, -1);
        }
        catch (MemoryAccessException e) {
            return RefType.INVALID;
        }
        catch (UnknownContextException e) {
            return RefType.INVALID;
        }
        return SleighInstructionPrototype.convertFlowFlags(flags);
    }

    @Override
    public int getDelaySlotByteCount() {
        return this.delaySlotByteCnt;
    }

    @Override
    public int getDelaySlotDepth(InstructionContext context) {
        int delayInstrCnt = 0;
        int byteCnt = 0;
        int offset = this.getLength();
        if (this.delaySlotByteCnt == 1) {
            return 1;
        }
        try {
            ReadOnlyProcessorContext roContext = new ReadOnlyProcessorContext(context.getProcessorContext());
            while (byteCnt < this.delaySlotByteCnt) {
                WrappedMemBuffer delaymem = new WrappedMemBuffer(context.getMemBuffer(), offset);
                SleighInstructionPrototype proto = (SleighInstructionPrototype)this.language.parse(delaymem, roContext, true);
                int len = proto.getLength();
                offset += len;
                byteCnt += len;
                ++delayInstrCnt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return delayInstrCnt;
    }

    @Override
    public boolean isInDelaySlot() {
        return this.isindelayslot;
    }

    @Override
    public int getNumOperands() {
        return this.opresolve.length;
    }

    @Override
    public int getOpType(int opIndex, InstructionContext context) {
        int indirect;
        SleighParserContext protoContext;
        if (opIndex < 0 || opIndex >= this.opresolve.length) {
            return 0x400000;
        }
        try {
            protoContext = (SleighParserContext)context.getParserContext();
        }
        catch (MemoryAccessException e) {
            return 0x400000;
        }
        ConstructState opState = this.mnemonicState.getSubState(this.opresolve[opIndex]);
        FixedHandle hand = protoContext.getFixedHandle(opState);
        if (hand.isInvalid()) {
            return 0x400000;
        }
        int n = indirect = this.isIndirect(this.opresolve[opIndex]) ? 4 : 0;
        if (hand.offset_space == null) {
            int type = hand.space.getType();
            if (type == 4) {
                return 0x200 | indirect;
            }
            if (type == 0) {
                return 0x4000 | indirect;
            }
            OperandSymbol sym = this.mnemonicState.getConstructor().getOperand(this.opresolve[opIndex]);
            if (sym.isCodeAddress()) {
                return 0x2040 | indirect;
            }
            if (type == 1) {
                return 0x2080 | indirect;
            }
        }
        return 0x400000 | indirect;
    }

    private boolean isIndirect(int sleighOpIndex) {
        OpTpl[] opVec;
        Constructor constructor = this.mnemonicState.getConstructor();
        ConstructTpl templ = constructor.getTempl();
        if (templ == null) {
            return false;
        }
        for (OpTpl opTpl : opVec = templ.getOpVec()) {
            VarnodeTpl varnodeTpl;
            ConstTpl space;
            int opcode = opTpl.getOpcode();
            if (opcode != 8 && opcode != 6 || (space = (varnodeTpl = opTpl.getInput()[0]).getSpace()).getType() != 1 || space.getHandleIndex() != sleighOpIndex) continue;
            return true;
        }
        return false;
    }

    @Override
    public Address getFallThrough(InstructionContext context) {
        if (this.flowType.hasFallthrough()) {
            try {
                return context.getAddress().addNoWrap(this.getFallThroughOffset(context));
            }
            catch (AddressOverflowException addressOverflowException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public int getFallThroughOffset(InstructionContext context) {
        if (this.delaySlotByteCnt <= 0) {
            return this.getLength();
        }
        try {
            int len;
            int offset = this.getLength();
            int bytecount = 0;
            ReadOnlyProcessorContext roContext = new ReadOnlyProcessorContext(context.getProcessorContext());
            do {
                WrappedMemBuffer delaymem = new WrappedMemBuffer(context.getMemBuffer(), offset);
                SleighInstructionPrototype proto = (SleighInstructionPrototype)this.language.parse(delaymem, roContext, true);
                len = proto.getLength();
                offset += len;
            } while ((bytecount += len) < this.delaySlotByteCnt);
            return offset;
        }
        catch (Exception e) {
            return this.getLength();
        }
    }

    private int gatherFlags(int curflags, InstructionContext context, int secnum) throws MemoryAccessException, UnknownContextException {
        List curlist = null;
        if (secnum < 0) {
            curlist = this.flowStateList;
        } else if (this.flowStateListNamed != null && secnum < this.flowStateListNamed.size()) {
            curlist = this.flowStateListNamed.get(secnum);
        }
        if (curlist == null) {
            return curflags;
        }
        for (FlowRecord rec : curlist) {
            if ((rec.flowFlags & 0x80) != 0) {
                ParserWalker walker = new ParserWalker((SleighParserContext)context.getParserContext());
                walker.subTreeState(rec.addressnode);
                VarnodeTpl vn = rec.op.getInput()[0];
                AddressSpace spc = vn.getSpace().fixSpace(walker);
                Address addr = spc.getTruncatedAddress(vn.getOffset().fix(walker), false);
                addr = this.handleOverlayAddress(context, addr);
                SleighParserContext crosscontext = (SleighParserContext)context.getParserContext(addr);
                int newsecnum = (int)rec.op.getInput()[1].getOffset().getReal();
                SleighInstructionPrototype crossproto = crosscontext.getPrototype();
                curflags = crossproto.gatherFlags(curflags, context, newsecnum);
                continue;
            }
            curflags &= 0xFFFFFE5F;
            curflags |= rec.flowFlags;
        }
        return curflags;
    }

    private Address handleOverlayAddress(InstructionContext context, Address addr) {
        AddressSpace addressSpace = context.getAddress().getAddressSpace();
        if (addressSpace.isOverlaySpace()) {
            OverlayAddressSpace ospace = (OverlayAddressSpace)addressSpace;
            addr = ospace.getOverlayAddress(addr);
        }
        return addr;
    }

    private void gatherFlows(ArrayList<Address> res, SleighParserContext parsecontext, InstructionContext context, int secnum) throws MemoryAccessException, UnknownContextException {
        List curlist = null;
        if (secnum < 0) {
            curlist = this.flowStateList;
        } else if (this.flowStateListNamed != null && secnum < this.flowStateListNamed.size()) {
            curlist = this.flowStateListNamed.get(secnum);
        }
        if (curlist == null) {
            return;
        }
        for (FlowRecord rec : curlist) {
            if ((rec.flowFlags & 0x80) != 0) {
                ParserWalker walker = new ParserWalker(parsecontext);
                walker.subTreeState(rec.addressnode);
                VarnodeTpl vn = rec.op.getInput()[0];
                AddressSpace spc = vn.getSpace().fixSpace(walker);
                Address addr = spc.getTruncatedAddress(vn.getOffset().fix(walker), false);
                addr = this.handleOverlayAddress(context, addr);
                SleighParserContext crosscontext = (SleighParserContext)context.getParserContext(addr);
                int newsecnum = (int)rec.op.getInput()[1].getOffset().getReal();
                SleighInstructionPrototype crossproto = crosscontext.getPrototype();
                crossproto.gatherFlows(res, crosscontext, context, newsecnum);
                continue;
            }
            if ((rec.flowFlags & 0x18) == 0) continue;
            FixedHandle hand = parsecontext.getFixedHandle(rec.addressnode);
            if (!hand.isInvalid() && hand.offset_space == null) {
                Address addr = this.getHandleAddr(hand, parsecontext.getAddr().getAddressSpace());
                res.add(addr);
                continue;
            }
            if (rec.op.getInput()[0].getOffset().getType() != 4) continue;
            res.add(parsecontext.getN2addr());
        }
    }

    @Override
    public Address[] getFlows(InstructionContext context) {
        if (this.flowStateList.size() == 0) {
            return emptyFlow;
        }
        ArrayList<Address> addresses = new ArrayList<Address>();
        try {
            this.gatherFlows(addresses, (SleighParserContext)context.getParserContext(), context, -1);
        }
        catch (MemoryAccessException e) {
            return emptyFlow;
        }
        catch (UnknownContextException e) {
            return emptyFlow;
        }
        if (addresses.size() == 0) {
            return emptyFlow;
        }
        return addresses.toArray(new Address[addresses.size()]);
    }

    @Override
    public String getSeparator(int opIndex, InstructionContext context) {
        if (opIndex < 0 || opIndex > this.opresolve.length) {
            return null;
        }
        try {
            Constructor ct = this.mnemonicState.getConstructor();
            return ct.printSeparator(opIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ArrayList<Object> getOpRepresentationList(int opIndex, InstructionContext context) {
        if (opIndex < 0 || opIndex >= this.opresolve.length) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            SleighParserContext protoContext = (SleighParserContext)context.getParserContext();
            Constructor ct = this.mnemonicState.getConstructor();
            OperandSymbol sym = ct.getOperand(this.opresolve[opIndex]);
            ParserWalker walker = new ParserWalker(protoContext);
            walker.subTreeState(this.mnemonicState);
            sym.printList(walker, list);
        }
        catch (Exception ct) {
            // empty catch block
        }
        AddressSpace curSpace = context.getAddress().getAddressSpace();
        ArrayList<Object> objList = new ArrayList<Object>();
        for (Object e : list) {
            if (e instanceof Character) {
                objList.add(e);
                continue;
            }
            this.addHandleObject(curSpace, (FixedHandle)e, objList);
        }
        return objList;
    }

    OperandSymbol getOperandSymbol(int opIndex, MemBuffer buf, ProcessorContextView context) {
        if (opIndex < 0 || opIndex >= this.opresolve.length) {
            return null;
        }
        try {
            Constructor ct = this.mnemonicState.getConstructor();
            return ct.getOperand(this.opresolve[opIndex]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Address getAddress(int opIndex, InstructionContext context) {
        if (opIndex < 0 || opIndex >= this.opresolve.length) {
            return null;
        }
        FixedHandle hand = null;
        try {
            SleighParserContext protoContext = (SleighParserContext)context.getParserContext();
            ConstructState opState = this.mnemonicState.getSubState(this.opresolve[opIndex]);
            hand = protoContext.getFixedHandle(opState);
            if (hand.isInvalid()) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (hand.offset_space == null && hand.space.getType() == 1) {
            return this.getHandleAddr(hand, context.getAddress().getAddressSpace());
        }
        return null;
    }

    @Override
    public Scalar getScalar(int opIndex, InstructionContext context) {
        if (opIndex < 0 || opIndex >= this.opresolve.length) {
            return null;
        }
        try {
            SleighParserContext protoContext = (SleighParserContext)context.getParserContext();
            ConstructState opState = this.mnemonicState.getSubState(this.opresolve[opIndex]);
            FixedHandle hand = protoContext.getFixedHandle(opState);
            if (hand.isInvalid()) {
                return null;
            }
            if (hand.space.getType() == 0) {
                int size = hand.size;
                if (size == 0 && (size = hand.offset_size) == 0) {
                    size = this.language.getDefaultSpace().getPointerSize();
                }
                boolean signed = hand.offset_offset < 0L;
                return new Scalar(size * 8, hand.offset_offset, signed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Register getRegister(int opIndex, InstructionContext context) {
        if (opIndex < 0 || opIndex >= this.opresolve.length) {
            return null;
        }
        try {
            SleighParserContext protoContext = (SleighParserContext)context.getParserContext();
            ConstructState opState = this.mnemonicState.getSubState(this.opresolve[opIndex]);
            FixedHandle hand = protoContext.getFixedHandle(opState);
            if (hand.isInvalid()) {
                return null;
            }
            if (hand.space.getType() == 4) {
                return this.language.getRegister(hand.space, hand.offset_offset, hand.size);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Object[] getOpObjects(int opIndex, InstructionContext context) {
        if (opIndex < 0 || opIndex >= this.opresolve.length) {
            return emptyObject;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : this.getOpRepresentationList(opIndex, context)) {
            if (obj instanceof Character) continue;
            list.add(obj);
        }
        Object[] retobj = new Object[list.size()];
        list.toArray(retobj);
        return retobj;
    }

    @Override
    public boolean hasDelimeter(int opIndex) {
        return opIndex < this.opresolve.length - 1;
    }

    @Override
    public Object[] getInputObjects(InstructionContext context) {
        PcodeOp[] pcode = null;
        try {
            pcode = this.getPcode(context, null);
        }
        catch (Exception e) {
            return new Object[0];
        }
        HashSet<Object> inlist = new HashSet<Object>();
        HashSet<Object> outlist = new HashSet<Object>();
        for (PcodeOp element : pcode) {
            this.getInputObjects(element, inlist, outlist);
            this.getResultObject(element, outlist);
        }
        return inlist.toArray(new Object[0]);
    }

    private void getInputObjects(PcodeOp pcode, HashSet<Object> inputObjects, HashSet<Object> writtenObjects) {
        Varnode[] varNode = pcode.getInputs();
        int vi = 0;
        int opID = pcode.getOpcode();
        if (opID == 7 || opID == 4) {
            return;
        }
        if (opID == 5) {
            ++vi;
        } else if (opID == 3) {
            ++vi;
        } else if (opID == 2) {
            AddressSpace space;
            if (varNode[1].isConstant() && (space = this.language.getAddressFactory().getAddressSpace((int)varNode[0].getOffset())) != null) {
                Address inAddr = space.getAddress(varNode[1].getOffset());
                if (!writtenObjects.contains(inAddr)) {
                    inputObjects.add(inAddr);
                }
                return;
            }
            ++vi;
        }
        while (vi < varNode.length) {
            Varnode node = varNode[vi];
            Object obj = this.getVarnodeObject(node);
            if (obj != null && !writtenObjects.contains(obj)) {
                inputObjects.add(obj);
            }
            ++vi;
        }
    }

    @Override
    public Object[] getResultObjects(InstructionContext context) {
        PcodeOp[] pcode = null;
        try {
            pcode = this.getPcode(context, null);
        }
        catch (Exception e) {
            return new Object[0];
        }
        HashSet<Object> results = new HashSet<Object>();
        for (PcodeOp element : pcode) {
            this.getResultObject(element, results);
        }
        return results.toArray(new Object[0]);
    }

    private void getResultObject(PcodeOp pcode, HashSet<Object> results) {
        Varnode[] varNode = pcode.getInputs();
        if (pcode.getOpcode() == 3) {
            AddressSpace space;
            if (varNode[1].isConstant() && (space = this.language.getAddressFactory().getAddressSpace((int)varNode[0].getOffset())) != null) {
                results.add(space.getAddress(varNode[1].getOffset()));
            }
        } else {
            Object obj = this.getVarnodeObject(pcode.getOutput());
            if (obj != null) {
                results.add(obj);
            }
        }
    }

    private Object getVarnodeObject(Varnode node) {
        if (node == null) {
            return null;
        }
        if (node.isConstant()) {
            int bitsize = node.getSize() * 8;
            bitsize = bitsize > 64 ? 64 : bitsize;
            boolean signed = node.getOffset() < 0L;
            Scalar scalar = new Scalar(bitsize, node.getOffset(), signed);
            return scalar;
        }
        if (node.isAddress() || node.isRegister()) {
            Register reg = this.language.getRegister(node.getAddress(), node.getSize());
            return reg != null ? reg : node.getAddress();
        }
        return null;
    }

    @Override
    public PcodeOp[] getPcode(InstructionContext context, PcodeOverride override) {
        try {
            SleighParserContext protoContext = (SleighParserContext)context.getParserContext();
            int fallOffset = this.getLength();
            if (this.delaySlotByteCnt > 0) {
                int len;
                int bytecount = 0;
                do {
                    Address addr = context.getAddress().add(fallOffset);
                    SleighParserContext delay = (SleighParserContext)context.getParserContext(addr);
                    len = delay.getPrototype().getLength();
                    fallOffset += len;
                } while ((bytecount += len) < this.delaySlotByteCnt);
                protoContext = new SleighParserContext(protoContext, bytecount);
            }
            ParserWalker walker = new ParserWalker(protoContext);
            walker.baseState();
            PcodeEmitObjects emit = new PcodeEmitObjects(walker, context, fallOffset, override);
            emit.build(walker.getConstructor().getTempl(), -1);
            emit.resolveRelatives();
            if (!this.isindelayslot) {
                emit.resolveFinalFallthrough();
            }
            return emit.getPcodeOp();
        }
        catch (NotYetImplementedException protoContext) {
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Pcode error at " + String.valueOf(context.getAddress()) + ": " + e.getMessage()));
        }
        PcodeOp[] res = new PcodeOp[]{new PcodeOp(context.getAddress(), 0, 0)};
        return res;
    }

    @Override
    public void getPcodePacked(PatchEncoder encoder, InstructionContext context, PcodeOverride override) throws IOException {
        int fallOffset = this.getLength();
        try {
            SleighParserContext protoContext = (SleighParserContext)context.getParserContext();
            if (this.delaySlotByteCnt > 0) {
                int len;
                int bytecount = 0;
                do {
                    Address addr = context.getAddress().add(fallOffset);
                    SleighParserContext delay = (SleighParserContext)context.getParserContext(addr);
                    len = delay.getPrototype().getLength();
                    fallOffset += len;
                } while ((bytecount += len) < this.delaySlotByteCnt);
                protoContext = new SleighParserContext(protoContext, bytecount);
            }
            ParserWalker walker = new ParserWalker(protoContext);
            walker.baseState();
            PcodeEmitPacked emit = new PcodeEmitPacked(encoder, walker, context, fallOffset, override);
            emit.emitHeader();
            emit.build(walker.getConstructor().getTempl(), -1);
            emit.resolveRelatives();
            if (!this.isindelayslot) {
                emit.resolveFinalFallthrough();
            }
            emit.emitTail();
            return;
        }
        catch (NotYetImplementedException protoContext) {
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Pcode error at " + String.valueOf(context.getAddress()) + ": " + e.getMessage()));
        }
        encoder.clear();
        encoder.openElement(ElementId.ELEM_UNIMPL);
        encoder.writeSignedInteger(AttributeId.ATTRIB_OFFSET, this.length);
        encoder.closeElement(ElementId.ELEM_UNIMPL);
    }

    @Override
    public PcodeOp[] getPcode(InstructionContext context, int opIndex) {
        if (opIndex < 0 || opIndex >= this.opresolve.length) {
            return emptyPCode;
        }
        try {
            SleighParserContext protoContext = (SleighParserContext)context.getParserContext();
            OperandSymbol sym = this.mnemonicState.getConstructor().getOperand(this.opresolve[opIndex]);
            if (sym.getDefiningSymbol() instanceof SubtableSymbol) {
                ParserWalker walker = new ParserWalker(protoContext);
                walker.subTreeState(this.mnemonicState);
                walker.pushOperand(this.opresolve[opIndex]);
                PcodeEmitObjects emit = new PcodeEmitObjects(walker);
                emit.build(walker.getConstructor().getTempl(), -1);
                emit.resolveRelatives();
                if (!this.isindelayslot) {
                    emit.resolveFinalFallthrough();
                }
                return emit.getPcodeOp();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return emptyPCode;
    }

    @Override
    public RefType getOperandRefType(int opIndex, InstructionContext context, PcodeOverride override) {
        SleighParserContext protoContext;
        if (opIndex < 0 || opIndex >= this.opRefTypes.length) {
            return null;
        }
        boolean hasOverride = false;
        if (override != null) {
            boolean bl = hasOverride = override.getFlowOverride() != FlowOverride.NONE || override.getFallThroughOverride() != null;
        }
        if (!hasOverride) {
            RefType refType = this.opRefTypes[opIndex];
            if (refType != null) {
                return refType;
            }
            this.cacheDefaultOperandRefTypes(context);
            return this.opRefTypes[opIndex];
        }
        try {
            protoContext = (SleighParserContext)context.getParserContext();
        }
        catch (MemoryAccessException e) {
            return RefType.DATA;
        }
        PcodeOp[] pcode = this.getPcode(context, override);
        if (pcode == null || pcode.length == 0) {
            return RefType.DATA;
        }
        ConstructState opState = this.mnemonicState.getSubState(this.opresolve[opIndex]);
        FixedHandle opHandle = protoContext.getFixedHandle(opState);
        if (opHandle == null || opHandle.isInvalid()) {
            return null;
        }
        RefType refType = RefType.DATA;
        if (opHandle.isDynamic()) {
            refType = this.getDynamicOperandRefType(opHandle, pcode);
        } else {
            Varnode var = opHandle.getStaticVarnode();
            if (var != null) {
                refType = this.getStaticOperandRefType(var, pcode);
            }
        }
        return refType;
    }

    private void cacheDefaultOperandRefTypes(InstructionContext context) {
        int index;
        SleighParserContext protoContext;
        try {
            protoContext = (SleighParserContext)context.getParserContext();
        }
        catch (MemoryAccessException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        PcodeOp[] pcode = this.getPcode(context, null);
        if (pcode == null || pcode.length == 0) {
            return;
        }
        FixedHandle[] opHandles = new FixedHandle[this.opresolve.length];
        for (index = 0; index < this.opresolve.length; ++index) {
            ConstructState opState = this.mnemonicState.getSubState(this.opresolve[index]);
            opHandles[index] = protoContext.getFixedHandle(opState);
        }
        for (index = 0; index < opHandles.length; ++index) {
            if (opHandles[index] == null || opHandles[index].isInvalid() || this.opRefTypes[index] != null) continue;
            RefType refType = RefType.DATA;
            if (opHandles[index].isDynamic()) {
                refType = this.getDynamicOperandRefType(opHandles[index], pcode);
            } else {
                Varnode var = opHandles[index].getStaticVarnode();
                if (var != null) {
                    refType = this.getStaticOperandRefType(var, pcode);
                }
            }
            this.opRefTypes[index] = refType;
            for (int n = index + 1; n < opHandles.length; ++n) {
                if (!opHandles[index].equals(opHandles[n])) continue;
                this.opRefTypes[n] = refType;
            }
        }
    }

    private RefType getStaticOperandRefType(Varnode var, PcodeOp[] pcode) {
        if (var.isConstant()) {
            return RefType.DATA;
        }
        boolean isRead = false;
        boolean isWrite = false;
        for (PcodeOp element : pcode) {
            Varnode[] inputs = element.getInputs();
            switch (element.getOpcode()) {
                case 6: 
                case 8: 
                case 10: {
                    if (!inputs[0].equals(var)) break;
                    return RefType.INDIRECTION;
                }
                case 4: {
                    if (!inputs[0].equals(var)) break;
                    return RefType.UNCONDITIONAL_JUMP;
                }
                case 5: {
                    if (!inputs[0].equals(var)) break;
                    return RefType.CONDITIONAL_JUMP;
                }
                case 7: {
                    if (!inputs[0].equals(var)) break;
                    return RefType.UNCONDITIONAL_CALL;
                }
            }
            if (var.isUnique()) continue;
            if (var.equals(element.getOutput())) {
                isWrite = true;
            }
            for (Varnode input : element.getInputs()) {
                if (!var.equals(input)) continue;
                isRead = true;
            }
        }
        if (isRead && isWrite) {
            return RefType.READ_WRITE;
        }
        if (isRead) {
            return RefType.READ;
        }
        if (isWrite) {
            return RefType.WRITE;
        }
        return RefType.DATA;
    }

    private RefType getDynamicOperandRefType(FixedHandle hand, PcodeOp[] pcode) {
        Varnode offset = hand.getDynamicOffset();
        Varnode staticAddr = hand.getStaticVarnode();
        Varnode temp = hand.getDynamicTemp();
        boolean isRead = false;
        boolean isWrite = false;
        block8: for (PcodeOp element : pcode) {
            Varnode[] inputs = element.getInputs();
            switch (element.getOpcode()) {
                case 2: {
                    if (!temp.equals(element.getOutput())) continue block8;
                    isRead = true;
                    continue block8;
                }
                case 3: {
                    if (!offset.equals(inputs[1]) || !temp.equals(inputs[2])) continue block8;
                    isWrite = true;
                    continue block8;
                }
                case 6: 
                case 8: 
                case 10: {
                    if (!inputs[0].equals(temp) && !inputs[0].equals(staticAddr)) continue block8;
                    return RefType.INDIRECTION;
                }
                case 4: {
                    if (!inputs[0].equals(staticAddr)) continue block8;
                    return RefType.UNCONDITIONAL_JUMP;
                }
                case 5: {
                    if (!inputs[0].equals(staticAddr)) continue block8;
                    return RefType.CONDITIONAL_JUMP;
                }
                case 7: {
                    if (!inputs[0].equals(staticAddr)) continue block8;
                    return RefType.UNCONDITIONAL_CALL;
                }
            }
        }
        if (isRead && isWrite) {
            return RefType.READ_WRITE;
        }
        if (isRead) {
            return RefType.READ;
        }
        if (isWrite) {
            return RefType.WRITE;
        }
        return RefType.DATA;
    }

    @Override
    public String getMnemonic(InstructionContext context) {
        try {
            SleighParserContext protoContext = (SleighParserContext)context.getParserContext();
            ParserWalker walker = new ParserWalker(protoContext);
            walker.baseState();
            Object mnemonic = walker.getConstructor().printMnemonic(walker);
            if (this.isindelayslot) {
                mnemonic = "_" + (String)mnemonic;
            }
            return mnemonic;
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            Msg.error((Object)this, (Object)("*****  SLEIGH instruction PROBLEM at " + String.valueOf(context.getAddress())));
            return "UNKNOWN";
        }
    }

    private void resolve(DecisionNode root, SleighParserContext protoContext, SleighDebugLogger debug) throws MemoryAccessException, UnknownInstructionException {
        if (debug != null && debug.isVerboseEnabled()) {
            debug.append("resolving constructor for instruction bytes at: " + protoContext.getAddr().toString(true) + "\n");
        }
        ParserWalker walker = new ParserWalker(protoContext);
        walker.baseState();
        walker.setOffset(0);
        Constructor ct = root.resolve(walker, debug);
        walker.setConstructor(ct);
        ct.applyContext(walker, debug);
        while (walker.isState()) {
            int oper;
            ct = walker.getConstructor();
            int numoper = ct.getNumOperands();
            for (oper = walker.getOperand(); oper < numoper; ++oper) {
                OperandSymbol sym = ct.getOperand(oper);
                int off = walker.getOffset(sym.getOffsetBase()) + sym.getRelativeOffset();
                walker.allocateOperand();
                walker.setOffset(off);
                TripleSymbol tsym = sym.getDefiningSymbol();
                if (tsym != null) {
                    Constructor subct;
                    if (debug != null) {
                        debug.append(tsym.getName() + ": resolving...\n");
                        debug.indent();
                        debug.startPatternGroup(sym.getName());
                    }
                    if ((subct = tsym.resolve(walker, debug)) != null) {
                        walker.setConstructor(subct);
                        subct.applyContext(walker, debug);
                        if (debug == null) break;
                        debug.indent();
                        break;
                    }
                    if (debug != null) {
                        walker.popOperand();
                        debug.dumpFixedHandle(sym.getName(), tsym, walker, this.language);
                        walker.pushOperand(oper);
                        debug.endPatternGroup(true);
                        debug.dropIndent();
                    }
                } else if (debug != null) {
                    debug.dumpPattern(sym, walker);
                }
                walker.setCurrentLength(sym.getMinimumLength());
                walker.popOperand();
            }
            if (oper < numoper) continue;
            walker.calcCurrentLength(ct.getMinimumLength(), numoper);
            walker.popOperand();
            if (debug == null || !walker.isState()) continue;
            debug.dropIndent();
            debug.endPatternGroup(true);
            debug.dropIndent();
        }
        this.hashcode = this.rootState.hashCode();
        if (this.isindelayslot) {
            this.hashcode += 0xFABFAB;
        }
    }

    private void resolveHandles(SleighParserContext protoContext) throws MemoryAccessException {
        ParserWalker walker = new ParserWalker(protoContext);
        walker.baseState();
        while (walker.isState()) {
            int oper;
            Constructor ct = walker.getConstructor();
            int numoper = ct.getNumOperands();
            for (oper = walker.getOperand(); oper < numoper; ++oper) {
                OperandSymbol sym = ct.getOperand(oper);
                walker.pushOperand(oper);
                TripleSymbol triple = sym.getDefiningSymbol();
                if (triple != null) {
                    if (triple instanceof SubtableSymbol) break;
                    FixedHandle handle = walker.getParentHandle();
                    triple.getFixedHandle(handle, walker);
                } else {
                    PatternExpression patexp = sym.getDefiningExpression();
                    long res = patexp.getValue(walker);
                    FixedHandle hand = walker.getParentHandle();
                    hand.space = protoContext.getConstSpace();
                    hand.offset_space = null;
                    hand.offset_offset = res;
                    hand.size = 0;
                }
                walker.popOperand();
            }
            if (oper < numoper) continue;
            ConstructTpl templ = ct.getTempl();
            if (templ != null) {
                HandleTpl res = templ.getResult();
                if (res != null) {
                    res.fix(walker.getParentHandle(), walker);
                } else {
                    walker.getParentHandle().setInvalid();
                }
            }
            walker.popOperand();
        }
    }

    private void reconstructContext(SleighParserContext protoContext, SleighDebugLogger debug) throws MemoryAccessException {
        ParserWalker walker = new ParserWalker(protoContext);
        walker.baseState();
        while (walker.isState()) {
            Constructor ct = walker.getConstructor();
            if (ct != null) {
                int oper = walker.getOperand();
                int numoper = ct.getNumOperands();
                if (oper == 0) {
                    ct.applyContext(walker, debug);
                }
                if (oper < numoper) {
                    walker.pushOperand(oper);
                    continue;
                }
            }
            walker.popOperand();
        }
    }

    private boolean addHandleObject(AddressSpace curSpace, FixedHandle handle, ArrayList<Object> list) {
        if (handle.isInvalid()) {
            return false;
        }
        int type = handle.space.getType();
        if (type == 4) {
            Register reg = this.language.getRegister(handle.space, handle.offset_offset, handle.size);
            if (reg == null) {
                list.add("<BAD_register_" + handle.offset_offset + ":" + handle.size + ">");
            } else {
                list.add(reg);
            }
            return true;
        }
        if (type == 0) {
            int size = handle.size;
            if (size == 0 && (size = handle.offset_size) == 0) {
                size = this.language.getDefaultSpace().getPointerSize();
            }
            boolean signed = handle.offset_offset < 0L;
            Scalar sc = new Scalar(size * 8, handle.offset_offset, signed);
            list.add(sc);
            return true;
        }
        if (type == 1) {
            if (handle.offset_space == null) {
                Address addr = this.getHandleAddr(handle, curSpace);
                if (addr != null) {
                    Register reg;
                    if (addr.getAddressSpace().hasMappedRegisters() && (reg = this.language.getRegister(addr, handle.size)) != null) {
                        list.add(reg);
                        return true;
                    }
                    list.add(addr);
                    return true;
                }
            } else if (handle.offset_space.getType() == 4) {
                Register reg = this.language.getRegister(handle.offset_space, handle.offset_offset, handle.offset_size);
                list.add(reg);
                return true;
            }
        }
        return false;
    }

    private Address getHandleAddr(FixedHandle hand, AddressSpace curSpace) {
        if (hand.isInvalid() || hand.space.getType() == 3 || hand.offset_space != null) {
            return null;
        }
        Address newaddr = hand.space.getTruncatedAddress(hand.offset_offset, false);
        if (curSpace.isOverlaySpace()) {
            newaddr = curSpace.getOverlayAddress(newaddr);
        }
        return newaddr;
    }

    @Override
    public SleighParserContext getParserContext(MemBuffer buf, ProcessorContextView processorContext) throws MemoryAccessException {
        SleighParserContext newContext = new SleighParserContext(buf, this, processorContext);
        this.reconstructContext(newContext, null);
        this.resolveHandles(newContext);
        return newContext;
    }

    @Override
    public ParserContext getPseudoParserContext(Address addr, MemBuffer buffer, ProcessorContextView processorContext) throws InsufficientBytesException, UnknownInstructionException, UnknownContextException, MemoryAccessException {
        ReadOnlyProcessorContext roContext = new ReadOnlyProcessorContext(processorContext);
        int offset = (int)addr.subtract(buffer.getAddress());
        WrappedMemBuffer nearbymem = new WrappedMemBuffer(buffer, offset);
        SleighInstructionPrototype proto = (SleighInstructionPrototype)this.language.parse(nearbymem, roContext, true);
        SleighParserContext newContext = new SleighParserContext(nearbymem, proto, processorContext);
        this.reconstructContext(newContext, null);
        this.resolveHandles(newContext);
        return newContext;
    }

    public ConstructState getRootState() {
        return this.rootState;
    }

    ContextCache getContextCache() {
        return this.contextCache;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    public String dumpConstructorTree() {
        return this.rootState.dumpConstructorTree();
    }

    public static class FlowSummary {
        public int delay = 0;
        public boolean hasCrossBuilds = false;
        public ArrayList<FlowRecord> flowState = null;
        public OpTpl lastop = null;
    }

    public static class FlowRecord {
        public ConstructState addressnode;
        public OpTpl op;
        public int flowFlags;
    }
}

