/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.Schema;
import db.StringField;
import db.Table;
import db.util.ErrorHandler;
import ghidra.framework.Application;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.OpenMode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.database.DataTypeArchiveDBChangeSet;
import ghidra.program.database.ProjectDataTypeManager;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DataTypeArchiveDB
extends DomainObjectAdapterDB
implements DataTypeArchive {
    static final int DB_VERSION = 4;
    private static final int UPGRADE_REQUIRED_BEFORE_VERSION = 1;
    public static final String ARCHIVE_INFO = "Data Type Archive Information";
    public static final String ARCHIVE_SETTINGS = "Data Type Archive Settings";
    public static final String DATE_CREATED = "Date Created";
    public static final String CREATED_WITH_GHIDRA_VERSION = "Created With Ghidra Version";
    public static final Date JANUARY_1_1970 = new Date(0L);
    private static final String ARCHIVE_DB_VERSION = "DB Version";
    private static final String TABLE_NAME = "Data Type Archive";
    private static final String DEFAULT_POINTER_SIZE = "Default Pointer Size";
    private static final Field[] COL_FIELDS = new Field[]{StringField.INSTANCE};
    private static final String[] COL_TYPES = new String[]{"Value"};
    private static final Schema SCHEMA = new Schema(0, (Field)StringField.INSTANCE, "Key", COL_FIELDS, COL_TYPES);
    private ProjectDataTypeManager dataTypeManager;
    private boolean recordChanges;
    private boolean changeable = true;
    private Table table;

    public DataTypeArchiveDB(DomainFolder folder, String name, Object consumer) throws IOException, DuplicateNameException, InvalidNameException {
        super(new DBHandle(), name, 500, consumer);
        this.name = name;
        this.recordChanges = false;
        boolean success = false;
        try {
            int id = this.startTransaction("create data type archive");
            this.createDatabase();
            if (this.createManagers(OpenMode.CREATE, TaskMonitor.DUMMY) != null) {
                throw new AssertException("Unexpected version exception on create");
            }
            this.changeSet = new DataTypeArchiveDBChangeSet(50);
            this.initManagers(OpenMode.CREATE, TaskMonitor.DUMMY);
            this.propertiesCreate();
            this.endTransaction(id, true);
            this.clearUndo(false);
            if (folder != null) {
                folder.createFile(name, (DomainObject)this, TaskMonitor.DUMMY);
            }
            success = true;
        }
        catch (CancelledException e) {
            throw new AssertException();
        }
        finally {
            this.dbh.closeScratchPad();
            if (!success) {
                this.release(consumer);
                this.dbh.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTypeArchiveDB(DBHandle dbh, OpenMode openMode, TaskMonitor monitor, Object consumer) throws IOException, VersionException, CancelledException {
        super(dbh, "Untitled", 500, consumer);
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        boolean success = false;
        try {
            int id = this.startTransaction("create data type archive");
            this.recordChanges = false;
            this.changeable = openMode != OpenMode.IMMUTABLE;
            VersionException dbVersionExc = this.initializeDatabase(openMode);
            VersionException versionExc = this.createManagers(openMode, monitor);
            if (dbVersionExc != null) {
                versionExc = dbVersionExc.combine(versionExc);
            }
            if (versionExc != null) {
                throw versionExc;
            }
            this.changeSet = new DataTypeArchiveDBChangeSet(50);
            this.initManagers(openMode, monitor);
            if (openMode == OpenMode.UPGRADE) {
                this.upgradeDatabase();
                this.changed = true;
            }
            this.propertiesRestore();
            this.recordChanges = true;
            this.endTransaction(id, true);
            this.clearUndo(false);
            success = true;
        }
        finally {
            dbh.closeScratchPad();
            if (!success) {
                this.release(consumer);
            }
        }
        if (openMode == OpenMode.IMMUTABLE) {
            this.setImmutable();
        }
    }

    protected void close() {
        super.close();
        if (this.dataTypeManager != null) {
            this.dataTypeManager.dispose();
        }
    }

    protected void setDomainFile(DomainFile df) {
        super.setDomainFile(df);
        this.recordChanges = true;
    }

    private void propertiesRestore() {
        Options pl = this.getOptions(ARCHIVE_INFO);
        boolean origChangeState = this.changed;
        pl.registerOption(CREATED_WITH_GHIDRA_VERSION, (Object)"4.3", null, "Version of Ghidra used to create this program.");
        pl.registerOption(DATE_CREATED, (Object)JANUARY_1_1970, null, "Date this program was created");
        this.changed = origChangeState;
    }

    private void propertiesCreate() {
        Options pl = this.getOptions(ARCHIVE_INFO);
        boolean origChangeState = this.changed;
        pl.setString(CREATED_WITH_GHIDRA_VERSION, Application.getApplicationVersion());
        pl.setDate(DATE_CREATED, new Date());
        this.changed = origChangeState;
    }

    protected boolean propertyChanged(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.endsWith(DEFAULT_POINTER_SIZE) && newValue instanceof Integer && !this.isValidDefaultpointerSize((Integer)newValue)) {
            return false;
        }
        return super.propertyChanged(propertyName, oldValue, newValue);
    }

    private boolean isValidDefaultpointerSize(int pointerSize) {
        return pointerSize > 0 && pointerSize <= 8;
    }

    @Override
    public DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    @Override
    public Date getCreationDate() {
        Options pl = this.getOptions(ARCHIVE_INFO);
        return pl.getDate(DATE_CREATED, new Date(0L));
    }

    @Override
    public int getDefaultPointerSize() {
        Options pl = this.getOptions(ARCHIVE_SETTINGS);
        return pl.getInt(DEFAULT_POINTER_SIZE, 4);
    }

    @Override
    public DataTypeArchiveDBChangeSet getChanges() {
        return (DataTypeArchiveDBChangeSet)this.changeSet;
    }

    public void dataTypeChanged(long dataTypeID, ProgramEvent eventType, boolean isAutoResponseChange, Object oldValue, Object newValue) {
        if (this.recordChanges && !isAutoResponseChange) {
            ((DataTypeArchiveDBChangeSet)this.changeSet).dataTypeChanged(dataTypeID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, oldValue, newValue));
    }

    public void dataTypeAdded(long dataTypeID, ProgramEvent eventType, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((DataTypeArchiveDBChangeSet)this.changeSet).dataTypeAdded(dataTypeID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, oldValue, newValue));
    }

    public void categoryChanged(long categoryID, ProgramEvent eventType, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((DataTypeArchiveDBChangeSet)this.changeSet).categoryChanged(categoryID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, oldValue, newValue));
    }

    public void categoryAdded(long categoryID, ProgramEvent eventType, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((DataTypeArchiveDBChangeSet)this.changeSet).categoryAdded(categoryID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, oldValue, newValue));
    }

    public void setChanged(ProgramEvent eventType, Object oldValue, Object newValue) {
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, oldValue, newValue));
    }

    public void setName(String newName) {
    }

    public String getDescription() {
        return TABLE_NAME;
    }

    private void createDatabase() throws IOException {
        this.table = this.dbh.createTable(TABLE_NAME, SCHEMA);
        DBRecord record = SCHEMA.createRecord((Field)new StringField(ARCHIVE_DB_VERSION));
        record.setString(0, Integer.toString(4));
        this.table.putRecord(record);
    }

    private VersionException initializeDatabase(OpenMode openMode) throws IOException, VersionException {
        int storedVersion;
        this.table = this.dbh.getTable(TABLE_NAME);
        if (this.table == null) {
            if (openMode == OpenMode.UPGRADE) {
                this.createDatabase();
            } else {
                throw new VersionException(true);
            }
        }
        if ((storedVersion = this.getStoredVersion()) > 4) {
            throw new VersionException(2, false);
        }
        if (openMode != OpenMode.UPGRADE && storedVersion < 1) {
            return new VersionException(true);
        }
        if (openMode == OpenMode.UPDATE && storedVersion < 4) {
            return new VersionException(true);
        }
        return null;
    }

    private void upgradeDatabase() throws IOException {
        this.table = this.dbh.getTable(TABLE_NAME);
        DBRecord record = SCHEMA.createRecord((Field)new StringField(ARCHIVE_DB_VERSION));
        record.setString(0, Integer.toString(4));
        this.table.putRecord(record);
    }

    private int getStoredVersion() throws IOException {
        DBRecord record = this.table.getRecord((Field)new StringField(ARCHIVE_DB_VERSION));
        if (record != null) {
            String s = record.getString(0);
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    private void checkOldProperties(OpenMode openMode) {
    }

    private VersionException createManagers(OpenMode openMode, TaskMonitor monitor) throws CancelledException, IOException {
        VersionException versionExc = null;
        monitor.checkCancelled();
        this.checkOldProperties(openMode);
        try {
            this.dataTypeManager = new ProjectDataTypeManager(this, this.dbh, openMode, (ErrorHandler)this, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        return versionExc;
    }

    private void initManagers(OpenMode openMode, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.checkCancelled();
        this.dataTypeManager.archiveReady(openMode, monitor);
    }

    protected void clearCache(boolean all) {
        this.lock.acquire();
        try {
            super.clearCache(all);
            this.dataTypeManager.invalidateCache();
        }
        finally {
            this.lock.release();
        }
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    protected void setChanged(boolean b) {
        super.setChanged(b);
    }

    void setChangeSet(DataTypeArchiveDBChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    public void save(String comment, TaskMonitor monitor) throws IOException, CancelledException {
        try {
            super.save(comment, monitor);
        }
        finally {
            this.dataTypeManager.clearUndo();
        }
    }

    public void saveToPackedFile(File outputFile, TaskMonitor monitor) throws IOException, CancelledException {
        try {
            super.saveToPackedFile(outputFile, monitor);
        }
        finally {
            this.dataTypeManager.clearUndo();
        }
    }

    public Map<String, String> getMetadata() {
        this.metadata.clear();
        this.metadata.put("Data Type Archive Name", this.getName());
        this.metadata.put("# of Data Types", "" + this.getDataTypeManager().getDataTypeCount(true));
        this.metadata.put("# of Data Type Categories", "" + this.getDataTypeManager().getCategoryCount());
        Options propList = this.getOptions("Program Information");
        List propNames = propList.getOptionNames();
        Collections.sort(propNames);
        for (String propName : propNames) {
            String valueAsString;
            if (propName.indexOf(46) >= 0 || (valueAsString = propList.getValueAsString(propName)) == null) continue;
            this.metadata.put(propName, propList.getValueAsString(propName));
        }
        return this.metadata;
    }

    protected void updateMetadata() throws IOException {
        this.getMetadata();
        super.updateMetadata();
    }

    @Override
    public void updateID() {
        this.dataTypeManager.updateID();
    }

    protected void domainObjectRestored() {
        super.domainObjectRestored();
        this.dataTypeManager.notifyRestored();
    }
}

