/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.code.CodeUnitDB;
import ghidra.program.database.code.InstDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.OperandType;
import ghidra.program.model.lang.ParserContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UnknownContextException;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionPcodeOverride;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.StackReference;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ProgramEvent;
import ghidra.util.Msg;
import ghidra.util.exception.NoValueException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class InstructionDB
extends CodeUnitDB
implements Instruction,
InstructionContext {
    private static final byte FALLTHROUGH_SET_MASK = 1;
    private static final byte FALLTHROUGH_CLEAR_MASK = -2;
    private static final byte FLOW_OVERRIDE_SET_MASK = 14;
    private static final byte FLOW_OVERRIDE_CLEAR_MASK = -15;
    private static final int FLOW_OVERRIDE_SHIFT = 1;
    private static final byte LENGTH_OVERRIDE_SET_MASK = 112;
    private static final byte LENGTH_OVERRIDE_CLEAR_MASK = -113;
    private static final int LENGTH_OVERRIDE_SHIFT = 4;
    private InstructionPrototype proto;
    private byte flags;
    private FlowOverride flowOverride;
    private int lengthOverride;
    private static final Address[] EMPTY_ADDR_ARRAY = new Address[0];
    private volatile boolean clearingFallThroughs = false;
    private ParserContext parserContext;

    public InstructionDB(CodeManager codeMgr, DBObjectCache<? extends CodeUnitDB> cache, Address address, long addr, InstructionPrototype proto, byte flags) {
        super(codeMgr, cache, addr, address, addr, proto.getLength());
        this.proto = proto;
        this.flags = flags;
        this.flowOverride = FlowOverride.getFlowOverride((flags & 0xE) >> 1);
        this.refreshLength();
    }

    @Override
    protected boolean refresh(DBRecord record) {
        this.parserContext = null;
        return super.refresh(record);
    }

    @Override
    protected int getPreferredCacheLength() {
        return this.proto.hasDelaySlots() ? this.length * 2 : this.length;
    }

    private void refreshLength() {
        this.length = this.proto.getLength();
        this.lengthOverride = (this.flags & 0x70) >> 4;
        if (this.lengthOverride != 0 && this.lengthOverride < this.length) {
            this.length = this.lengthOverride;
        } else {
            this.lengthOverride = 0;
        }
    }

    static int getLength(InstructionPrototype proto, byte flags) {
        int length = proto.getLength();
        int lengthOverride = (flags & 0x70) >> 4;
        if (lengthOverride != 0 && lengthOverride < length) {
            length = lengthOverride;
        } else {
            lengthOverride = 0;
        }
        return length;
    }

    @Override
    protected boolean hasBeenDeleted(DBRecord rec) {
        if (rec == null ? (rec = this.codeMgr.getInstructionRecord(this.addr)) == null : !rec.hasSameSchema(InstDBAdapter.INSTRUCTION_SCHEMA)) {
            return true;
        }
        int newProtoID = rec.getIntValue(0);
        InstructionPrototype newProto = this.codeMgr.getInstructionPrototype(newProtoID);
        if (newProto == null) {
            Msg.error((Object)this, (Object)("Instruction found but prototype missing at " + String.valueOf(this.address)));
            return true;
        }
        if (!newProto.equals(this.proto)) {
            return true;
        }
        this.flags = rec.getByteValue(1);
        this.flowOverride = FlowOverride.getFlowOverride((this.flags & 0xE) >> 1);
        this.refreshLength();
        return false;
    }

    @Override
    public int getDelaySlotDepth() {
        if (!this.proto.hasDelaySlots()) {
            return 0;
        }
        this.lock.acquire();
        try {
            int n = this.proto.getDelaySlotDepth(this);
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    public RegisterValue getOriginalPrototypeContext(Register baseContextReg) {
        try {
            return this.codeMgr.getOriginalPrototypeContext(this.proto, baseContextReg);
        }
        catch (NoValueException e) {
            Msg.error((Object)this, (Object)"Unexpected Error", (Throwable)e);
            return null;
        }
    }

    @Override
    public int getParsedLength() {
        return this.isLengthOverridden() ? this.proto.getLength() : this.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getParsedBytes() throws MemoryAccessException {
        if (!this.isLengthOverridden()) {
            return this.getBytes();
        }
        this.lock.acquire();
        try {
            this.checkIsValid();
            int len = this.proto.getLength();
            byte[] b = new byte[len];
            if (len != this.getMemory().getBytes(this.address, b)) {
                throw new MemoryAccessException("Failed to read " + len + " bytes at " + String.valueOf(this.address));
            }
            byte[] byArray = b;
            return byArray;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getFallFrom() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Instruction instr = this;
            int alignment = this.program.getLanguage().getInstructionAlignment();
            if (alignment < 1) {
                alignment = 1;
            }
            do {
                try {
                    instr = this.program.getListing().getInstructionContaining(instr.getMinAddress().subtractNoWrap(alignment));
                }
                catch (AddressOverflowException e) {
                    Address address = null;
                    this.lock.release();
                    return address;
                }
            } while (instr != null && instr.isInDelaySlot() && (!instr.hasFallthrough() || !this.program.getSymbolTable().hasSymbol(instr.getMinAddress())));
            if (instr == null) {
                Address e = null;
                return e;
            }
            if (this.isInDelaySlot()) {
                if (!instr.hasFallthrough() && this.program.getSymbolTable().hasSymbol(this.getMinAddress())) {
                    Address e = null;
                    return e;
                }
                Address e = instr.getMinAddress();
                return e;
            }
            Address fallAddr = instr.getFallThrough();
            if (fallAddr != null && fallAddr.equals(this.address)) {
                Address address = instr.getMinAddress();
                return address;
            }
            Address address = null;
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    private Address getFallThroughReference() {
        for (Reference ref : this.refMgr.getReferencesFrom(this.address)) {
            if (!ref.getReferenceType().isFallthrough() || !ref.getToAddress().isMemoryAddress()) continue;
            return ref.getToAddress();
        }
        return null;
    }

    @Override
    public Address getFallThrough() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.isFallThroughOverridden()) {
                Address address = this.getFallThroughReference();
                return address;
            }
            Address address = this.getDefaultFallThrough();
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Address[] getFlows() {
        this.refreshIfNeeded();
        Reference[] refs = this.refMgr.getFlowReferencesFrom(this.address);
        if (refs.length == 0) {
            return EMPTY_ADDR_ARRAY;
        }
        HashSet<Address> list = new HashSet<Address>();
        for (Reference ref : refs) {
            if (ref.getReferenceType().isIndirect()) continue;
            list.add(ref.getToAddress());
        }
        if (this.flowOverride == FlowOverride.RETURN && list.size() == 1) {
            return EMPTY_ADDR_ARRAY;
        }
        return list.toArray(new Address[list.size()]);
    }

    @Override
    public Address[] getDefaultFlows() {
        Address[] flows = this.proto.getFlows(this);
        if (this.flowOverride == FlowOverride.RETURN && flows.length == 1) {
            return EMPTY_ADDR_ARRAY;
        }
        return flows;
    }

    @Override
    public FlowType getFlowType() {
        return FlowOverride.getModifiedFlowType(this.proto.getFlowType(this), this.flowOverride);
    }

    @Override
    public Instruction getNext() {
        this.refreshIfNeeded();
        return this.codeMgr.getInstructionAfter(this.address);
    }

    @Override
    public RefType getOperandRefType(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            RefType refType = this.proto.getOperandRefType(opIndex, this, new InstructionPcodeOverride(this));
            return refType;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getSeparator(int opIndex) {
        this.lock.acquire();
        try {
            String string = this.proto.getSeparator(opIndex, this);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultOperandRepresentation(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            List<Object> opList = this.getDefaultOperandRepresentationList(opIndex);
            if (opList == null) {
                String string = "<UNSUPPORTED>";
                return string;
            }
            StringBuffer strBuf = new StringBuffer();
            for (Object opElem : opList) {
                if (opElem instanceof Address) {
                    Address opAddr = (Address)opElem;
                    strBuf.append("0x");
                    strBuf.append(opAddr.toString(false));
                    continue;
                }
                strBuf.append(opElem.toString());
            }
            String string = strBuf.toString();
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public List<Object> getDefaultOperandRepresentationList(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            ArrayList<Object> arrayList = this.proto.getOpRepresentationList(opIndex, this);
            return arrayList;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOperandType(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int optype = this.proto.getOpType(opIndex, this);
            Reference ref = this.getPrimaryReference(opIndex);
            if (ref instanceof StackReference) {
                int n = optype |= 0x2000;
                return n;
            }
            if (ref instanceof ExternalReference) {
                optype |= 0x2000;
            } else if (ref != null && ref.getToAddress().isMemoryAddress()) {
                optype |= 0x2000;
            }
            int n = optype;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Object[] getOpObjects(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (opIndex < 0 || opIndex >= this.getNumOperands()) {
                Object[] objectArray = new Object[]{};
                return objectArray;
            }
            Object[] objectArray = this.proto.getOpObjects(opIndex, this);
            return objectArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Instruction getPrevious() {
        this.refreshIfNeeded();
        return this.codeMgr.getInstructionBefore(this.address);
    }

    @Override
    public InstructionPrototype getPrototype() {
        return this.proto;
    }

    @Override
    public Register getRegister(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (opIndex < 0) {
                Register register = null;
                return register;
            }
            Register register = this.proto.getRegister(opIndex, this);
            return register;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Object[] getInputObjects() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Object[] objectArray = this.proto.getInputObjects(this);
            return objectArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Object[] getResultObjects() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Object[] objectArray = this.proto.getResultObjects(this);
            return objectArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isInDelaySlot() {
        return this.proto.isInDelaySlot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getAddress(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Reference ref = this.refMgr.getPrimaryReferenceFrom(this.address, opIndex);
            if (ref != null) {
                Address address = ref.getToAddress();
                return address;
            }
            if (opIndex < 0) {
                Address address = null;
                return address;
            }
            int opType = this.proto.getOpType(opIndex, this);
            if (OperandType.isAddress(opType)) {
                Address address = this.proto.getAddress(opIndex, this);
                return address;
            }
            Address address = null;
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getMnemonicString());
            int n = this.getNumOperands();
            String sep = this.getSeparator(0);
            if (sep != null || n != 0) {
                stringBuffer.append(' ');
            }
            if (sep != null) {
                stringBuffer.append(sep);
            }
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.getDefaultOperandRepresentation(i));
                sep = this.getSeparator(i + 1);
                if (sep == null) continue;
                stringBuffer.append(sep);
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getMnemonicString() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.proto.getMnemonic(this);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumOperands() {
        return this.proto.getNumOperands();
    }

    @Override
    public Scalar getScalar(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (opIndex < 0) {
                Scalar scalar = null;
                return scalar;
            }
            Scalar scalar = this.proto.getScalar(opIndex, this);
            return scalar;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        InstructionDB inst = (InstructionDB)obj;
        return this.proto.equals(inst.proto);
    }

    @Override
    public FlowOverride getFlowOverride() {
        return this.flowOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFlowOverride(FlowOverride flow) {
        if (flow == null) {
            flow = FlowOverride.NONE;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (flow == this.flowOverride) {
                return;
            }
            FlowType origFlowType = this.getFlowType();
            this.flags = (byte)(this.flags & 0xFFFFFFF1);
            this.flags = (byte)(this.flags | flow.ordinal() << 1);
            this.codeMgr.setFlags(this.addr, this.flags);
            this.flowOverride = flow;
            for (Reference ref : this.refMgr.getFlowReferencesFrom(this.getAddress())) {
                RefType refType;
                if (!ref.getReferenceType().isFlow() || !this.isSameFlowType(origFlowType, ref.getReferenceType()) || !(refType = RefTypeFactory.getDefaultMemoryRefType(this, ref.getOperandIndex(), ref.getToAddress(), true)).isFlow() || ref.getReferenceType() == refType) continue;
                this.refMgr.delete(ref);
                Reference newRef = this.refMgr.addMemoryReference(ref.getFromAddress(), ref.getToAddress(), refType, ref.getSource(), ref.getOperandIndex());
                if (!ref.isPrimary()) continue;
                this.refMgr.setPrimary(newRef, true);
            }
        }
        finally {
            this.lock.release();
        }
        this.program.setChanged(ProgramEvent.FLOW_OVERRIDE_CHANGED, this.address, this.address, null, null);
    }

    private boolean isSameFlowType(FlowType origFlowType, RefType referenceType) {
        if (origFlowType.isCall() && referenceType.isCall()) {
            return true;
        }
        if (origFlowType.isJump() && referenceType.isJump()) {
            return true;
        }
        return origFlowType.isTerminal() && referenceType.isTerminal();
    }

    @Override
    public PcodeOp[] getPcode() {
        return this.getPcode(false);
    }

    @Override
    public PcodeOp[] getPcode(boolean includeOverrides) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (!includeOverrides) {
                PcodeOp[] pcodeOpArray = this.proto.getPcode((InstructionContext)this, null);
                return pcodeOpArray;
            }
            PcodeOp[] pcodeOpArray = this.proto.getPcode((InstructionContext)this, new InstructionPcodeOverride(this));
            return pcodeOpArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public PcodeOp[] getPcode(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            PcodeOp[] pcodeOpArray = this.proto.getPcode((InstructionContext)this, opIndex);
            return pcodeOpArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isFallThroughOverridden() {
        return (this.flags & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFallThroughRefs(Address keepFallThroughAddr) {
        if (this.clearingFallThroughs) {
            return;
        }
        this.refreshIfNeeded();
        this.clearingFallThroughs = true;
        try {
            boolean fallThroughPreserved = false;
            for (Reference ref : this.refMgr.getReferencesFrom(this.address)) {
                if (ref.getReferenceType() != RefType.FALL_THROUGH) continue;
                if (!fallThroughPreserved && ref.getToAddress().equals(keepFallThroughAddr)) {
                    fallThroughPreserved = true;
                    continue;
                }
                this.refMgr.delete(ref);
            }
        }
        finally {
            this.clearingFallThroughs = false;
        }
    }

    void fallThroughChanged(Reference fallThroughRef) {
        if (!this.clearingFallThroughs) {
            Address fallThroughAddr = fallThroughRef != null ? fallThroughRef.getToAddress() : null;
            this.clearFallThroughRefs(fallThroughAddr);
            if (fallThroughAddr == null) {
                this.setFallthroughOverride(false);
                this.addLengthOverrideFallthroughRef();
            } else {
                this.setFallthroughOverride(!fallThroughAddr.equals(this.getLengthOverrideFallThrough()));
            }
        }
    }

    private void setFallthroughOverride(boolean state) {
        if (state != this.isFallThroughOverridden()) {
            this.flags = state ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
            this.codeMgr.setFlags(this.addr, this.flags);
            this.program.setChanged(ProgramEvent.FALLTHROUGH_CHANGED, this.address, this.address, null, null);
        }
    }

    @Override
    public void clearFallThroughOverride() {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (!this.isFallThroughOverridden()) {
                return;
            }
            this.clearFallThroughRefs(null);
            this.setFallthroughOverride(false);
            this.addLengthOverrideFallthroughRef();
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setFallThrough(Address fallThroughAddr) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            Address defaultFallThrough = this.proto.getFallThrough(this);
            if (this.addrsEqual(fallThroughAddr, defaultFallThrough)) {
                this.clearFallThroughOverride();
                return;
            }
            if (fallThroughAddr == null) {
                this.clearFallThroughRefs(null);
                this.setFallthroughOverride(true);
            } else {
                this.refMgr.addMemoryReference(this.address, fallThroughAddr, RefType.FALL_THROUGH, SourceType.USER_DEFINED, -1);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setLengthOverride(int len) throws CodeUnitInsertionException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.doSetLengthOverride(len)) {
                this.program.setChanged(ProgramEvent.LENGTH_OVERRIDE_CHANGED, this.address, this.address, null, null);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public static int checkLengthOverride(int length, InstructionPrototype prototype) throws IllegalArgumentException, CodeUnitInsertionException {
        if (length < 0) {
            throw new IllegalArgumentException("Negative length not permitted");
        }
        int instrProtoLength = prototype.getLength();
        if (length == 0 || length == instrProtoLength) {
            return 0;
        }
        if (length > instrProtoLength) {
            return 0;
        }
        int align = prototype.getLanguage().getInstructionAlignment();
        if (length % align != 0) {
            throw new CodeUnitInsertionException("Length(" + length + ") override must be a multiple of " + align + " bytes");
        }
        if (length > 7) {
            throw new CodeUnitInsertionException("Unsupported length override: " + length);
        }
        return length;
    }

    boolean doSetLengthOverride(int len) throws CodeUnitInsertionException {
        int instrLength;
        int protoLength = this.proto.getLength();
        if ((len = InstructionDB.checkLengthOverride(len, this.proto)) == this.lengthOverride) {
            return false;
        }
        int n = instrLength = len != 0 ? len : protoLength;
        if (instrLength > this.getLength()) {
            Address newEndAddr = this.address.add(instrLength - 1);
            Address nextCodeUnitAddr = this.codeMgr.getDefinedAddressAfter(this.address);
            if (nextCodeUnitAddr != null && nextCodeUnitAddr.compareTo(newEndAddr) <= 0) {
                throw new CodeUnitInsertionException("Length override of " + instrLength + " conflicts with code unit at " + String.valueOf(nextCodeUnitAddr));
            }
        }
        this.flags = (byte)(this.flags & 0xFFFFFF8F);
        this.flags = (byte)(this.flags | len << 4);
        this.codeMgr.setFlags(this.addr, this.flags);
        this.endAddr = null;
        this.refreshLength();
        this.addLengthOverrideFallthroughRef();
        return true;
    }

    private void addLengthOverrideFallthroughRef() {
        Address defaultFallThrough;
        if (this.isLengthOverridden() && !this.isFallThroughOverridden() && (defaultFallThrough = this.getDefaultFallThrough()) != null) {
            this.refMgr.addMemoryReference(this.address, defaultFallThrough, RefType.FALL_THROUGH, SourceType.USER_DEFINED, -1);
        }
    }

    @Override
    public boolean isLengthOverridden() {
        this.refreshIfNeeded();
        return this.lengthOverride != 0;
    }

    private Address getLengthOverrideFallThrough() {
        return this.isLengthOverridden() ? this.getDefaultFallThrough() : null;
    }

    private boolean addrsEqual(Address addr1, Address addr2) {
        if (addr1 == null) {
            return addr2 == null;
        }
        return addr1.equals(addr2);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Address getDefaultFallThrough() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getDefaultFallThroughOffset() {
        this.lock.acquire();
        try {
            int n = this.proto.getFallThroughOffset(this);
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean hasFallthrough() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.isFallThroughOverridden()) {
                boolean bl = this.getFallThrough() != null;
                return bl;
            }
            boolean bl = this.getFlowType().hasFallthrough();
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isFallthrough() {
        if (!this.getFlowType().isFallthrough()) {
            return false;
        }
        return this.hasFallthrough();
    }

    @Override
    public ProcessorContextView getProcessorContext() {
        return this;
    }

    @Override
    public MemBuffer getMemBuffer() {
        return this;
    }

    @Override
    public ParserContext getParserContext() throws MemoryAccessException {
        if (this.parserContext == null) {
            this.parserContext = this.proto.getParserContext(this, this);
        }
        return this.parserContext;
    }

    @Override
    public InstructionContext getInstructionContext() {
        return this;
    }

    @Override
    public ParserContext getParserContext(Address instructionAddress) throws UnknownContextException, MemoryAccessException {
        if (this.address.equals(instructionAddress)) {
            return this.getParserContext();
        }
        InstructionDB instr = (InstructionDB)this.codeMgr.getInstructionAt(instructionAddress);
        if (instr == null) {
            throw new UnknownContextException("Program does not contain referenced instruction: " + String.valueOf(instructionAddress));
        }
        InstructionPrototype otherProto = instr.getPrototype();
        if (!otherProto.getClass().equals(this.proto.getClass())) {
            throw new UnknownContextException("Instruction has incompatible prototype at: " + String.valueOf(instructionAddress));
        }
        return instr.getParserContext();
    }
}

