/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBRecord;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.BitFieldDBDataType;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeComponentDB;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.AlignmentType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CompositeInternal;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PackingType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.util.Objects;

abstract class CompositeDB
extends DataTypeDB
implements CompositeInternal {
    protected CompositeDBAdapter compositeAdapter;
    protected ComponentDBAdapter componentAdapter;

    CompositeDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, CompositeDBAdapter compositeAdapter, ComponentDBAdapter componentAdapter, DBRecord record) {
        super(dataMgr, cache, record);
        this.compositeAdapter = compositeAdapter;
        this.componentAdapter = componentAdapter;
        this.initialize();
    }

    protected abstract void initialize();

    @Override
    public final int getAlignedLength() {
        return this.getLength();
    }

    protected int getPreferredComponentLength(DataType dataType, int length, int maxLength) {
        if (DataTypeComponent.usesZeroLengthComponent(dataType)) {
            return 0;
        }
        if (!(dataType instanceof Dynamic) && (this.isPackingEnabled() ? (length = dataType.getAlignedLength()) > 0 : (this instanceof Union ? (length = dataType.getLength()) > 0 : maxLength >= 0 && (length = Math.min(dataType.getLength(), maxLength)) > 0))) {
            return length;
        }
        return DataTypeComponentImpl.getPreferredComponentLength(dataType, length);
    }

    protected int getPreferredComponentLength(DataType dataType, int length) {
        return this.getPreferredComponentLength(dataType, length, -1);
    }

    @Override
    protected String doGetName() {
        return this.record.getString(0);
    }

    @Override
    protected long doGetCategoryID() {
        return this.record.getLongValue(3);
    }

    @Override
    protected Settings doGetDefaultSettings() {
        return SettingsImpl.NO_SETTINGS;
    }

    protected boolean updateBitFieldDataType(DataTypeComponentDB bitfieldComponent, DataType oldDt, DataType newDt) throws InvalidDataTypeException {
        if (!bitfieldComponent.isBitFieldComponent()) {
            throw new AssertException("expected bitfield component");
        }
        BitFieldDBDataType bitfieldDt = (BitFieldDBDataType)bitfieldComponent.getDataType();
        if (bitfieldDt.getBaseDataType() != oldDt) {
            return false;
        }
        if (newDt != null) {
            BitFieldDataType.checkBaseDataType(newDt);
            int maxBitSize = 8 * newDt.getLength();
            if (bitfieldDt.getBitSize() > maxBitSize) {
                throw new InvalidDataTypeException("Replacement datatype too small for bitfield");
            }
        }
        try {
            BitFieldDBDataType newBitfieldDt = new BitFieldDBDataType(newDt, bitfieldDt.getDeclaredBitSize(), bitfieldDt.getBitOffset());
            bitfieldComponent.setDataType(newBitfieldDt);
            oldDt.removeParent(this);
            newDt.addParent(this);
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException("unexpected");
        }
        return true;
    }

    @Override
    protected boolean refresh() {
        try {
            DBRecord rec = this.compositeAdapter.getRecord(this.key);
            if (rec != null) {
                this.record = rec;
                this.initialize();
                return super.refresh();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        return false;
    }

    @Override
    public void setDescription(String desc) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (Objects.equals(desc, this.record.getString(1))) {
                return;
            }
            this.record.setString(1, desc);
            this.compositeAdapter.updateRecord(this.record, true);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getDescription() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String s = this.record.getString(1);
            String string = s == null ? "" : s;
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public abstract boolean hasLanguageDependantLength();

    @Override
    public final boolean isNotYetDefined() {
        return this.getNumComponents() == 0 && !this.isPackingEnabled();
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public final DataTypeComponent add(DataType dataType) {
        return this.add(dataType, -1, null, null);
    }

    @Override
    public final DataTypeComponent add(DataType dataType, int length) {
        return this.add(dataType, length, null, null);
    }

    @Override
    public final DataTypeComponent add(DataType dataType, String fieldName, String comment) {
        return this.add(dataType, -1, fieldName, comment);
    }

    @Override
    public final DataTypeComponent insert(int ordinal, DataType dataType, int length) {
        return this.insert(ordinal, dataType, length, null, null);
    }

    @Override
    public final DataTypeComponent insert(int ordinal, DataType dataType) {
        return this.insert(ordinal, dataType, -1, null, null);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.getDisplayName();
    }

    @Override
    protected void doSetCategoryPathRecord(long categoryID) throws IOException {
        this.record.setLongValue(3, categoryID);
        this.compositeAdapter.updateRecord(this.record, false);
    }

    @Override
    public boolean isPartOf(DataType dataTypeOfInterest) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = DataTypeUtilities.isSecondPartOfFirst(this, dataTypeOfInterest);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    protected void checkAncestry(DataType dataType) throws DataTypeDependencyException {
        if (this.equals(dataType)) {
            throw new DataTypeDependencyException("Data type " + this.getDisplayName() + " can't contain itself.");
        }
        if (DataTypeUtilities.isSecondPartOfFirst(dataType, this)) {
            throw new DataTypeDependencyException("Data type " + dataType.getDisplayName() + " has " + this.getDisplayName() + " within it.");
        }
    }

    protected DataType doCheckedResolve(DataType dt) throws DataTypeDependencyException {
        if (dt instanceof Pointer) {
            this.pointerPostResolveRequired = true;
            return this.resolve(((Pointer)dt).newPointer(DataType.DEFAULT));
        }
        dt = this.resolve(dt);
        this.checkAncestry(dt);
        return dt;
    }

    @Override
    protected void doSetNameRecord(String name) throws IOException {
        this.record.setString(0, name);
        this.compositeAdapter.updateRecord(this.record, true);
    }

    protected void removeComponentRecord(long compKey) throws IOException {
        this.componentAdapter.removeRecord(compKey);
        this.dataMgr.getSettingsAdapter().removeAllSettingsRecords(compKey);
    }

    protected DataType validateDataType(DataType dataType) {
        Dynamic dynamicDataType;
        if (dataType == DataType.DEFAULT) {
            if (this.isPackingEnabled() || this instanceof Union) {
                return Undefined1DataType.dataType;
            }
            return dataType;
        }
        if (dataType instanceof Dynamic ? !(dynamicDataType = (Dynamic)dataType).canSpecifyLength() : dataType instanceof FactoryDataType || dataType.getLength() <= 0) {
            throw new IllegalArgumentException("The \"" + dataType.getName() + "\" data type is not allowed in a composite data type.");
        }
        return dataType;
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return this.record.getLongValue(9);
    }

    @Override
    public long getLastChangeTime() {
        return this.record.getLongValue(10);
    }

    void doSetLastChangeTime(long lastChangeTime) throws IOException {
        this.record.setLongValue(10, lastChangeTime);
        this.compositeAdapter.updateRecord(this.record, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTime(long lastChangeTime) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.doSetLastChangeTime(lastChangeTime);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTime) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(9, lastChangeTime);
            this.compositeAdapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public UniversalID getUniversalID() {
        return new UniversalID(this.record.getLongValue(8));
    }

    @Override
    void setUniversalID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(8, id.getValue());
            this.compositeAdapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected UniversalID getSourceArchiveID() {
        return new UniversalID(this.record.getLongValue(7));
    }

    @Override
    protected void setSourceArchiveID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(7, id.getValue());
            this.compositeAdapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    protected final int getNonPackedAlignment() {
        int minimumAlignment = this.getStoredMinimumAlignment();
        int alignment = minimumAlignment == 0 ? 1 : (minimumAlignment == -1 ? this.getDataOrganization().getMachineAlignment() : minimumAlignment);
        return alignment;
    }

    protected abstract int getComputedAlignment(boolean var1);

    @Override
    public final int getAlignment() {
        this.lock.acquire();
        try {
            int n = this.getComputedAlignment(this.checkIsValid() && this.dataMgr.isTransactionActive());
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public final void repack() {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.repack(false, true);
        }
        finally {
            this.lock.release();
        }
    }

    protected abstract boolean repack(boolean var1, boolean var2);

    @Override
    public int getStoredPackingValue() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.record.getIntValue(11);
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public PackingType getPackingType() {
        int packing = this.getStoredPackingValue();
        if (packing < 0) {
            return PackingType.DISABLED;
        }
        if (packing == 0) {
            return PackingType.DEFAULT;
        }
        return PackingType.EXPLICIT;
    }

    @Override
    public int getExplicitPackingValue() {
        return this.getStoredPackingValue();
    }

    @Override
    public void setExplicitPackingValue(int packingValue) {
        if (packingValue <= 0) {
            throw new IllegalArgumentException("explicit packing value must be positive: " + packingValue);
        }
        this.setStoredPackingValue(packingValue);
    }

    @Override
    public void setToDefaultPacking() {
        this.setStoredPackingValue(0);
    }

    private void setStoredPackingValue(int packingValue) {
        if (packingValue < -1) {
            throw new IllegalArgumentException("invalid packing value: " + packingValue);
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            int oldPackingValue = this.getStoredPackingValue();
            if (packingValue == oldPackingValue) {
                return;
            }
            if (oldPackingValue == -1 || packingValue == -1) {
                this.record.setIntValue(12, 0);
            }
            this.record.setIntValue(11, packingValue);
            this.compositeAdapter.updateRecord(this.record, true);
            if (!this.repack(false, true)) {
                this.dataMgr.dataTypeChanged(this, false);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AlignmentType getAlignmentType() {
        int minimumAlignment = this.getStoredMinimumAlignment();
        if (minimumAlignment < 0) {
            return AlignmentType.MACHINE;
        }
        if (minimumAlignment == 0) {
            return AlignmentType.DEFAULT;
        }
        return AlignmentType.EXPLICIT;
    }

    @Override
    public void setToDefaultAligned() {
        this.setStoredMinimumAlignment(0);
    }

    @Override
    public void setToMachineAligned() {
        this.setStoredMinimumAlignment(-1);
    }

    @Override
    public int getExplicitMinimumAlignment() {
        return this.getStoredMinimumAlignment();
    }

    @Override
    public int getStoredMinimumAlignment() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.record.getIntValue(12);
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setExplicitMinimumAlignment(int minimumAlignment) {
        if (minimumAlignment <= 0) {
            throw new IllegalArgumentException("explicit minimum alignment must be positive: " + minimumAlignment);
        }
        this.setStoredMinimumAlignment(minimumAlignment);
    }

    private void setStoredMinimumAlignment(int minimumAlignment) {
        if (minimumAlignment < -1) {
            throw new IllegalArgumentException("invalid minimum alignment value: " + minimumAlignment);
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (minimumAlignment == this.getStoredMinimumAlignment()) {
                return;
            }
            this.record.setIntValue(12, minimumAlignment);
            this.compositeAdapter.updateRecord(this.record, true);
            if (!this.repack(false, true)) {
                this.dataMgr.dataTypeChanged(this, false);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    public abstract DataTypeComponentDB[] getDefinedComponents();

    @Override
    protected void postPointerResolve(DataType definitionDt, DataTypeConflictHandler handler) {
        DataTypeComponentDB[] myDefinedComponents;
        Composite composite = (Composite)definitionDt;
        DataTypeComponent[] definedComponents = composite.getDefinedComponents();
        if (definedComponents.length != (myDefinedComponents = this.getDefinedComponents()).length) {
            throw new IllegalArgumentException("mismatched definition datatype");
        }
        for (int i = 0; i < definedComponents.length; ++i) {
            DataTypeComponent dtc = definedComponents[i];
            DataType dt = dtc.getDataType();
            if (!(dt instanceof Pointer)) continue;
            DataTypeComponentDB myDtc = myDefinedComponents[i];
            myDtc.getDataType().removeParent(this);
            dt = this.dataMgr.resolve(dt, handler);
            myDtc.setDataType(dt);
            dt.addParent(this);
        }
    }

    @Override
    public void setPackingEnabled(boolean enabled) {
        if (enabled == this.isPackingEnabled()) {
            return;
        }
        this.setStoredPackingValue(enabled ? 0 : -1);
    }

    protected void doSetPackingAndAlignment(CompositeInternal composite) throws IOException {
        this.record.setIntValue(12, composite.getStoredMinimumAlignment());
        this.record.setIntValue(11, composite.getStoredPackingValue());
    }

    @Override
    public String toString() {
        return CompositeInternal.toString(this);
    }

    protected abstract void fixupComponents() throws IOException;
}

