/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.module.ModuleManager;
import ghidra.program.database.module.ProgramTreeDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramEvent;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TreeManager
implements ManagerDB {
    public static final String DEFAULT_TREE_NAME = "Program Tree";
    private AddressMap addrMap;
    private Map<String, ModuleManager> treeMap;
    private ProgramTreeDBAdapter treeAdapter;
    private ProgramDB program;
    private DBHandle handle;
    private ErrorHandler errHandler;
    private Lock lock;

    public TreeManager(DBHandle handle, ErrorHandler errHandler, AddressMap addrMap, OpenMode openMode, Lock lock, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        this.handle = handle;
        this.errHandler = errHandler;
        this.addrMap = addrMap;
        this.lock = lock;
        this.treeAdapter = ProgramTreeDBAdapter.getAdapter(handle, openMode);
        this.initTreeMap(openMode, monitor);
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
        if (this.treeMap.isEmpty()) {
            this.createDefaultTree();
        }
    }

    @Override
    public void programReady(OpenMode openMode1, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageBaseChanged(boolean commit) {
        this.lock.acquire();
        try {
            for (ModuleManager m : this.treeMap.values()) {
                m.imageBaseChanged(commit);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public ProgramModule createRootModule(String treeName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            if (this.treeMap.containsKey(treeName)) {
                throw new DuplicateNameException("Root module named " + treeName + " already exists");
            }
            DBRecord record = this.treeAdapter.createRecord(treeName);
            ModuleManager m = new ModuleManager(this, record, OpenMode.CREATE, TaskMonitor.DUMMY);
            this.treeMap.put(treeName, m);
            this.addMemoryBlocks(m);
            if (this.program != null) {
                this.program.programTreeAdded(record.getKey(), ProgramEvent.PROGRAM_TREE_CREATED, null, treeName);
            }
            ProgramModule programModule = m.getRootModule();
            return programModule;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        catch (CancelledException | VersionException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramModule getRootModule(String treeName) {
        this.lock.acquire();
        try {
            ModuleManager m = this.treeMap.get(treeName);
            if (m != null) {
                ProgramModule programModule = m.getRootModule();
                return programModule;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    public ProgramModule getDefaultRootModule() {
        try {
            RecordIterator iter = this.treeAdapter.getRecords();
            if (iter.hasNext()) {
                DBRecord record = iter.next();
                String name = record.getString(0);
                return this.getRootModule(name);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return null;
    }

    public String[] getTreeNames() {
        String[] names = new String[this.treeMap.size()];
        try {
            RecordIterator iter = this.treeAdapter.getRecords();
            int index = 0;
            while (iter.hasNext()) {
                DBRecord record = iter.next();
                names[index] = record.getString(0);
                ++index;
            }
            return names;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTree(String oldName, String newName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            if (this.treeMap.containsKey(newName)) {
                throw new DuplicateNameException("Name " + newName + " already exists");
            }
            ModuleManager moduleMgr = this.treeMap.get(oldName);
            if (moduleMgr == null) {
                throw new IllegalArgumentException("Tree named " + oldName + " was not found");
            }
            moduleMgr.setName(newName);
            this.treeMap.remove(oldName);
            this.treeMap.put(newName, moduleMgr);
            this.program.programTreeChanged(moduleMgr.getTreeID(), ProgramEvent.PROGRAM_TREE_RENAMED, null, oldName, newName);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTree(String treeName) {
        this.lock.acquire();
        try {
            if (this.treeMap.containsKey(treeName)) {
                DBRecord rec = this.treeAdapter.getRecord(treeName);
                this.treeAdapter.deleteRecord(rec.getKey());
                ModuleManager mm = this.treeMap.remove(treeName);
                mm.dispose();
                this.program.programTreeChanged(rec.getKey(), ProgramEvent.PROGRAM_TREE_REMOVED, null, treeName, null);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramModule getModule(String treeName, String name) {
        this.lock.acquire();
        try {
            ModuleManager m = this.treeMap.get(treeName);
            if (m != null) {
                ProgramModule programModule = m.getModule(name);
                return programModule;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramFragment getFragment(String treeName, String name) {
        this.lock.acquire();
        try {
            ModuleManager m = this.treeMap.get(treeName);
            if (m != null) {
                ProgramFragment programFragment = m.getFragment(name);
                return programFragment;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramFragment getFragment(String treeName, Address addr) {
        this.lock.acquire();
        try {
            ModuleManager m = this.treeMap.get(treeName);
            if (m != null) {
                ProgramFragment programFragment = m.getFragment(addr);
                return programFragment;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemoryBlock(String name, AddressRange range) {
        this.lock.acquire();
        try {
            Iterator<String> keys = this.treeMap.keySet().iterator();
            while (keys.hasNext()) {
                ModuleManager m = this.treeMap.get(keys.next());
                m.addMemoryBlock(name, range);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        AddressRange.checkValidRange(startAddr, endAddr);
        this.lock.acquire();
        try {
            Iterator<String> keys = this.treeMap.keySet().iterator();
            while (keys.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                ModuleManager m = this.treeMap.get(keys.next());
                m.removeMemoryBlock(startAddr, endAddr, monitor);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws AddressOverflowException, CancelledException {
        this.lock.acquire();
        try {
            Iterator<String> keys = this.treeMap.keySet().iterator();
            monitor.setMessage("Moving folders/fragments...");
            while (keys.hasNext()) {
                monitor.checkCancelled();
                ModuleManager m = this.treeMap.get(keys.next());
                m.moveAddressRange(fromAddr, toAddr, length, monitor);
                m.invalidateCache();
            }
            this.treeMap.clear();
            this.refreshTreeMap(false);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    AddressMap getAddressMap() {
        return this.addrMap;
    }

    DBHandle getDatabaseHandle() {
        return this.handle;
    }

    String getTreeName(long treeID) {
        try {
            DBRecord record = this.treeAdapter.getRecord(treeID);
            if (record != null) {
                return record.getString(0);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return null;
    }

    ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    private void addMemoryBlocks(ModuleManager mgr) {
        MemoryBlock[] blocks;
        MemoryMapDB memory = this.program.getMemory();
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            AddressRangeImpl range = new AddressRangeImpl(block.getStart(), block.getEnd());
            try {
                mgr.addMemoryBlock(block.getName(), range);
            }
            catch (IOException e) {
                this.errHandler.dbError(e);
                break;
            }
        }
    }

    private void initTreeMap(OpenMode openMode, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        this.treeMap = new HashMap<String, ModuleManager>();
        RecordIterator iter = this.treeAdapter.getRecords();
        while (iter.hasNext()) {
            DBRecord rec = iter.next();
            String treeName = rec.getString(0);
            ModuleManager mm = new ModuleManager(this, rec, openMode, monitor);
            this.treeMap.put(treeName, mm);
        }
    }

    private void refreshTreeMap(boolean ignoreModificationNumber) throws IOException {
        Map<String, ModuleManager> oldTreeMap = this.treeMap;
        this.treeMap = new HashMap<String, ModuleManager>();
        RecordIterator iter = this.treeAdapter.getRecords();
        while (iter.hasNext()) {
            DBRecord rec = iter.next();
            long key = rec.getKey();
            String treeName = rec.getString(0);
            long modNumber = rec.getLongValue(1);
            ModuleManager mm = oldTreeMap.get(treeName);
            if (mm != null) {
                oldTreeMap.remove(treeName);
                if (mm.getTreeID() == key) {
                    if (ignoreModificationNumber || mm.getModificationNumber() != modNumber) {
                        mm.invalidateCache();
                    }
                } else {
                    mm.invalidateCache();
                    mm = null;
                }
            }
            if (mm == null) {
                try {
                    mm = new ModuleManager(this, rec, OpenMode.UPDATE, TaskMonitor.DUMMY);
                }
                catch (CancelledException | VersionException e) {
                    throw new RuntimeException(e);
                }
            }
            this.treeMap.put(treeName, mm);
        }
        Iterator<String> it = oldTreeMap.keySet().iterator();
        while (it.hasNext()) {
            ModuleManager mm = oldTreeMap.get(it.next());
            mm.invalidateCache();
        }
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
        this.lock.acquire();
        try {
            this.refreshTreeMap(all);
        }
        finally {
            this.lock.release();
        }
    }

    public void setProgramName(String oldName, String newName) {
        Iterator<String> it = this.treeMap.keySet().iterator();
        while (it.hasNext()) {
            ModuleManager mm = this.treeMap.get(it.next());
            mm.setProgramName(oldName, newName);
        }
    }

    void updateTreeRecord(DBRecord record) {
        this.updateTreeRecord(record, true);
    }

    void updateTreeRecord(DBRecord record, boolean updateModificationNumber) {
        try {
            if (updateModificationNumber) {
                record.setLongValue(1, record.getLongValue(1) + 1L);
            }
            this.treeAdapter.updateRecord(record);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
    }

    DBRecord getTreeRecord(long treeID) {
        try {
            return this.treeAdapter.getRecord(treeID);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return null;
        }
    }

    private void createDefaultTree() {
        try {
            this.createRootModule(DEFAULT_TREE_NAME);
        }
        catch (DuplicateNameException e) {
            throw new RuntimeException(e);
        }
    }

    public ProgramModule getRootModule(long treeID) {
        String treeName = this.getTreeName(treeID);
        return this.getRootModule(treeName);
    }

    Lock getLock() {
        return this.lock;
    }

    ProgramDB getProgram() {
        return this.program;
    }
}

