/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.properties;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.properties.PropertyMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.util.LongPropertyMap;
import ghidra.program.util.ChangeManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NoValueException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class LongPropertyMapDB
extends PropertyMapDB<Long>
implements LongPropertyMap {
    public LongPropertyMapDB(DBHandle dbHandle, OpenMode openMode, ErrorHandler errHandler, ChangeManager changeMgr, AddressMap addrMap, String name, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        super(dbHandle, errHandler, changeMgr, addrMap, name);
        this.checkMapVersion(openMode, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Address addr, long value) {
        Long oldValue = null;
        this.lock.acquire();
        try {
            DBRecord rec;
            long key = this.addrMap.getKey(addr, true);
            if (this.propertyTable == null) {
                this.createTable((Field)LongField.INSTANCE);
            } else {
                oldValue = (Long)this.cache.get(key);
                if (oldValue == null && (rec = this.propertyTable.getRecord(key)) != null) {
                    oldValue = rec.getLongValue(0);
                }
            }
            rec = this.schema.createRecord(key);
            rec.setLongValue(0, value);
            this.propertyTable.putRecord(rec);
            this.cache.put(key, (Object)value);
            this.changeMgr.setPropertyChanged(this.name, addr, oldValue, value);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(Address addr) throws NoValueException {
        if (this.propertyTable == null) {
            throw NO_VALUE_EXCEPTION;
        }
        this.lock.acquire();
        try {
            long key = this.addrMap.getKey(addr, false);
            if (key == -1L) {
                long l = 0L;
                return l;
            }
            Object obj = this.cache.get(key);
            if (obj != null) {
                long l = (Long)obj;
                return l;
            }
            DBRecord rec = this.propertyTable.getRecord(key);
            if (rec == null) {
                throw NO_VALUE_EXCEPTION;
            }
            long l = rec.getLongValue(0);
            return l;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return 0L;
    }

    @Override
    public Long get(Address addr) {
        try {
            return this.getLong(addr);
        }
        catch (NoValueException e) {
            return null;
        }
    }
}

