/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.properties;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.StringField;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.properties.PropertyMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.util.ChangeManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class StringPropertyMapDB
extends PropertyMapDB<String>
implements StringPropertyMap {
    public StringPropertyMapDB(DBHandle dbHandle, OpenMode openMode, ErrorHandler errHandler, ChangeManager changeMgr, AddressMap addrMap, String name, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        super(dbHandle, errHandler, changeMgr, addrMap, name);
        this.checkMapVersion(openMode, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Address addr, String value) {
        this.lock.acquire();
        try {
            DBRecord rec;
            long key = this.addrMap.getKey(addr, true);
            String oldValue = null;
            if (this.propertyTable == null) {
                this.createTable((Field)StringField.INSTANCE);
            } else {
                oldValue = (String)this.cache.get(key);
                if (oldValue == null && (rec = this.propertyTable.getRecord(key)) != null) {
                    oldValue = rec.getString(0);
                }
            }
            rec = this.schema.createRecord(key);
            rec.setString(0, value);
            this.propertyTable.putRecord(rec);
            this.cache.put(key, (Object)value);
            this.changeMgr.setPropertyChanged(this.name, addr, oldValue, value);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(Address addr) {
        if (this.propertyTable == null) {
            return null;
        }
        String str = null;
        this.lock.acquire();
        try {
            long key = this.addrMap.getKey(addr, false);
            if (key == -1L) {
                String string = null;
                return string;
            }
            str = (String)this.cache.get(key);
            if (str != null) {
                String string = str;
                return string;
            }
            DBRecord rec = this.propertyTable.getRecord(key);
            if (rec == null) {
                String string = null;
                return string;
            }
            str = rec.getString(0);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return str;
    }

    @Override
    public String get(Address addr) {
        return this.getString(addr);
    }
}

