/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.properties;

import db.DBHandle;
import db.DBRecord;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.properties.PropertyMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.util.VoidPropertyMap;
import ghidra.program.util.ChangeManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class VoidPropertyMapDB
extends PropertyMapDB<Boolean>
implements VoidPropertyMap {
    private static Object VOID_OBJECT = new Object();

    public VoidPropertyMapDB(DBHandle dbHandle, OpenMode openMode, ErrorHandler errHandler, ChangeManager changeMgr, AddressMap addrMap, String name, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        super(dbHandle, errHandler, changeMgr, addrMap, name);
        this.checkMapVersion(openMode, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Address addr) {
        this.lock.acquire();
        try {
            long key = this.addrMap.getKey(addr, true);
            Boolean oldValue = this.hasProperty(addr);
            if (this.propertyTable == null) {
                this.createTable(null);
            }
            DBRecord rec = this.schema.createRecord(key);
            this.propertyTable.putRecord(rec);
            this.cache.put(key, VOID_OBJECT);
            this.changeMgr.setPropertyChanged(this.name, addr, oldValue, true);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Boolean get(Address addr) {
        if (this.hasProperty(addr)) {
            return Boolean.TRUE;
        }
        return null;
    }
}

