/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InjectPayloadCallfixup
extends InjectPayloadSleigh {
    protected List<String> targetSymbolNames;

    protected InjectPayloadCallfixup(ConstructTpl pcode, InjectPayloadCallfixup failedPayload) {
        super(pcode, failedPayload);
        this.targetSymbolNames = failedPayload.targetSymbolNames;
    }

    protected InjectPayloadCallfixup(ConstructTpl pcode, String nm) {
        super(pcode, 1, nm);
        this.targetSymbolNames = new ArrayList<String>();
    }

    public InjectPayloadCallfixup(String sourceName) {
        super(sourceName);
        this.type = 1;
        this.targetSymbolNames = new ArrayList<String>();
    }

    public List<String> getTargets() {
        return this.targetSymbolNames;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_CALLFIXUP);
        encoder.writeString(AttributeId.ATTRIB_NAME, this.name);
        for (String nm : this.targetSymbolNames) {
            encoder.openElement(ElementId.ELEM_TARGET);
            encoder.writeString(AttributeId.ATTRIB_NAME, nm);
            encoder.closeElement(ElementId.ELEM_TARGET);
        }
        super.encode(encoder);
        encoder.closeElement(ElementId.ELEM_CALLFIXUP);
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage language) throws XmlParseException {
        XmlElement fixupEl = parser.start(new String[]{"callfixup"});
        this.name = fixupEl.getAttribute("name");
        boolean pcodeSubtag = false;
        while (parser.peek().isStart()) {
            String elname = parser.peek().getName();
            if (elname.equals("target")) {
                XmlElement subel = parser.start(new String[0]);
                String targetName = subel.getAttribute("name");
                if (targetName == null) {
                    throw new XmlParseException("Invalid callfixup target, missing target name");
                }
                this.targetSymbolNames.add(targetName);
                parser.end(subel);
                continue;
            }
            if (elname.equals("pcode")) {
                super.restoreXml(parser, language);
                pcodeSubtag = true;
                continue;
            }
            throw new XmlParseException("Unknown callfixup tag: " + elname);
        }
        if (!pcodeSubtag) {
            throw new XmlParseException("<callfixup> missing <pcode> subtag: " + this.name);
        }
        parser.end(fixupEl);
    }

    @Override
    public boolean isEquivalent(InjectPayload obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InjectPayloadCallfixup op2 = (InjectPayloadCallfixup)obj;
        if (!this.targetSymbolNames.equals(op2.targetSymbolNames)) {
            return false;
        }
        return super.isEquivalent(obj);
    }
}

