/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.protorules.HomogeneousAggregate;
import ghidra.program.model.lang.protorules.MetaTypeFilter;
import ghidra.program.model.lang.protorules.SizeRestrictedFilter;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public interface DatatypeFilter {
    public DatatypeFilter clone();

    public boolean isEquivalent(DatatypeFilter var1);

    public boolean filter(DataType var1);

    public void encode(Encoder var1) throws IOException;

    public void restoreXml(XmlPullParser var1) throws XmlParseException;

    public static DatatypeFilter restoreFilterXml(XmlPullParser parser) throws XmlParseException {
        SizeRestrictedFilter filter;
        XmlElement elemId = parser.peek();
        String nm = elemId.getAttribute(AttributeId.ATTRIB_NAME.name());
        if (nm.equals("any")) {
            filter = new SizeRestrictedFilter();
        } else if (nm.equals("homogeneous-float-aggregate")) {
            filter = new HomogeneousAggregate("homogeneous-float-aggregate", 7, 4, 0, 0);
        } else {
            int meta = PcodeDataTypeManager.getMetatype(nm);
            filter = new MetaTypeFilter(meta);
        }
        filter.restoreXml(parser);
        return filter;
    }
}

