/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.util.PropertySet;

public interface CodeUnit
extends MemBuffer,
PropertySet {
    public static final int MNEMONIC = -1;
    public static final int NO_COMMENT = -1;
    public static final int EOL_COMMENT = 0;
    public static final int PRE_COMMENT = 1;
    public static final int POST_COMMENT = 2;
    public static final int PLATE_COMMENT = 3;
    public static final int REPEATABLE_COMMENT = 4;
    public static final String COMMENT_PROPERTY = "COMMENT__GHIDRA_";
    public static final String SPACE_PROPERTY = "Space";
    public static final String INSTRUCTION_PROPERTY = "INSTRUCTION__GHIDRA_";
    public static final String DEFINED_DATA_PROPERTY = "DEFINED_DATA__GHIDRA_";

    public String getAddressString(boolean var1, boolean var2);

    public String getLabel();

    public Symbol[] getSymbols();

    public Symbol getPrimarySymbol();

    public Address getMinAddress();

    public Address getMaxAddress();

    public String getMnemonicString();

    public String getComment(int var1);

    public String[] getCommentAsArray(int var1);

    public void setComment(int var1, String var2);

    public void setCommentAsArray(int var1, String[] var2);

    public int getLength();

    public byte[] getBytes() throws MemoryAccessException;

    public void getBytesInCodeUnit(byte[] var1, int var2) throws MemoryAccessException;

    public boolean contains(Address var1);

    public int compareTo(Address var1);

    public void addMnemonicReference(Address var1, RefType var2, SourceType var3);

    public void removeMnemonicReference(Address var1);

    public Reference[] getMnemonicReferences();

    public Reference[] getOperandReferences(int var1);

    public Reference getPrimaryReference(int var1);

    public void addOperandReference(int var1, Address var2, RefType var3, SourceType var4);

    public void removeOperandReference(int var1, Address var2);

    public Reference[] getReferencesFrom();

    public ReferenceIterator getReferenceIteratorTo();

    public Program getProgram();

    public ExternalReference getExternalReference(int var1);

    public void removeExternalReference(int var1);

    public void setPrimaryMemoryReference(Reference var1);

    public void setStackReference(int var1, int var2, SourceType var3, RefType var4);

    public void setRegisterReference(int var1, Register var2, SourceType var3, RefType var4);

    public int getNumOperands();

    public Address getAddress(int var1);

    public Scalar getScalar(int var1);
}

