/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.pcode.DecoderException;
import java.io.IOException;
import java.io.InputStream;

public class LinkedByteBuffer {
    public static final int BUFFER_SIZE = 1024;
    private ArrayIter initialBuffer;
    private int byteCount = 0;
    private int maxCount;
    private ArrayIter currentBuffer = this.initialBuffer = new ArrayIter();
    private int currentPos = 0;
    private int padValue;
    private InputStream asNeededStream = null;
    private String description;

    public LinkedByteBuffer(int max, int pad, String desc) {
        this.padValue = pad;
        this.maxCount = max;
        this.initialBuffer.array = new byte[1024];
        this.initialBuffer.next = null;
        this.description = desc;
    }

    public void close() throws IOException {
        if (this.asNeededStream != null) {
            this.asNeededStream.close();
        }
    }

    public void ingestStreamAsNeeded(InputStream stream, Position start) throws IOException {
        this.asNeededStream = stream;
        this.currentPos = this.readPage(stream, this.initialBuffer);
        if (this.currentPos < 1024) {
            this.pad();
        }
        this.getStartPosition(start);
        this.initialBuffer = null;
    }

    public void ingestStreamToNextTerminator(InputStream stream) throws IOException {
        int tok = stream.read();
        if (tok <= 0) {
            return;
        }
        while (true) {
            if (this.byteCount > this.maxCount) {
                throw new IOException("Response buffer size exceded for: " + this.description);
            }
            while (this.currentPos != 1024) {
                this.currentBuffer.array[this.currentPos++] = (byte)tok;
                tok = stream.read();
                if (tok > 0) continue;
            }
            this.byteCount += this.currentPos;
            if (tok <= 0) {
                return;
            }
            this.currentBuffer = this.currentBuffer.next = new ArrayIter();
            this.currentBuffer.array = new byte[1024];
            this.currentPos = 0;
        }
    }

    private int readPage(InputStream stream, ArrayIter buffer) throws IOException {
        int readLen;
        int len = this.maxCount - this.byteCount;
        if (len > 1024) {
            len = 1024;
        }
        int pos = 0;
        while ((readLen = stream.read(this.currentBuffer.array, pos, len - pos)) >= 0 && (pos += readLen) < len) {
        }
        this.byteCount += pos;
        return pos;
    }

    public void ingestStream(InputStream stream) throws IOException {
        while (this.byteCount < this.maxCount) {
            int pos = this.readPage(stream, this.currentBuffer);
            if (pos < 1024) {
                this.currentPos += pos;
                break;
            }
            this.currentBuffer = this.currentBuffer.next = new ArrayIter();
            this.currentBuffer.array = new byte[1024];
            this.currentPos = 0;
        }
    }

    public void ingestBytes(byte[] byteArray, int off, int sz) throws IOException {
        for (int i = 0; i < sz; ++i) {
            byte tok = byteArray[off + i];
            if (this.currentPos == 1024) {
                this.currentBuffer = this.currentBuffer.next = new ArrayIter();
                this.currentBuffer.array = new byte[1024];
                this.currentPos = 0;
            }
            this.currentBuffer.array[this.currentPos++] = tok;
            ++this.byteCount;
            if (this.byteCount <= this.maxCount) continue;
            throw new IOException("Response buffer size exceded for: " + this.description);
        }
    }

    public void pad() {
        if (this.currentPos == 1024) {
            this.byteCount += this.currentPos;
            this.currentBuffer = this.currentBuffer.next = new ArrayIter();
            this.currentBuffer.array = new byte[1];
            this.currentPos = 0;
        }
        this.currentBuffer.array[this.currentPos++] = (byte)this.padValue;
    }

    public void getStartPosition(Position position) {
        position.array = this.initialBuffer.array;
        position.current = 0;
        position.seqIter = this.initialBuffer;
    }

    private ArrayIter readNextPage(ArrayIter buffer) throws DecoderException {
        if (this.asNeededStream == null) {
            throw new DecoderException("Unexpected end of stream");
        }
        buffer.next = this.currentBuffer = new ArrayIter();
        this.currentBuffer.array = new byte[1024];
        try {
            this.currentPos = this.readPage(this.asNeededStream, this.currentBuffer);
        }
        catch (IOException e) {
            throw new DecoderException(e.getMessage());
        }
        if (this.currentPos < 1024) {
            this.pad();
        }
        return buffer.next;
    }

    public static class ArrayIter {
        public ArrayIter next;
        public byte[] array;
    }

    public static class Position {
        public LinkedByteBuffer buffer;
        public ArrayIter seqIter;
        public byte[] array;
        public int current;

        public void copy(Position pos) {
            this.seqIter = pos.seqIter;
            this.array = pos.array;
            this.current = pos.current;
        }

        public final byte getByte() {
            return this.array[this.current];
        }

        public final byte getBytePlus1() throws DecoderException {
            int plus1 = this.current + 1;
            if (plus1 == this.array.length) {
                ArrayIter iter = this.seqIter.next;
                if (iter == null) {
                    iter = this.buffer.readNextPage(this.seqIter);
                }
                return iter.array[0];
            }
            return this.array[plus1];
        }

        public final byte getNextByte() throws DecoderException {
            byte res = this.array[this.current];
            ++this.current;
            if (this.current != this.array.length) {
                return res;
            }
            this.seqIter = this.seqIter.next == null ? this.buffer.readNextPage(this.seqIter) : this.seqIter.next;
            this.array = this.seqIter.array;
            this.current = 0;
            return res;
        }

        public final void advancePosition(int skip) throws DecoderException {
            while (this.array.length - this.current <= skip) {
                skip -= this.array.length - this.current;
                this.seqIter = this.seqIter.next == null ? this.buffer.readNextPage(this.seqIter) : this.seqIter.next;
                this.array = this.seqIter.array;
                this.current = 0;
            }
            this.current += skip;
        }
    }
}

