/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolHashRecord;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStream;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractSymbolInformation {
    public static final int HEADER_SIGNATURE = -1;
    public static final int GSI70 = -248575718;
    public static final int HASH_PRE70_HEADER_LENGTH = 0;
    public static final int HASH_70_HEADER_LENGTH = 16;
    public static final int HASH_HEADER_MIN_READ_LENGTH = Integer.max(0, 16);
    protected AbstractPdb pdb;
    protected int streamNumber;
    protected int symbolHashLength;
    protected int symbolHashOffset;
    protected int hashHeaderLength;
    protected int headerSignature;
    protected int versionNumber;
    protected int hashRecordsLength;
    protected int bucketsLength;
    protected int hashRecordsOffset;
    protected int bucketsOffset;
    protected int numHashRecords;
    protected int numExtraBytes;
    protected int hashRecordsBitMapLength;

    public AbstractSymbolInformation(AbstractPdb pdbIn, int streamNumber) {
        this.pdb = pdbIn;
        this.streamNumber = streamNumber;
    }

    public List<Long> getModifiedHashRecordSymbolOffsets() throws CancelledException, PdbException {
        return this.generateModifiedSymbolOffsets();
    }

    List<Integer> getHashBucketOffsets() throws CancelledException, PdbException {
        try {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber, this.bucketsOffset, this.bucketsLength);
            if (this.headerSignature == -1) {
                return this.deserializedCompressedHashBuckets(reader);
            }
            return this.deserializedHashBuckets(reader);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)String.format("PDB: Error creating hash buckets while reading stream %d offset %d and length %d", this.streamNumber, this.bucketsOffset, this.bucketsLength));
            return new ArrayList<Integer>();
        }
    }

    Set<SymbolHashRecord> getHashRecords() throws CancelledException, PdbException {
        try {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber, this.hashRecordsOffset, this.hashRecordsLength);
            return this.deserializeHashRecords(reader);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)String.format("PDB: Error creating hash records while reading stream %d offset %d and length %d", this.streamNumber, this.hashRecordsOffset, this.hashRecordsLength));
            return new TreeSet<SymbolHashRecord>();
        }
    }

    abstract void initialize() throws IOException, PdbException, CancelledException;

    void initializeValues() {
        if (this.pdb.hasMinimalDebugInfo()) {
            this.hashRecordsBitMapLength = 32768;
            this.numExtraBytes = 0;
            this.numHashRecords = 262143;
        } else {
            this.hashRecordsBitMapLength = 512;
            this.numExtraBytes = 4;
            this.numHashRecords = 4096;
        }
    }

    void dump(Writer writer) throws IOException, CancelledException, PdbException {
        StringBuilder builder = new StringBuilder();
        builder.append("AbstractSymbolInformation-----------------------------------\n");
        this.dumpHashHeader(writer);
        this.dumpHashBasics(writer);
        this.dumpHashRecords(writer);
        builder.append("\nEnd AbstractSymbolInformation-------------------------------\n");
        writer.write(builder.toString());
    }

    protected void dumpHashBasics(Writer writer) throws IOException {
        writer.write("HashBasics--------------------------------------------------\n");
        writer.write("hashRecordsBitMapLength: " + this.hashRecordsBitMapLength);
        writer.write("\nnumExtraBytes: " + this.numExtraBytes);
        writer.write("\nnumHashRecords: " + this.numHashRecords);
        writer.write("\nEnd HashBasics----------------------------------------------\n");
    }

    protected void dumpHashHeader(Writer writer) throws IOException {
        writer.write("HashHeader--------------------------------------------------\n");
        writer.write("headerSignature: " + this.headerSignature);
        writer.write("\nversionNumber: " + this.versionNumber);
        writer.write("\nlengthHashRecords: " + this.hashRecordsLength);
        writer.write("\nlengthBuckets: " + this.bucketsLength);
        writer.write("\nEnd HashHeader----------------------------------------------\n");
    }

    protected List<Long> generateModifiedSymbolOffsets() throws PdbException, CancelledException {
        ArrayList<Long> modifiedHashRecordSymbolOffsets = new ArrayList<Long>();
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return modifiedHashRecordSymbolOffsets;
        }
        Set<SymbolHashRecord> hashRecords = this.getHashRecords();
        for (SymbolHashRecord record : hashRecords) {
            this.pdb.checkCancelled();
            long offset = record.getOffset() - 2L;
            modifiedHashRecordSymbolOffsets.add(offset);
        }
        return modifiedHashRecordSymbolOffsets;
    }

    protected void dumpHashRecords(Writer writer) throws IOException, CancelledException, PdbException {
        Set<SymbolHashRecord> hashRecords = this.getHashRecords();
        writer.write("HashRecords-------------------------------------------------\n");
        writer.write("numHashRecords: " + hashRecords.size() + "\n");
        for (SymbolHashRecord record : hashRecords) {
            this.pdb.checkCancelled();
            writer.write(String.format("0X%08X  0X%04X\n", record.getOffset(), record.getReferenceCount()));
        }
        writer.write("\nEnd HashRecords---------------------------------------------\n");
    }

    protected void deserializeHashHeader() throws PdbException, CancelledException, IOException {
        MsfStream stream = this.pdb.getMsf().getStream(this.streamNumber);
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber, this.symbolHashOffset, HASH_HEADER_MIN_READ_LENGTH);
        this.deserializeHashHeader(reader, stream.getLength());
    }

    private void deserializeHashHeader(PdbByteReader reader, int streamLength) throws PdbException {
        this.headerSignature = reader.parseInt();
        if (this.headerSignature == -1) {
            this.hashHeaderLength = 16;
            this.versionNumber = reader.parseInt();
            this.hashRecordsLength = reader.parseInt();
            this.bucketsLength = reader.parseInt();
            this.hashRecordsOffset = this.symbolHashOffset + reader.getIndex();
            this.bucketsOffset = this.hashRecordsOffset + this.hashRecordsLength;
        } else {
            this.hashHeaderLength = 0;
            reader.reset();
            this.bucketsLength = 4 * (this.numHashRecords + 1);
            if (streamLength < this.bucketsLength) {
                throw new PdbException("Not enough data for symbol hash buckets.");
            }
            this.hashRecordsLength = streamLength - this.bucketsLength;
            this.hashRecordsOffset = this.symbolHashOffset + 0;
            this.bucketsOffset = this.hashRecordsOffset + this.hashRecordsLength;
        }
    }

    private List<Integer> deserializedCompressedHashBuckets(PdbByteReader reader) throws PdbException, CancelledException {
        ArrayList<Integer> hashBucketOffsets = new ArrayList<Integer>();
        PdbByteReader bitEncoderReader = reader.getSubPdbByteReader(this.hashRecordsBitMapLength);
        reader.getSubPdbByteReader(this.numExtraBytes);
        while (bitEncoderReader.hasMore() && reader.hasMore()) {
            this.pdb.checkCancelled();
            long val = bitEncoderReader.parseUnsignedIntVal();
            for (int bit = 0; bit < 32 && reader.hasMore(); ++bit) {
                this.pdb.checkCancelled();
                if ((val & 1L) == 1L) {
                    hashBucketOffsets.add(reader.parseInt());
                } else {
                    hashBucketOffsets.add(-1);
                }
                val >>= 1;
            }
        }
        if (reader.hasMore()) {
            throw new PdbException("Compressed GSI Hash Buckets corrupt");
        }
        while (bitEncoderReader.hasMore()) {
            this.pdb.checkCancelled();
            if (bitEncoderReader.parseUnsignedIntVal() == 0L) continue;
            throw new PdbException("Compressed GSI Hash Buckets corrupt");
        }
        return hashBucketOffsets;
    }

    private List<Integer> deserializedHashBuckets(PdbByteReader reader) throws PdbException, CancelledException {
        ArrayList<Integer> hashBucketOffsets = new ArrayList<Integer>();
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            hashBucketOffsets.add(reader.parseInt());
        }
        return hashBucketOffsets;
    }

    private Set<SymbolHashRecord> deserializeHashRecords(PdbByteReader reader) throws PdbException, CancelledException {
        TreeSet<SymbolHashRecord> hashRecords = new TreeSet<SymbolHashRecord>();
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            SymbolHashRecord record = new SymbolHashRecord();
            record.parse(reader);
            hashRecords.add(record);
        }
        return hashRecords;
    }
}

