/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderUtils;
import ghidra.app.util.bin.format.pdb2.pdbreader.SectionContribution;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ModuleInformation {
    protected long modulePointer;
    protected SectionContribution sectionContribution;
    protected boolean writtenSinceOpen;
    protected boolean ecSymbolicInformationEnabled;
    protected int bitfield;
    protected int spare;
    protected int indexToTSMList;
    protected int streamNumberDebugInformation;
    protected int sizeLocalSymbolsDebugInformation;
    protected int sizeLineNumberDebugInformation;
    protected int sizeC13StyleLineNumberInformation;
    protected int numFilesContributing;
    protected List<Integer> offsetsArray = new ArrayList<Integer>();
    protected List<String> filenamesArray = new ArrayList<String>();
    protected String moduleName;
    protected String objectFileName;
    protected long nameIndexSourceFile;
    protected long nameIndexCompilerPdbPath;
    protected AbstractPdb pdb;
    private Map<Integer, String> filenameByOffset = new HashMap<Integer, String>();

    public ModuleInformation(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    public int getNumFilesContributing() {
        return this.numFilesContributing;
    }

    public List<Integer> getOffsetsArray() {
        return this.offsetsArray;
    }

    public List<String> getFilenamesArray() {
        return this.filenamesArray;
    }

    public int getStreamNumberDebugInformation() {
        return this.streamNumberDebugInformation;
    }

    public int getSizeLocalSymbolsDebugInformation() {
        return this.sizeLocalSymbolsDebugInformation;
    }

    public int getSizeLineNumberDebugInformation() {
        return this.sizeLineNumberDebugInformation;
    }

    public int getSizeC13StyleLineNumberInformation() {
        return this.sizeC13StyleLineNumberInformation;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public SectionContribution getSectionContribution() {
        return this.sectionContribution;
    }

    public String getFilenameByOffset(int offset) {
        return this.filenameByOffset.get(offset);
    }

    protected void deserialize(PdbByteReader reader) throws PdbException {
        this.modulePointer = reader.parseUnsignedIntVal();
        this.sectionContribution.deserialize(reader);
        this.bitfield = reader.parseUnsignedShortVal();
        this.writtenSinceOpen = (this.bitfield & 1) == 1;
        this.bitfield >>= 1;
        this.spare = this.bitfield & 0x7F;
        this.bitfield >>= 1;
        this.indexToTSMList = this.bitfield & 0xFF;
        this.ecSymbolicInformationEnabled = false;
        this.streamNumberDebugInformation = reader.parseUnsignedShortVal();
        this.sizeLocalSymbolsDebugInformation = reader.parseInt();
        this.sizeLineNumberDebugInformation = reader.parseInt();
        this.sizeC13StyleLineNumberInformation = reader.parseInt();
        this.numFilesContributing = reader.parseUnsignedShortVal();
        reader.align4();
        reader.parseBytes(4);
        this.parseAdditionals(reader);
        reader.align4();
    }

    protected abstract void parseAdditionals(PdbByteReader var1) throws PdbException;

    protected abstract void dumpAdditionals(Writer var1) throws IOException;

    protected void addFilenameByOffset(int offset, String filename) {
        this.filenameByOffset.put(offset, filename);
    }

    void dump(Writer writer) throws IOException {
        PdbReaderUtils.dumpHead(writer, this);
        writer.write("modulePointer: " + this.modulePointer);
        writer.write("\n");
        this.sectionContribution.dump(writer);
        writer.write("\nwrittenSinceOpen: " + this.writtenSinceOpen);
        writer.write("\necSymbolicInformationEnabled: " + this.ecSymbolicInformationEnabled);
        writer.write("\nspare: " + this.spare);
        writer.write("\nindexToTSMList: " + this.indexToTSMList);
        writer.write("\nstreamNumberDebugInformation: " + this.streamNumberDebugInformation);
        writer.write("\nsizeLocalSymbolsDebugInformation: " + this.sizeLocalSymbolsDebugInformation);
        writer.write("\nsizeLineNumberDebugInformation: " + this.sizeLineNumberDebugInformation);
        writer.write("\nsizeC13StyleLineNumberInformation: " + this.sizeC13StyleLineNumberInformation);
        writer.write("\nnumFilesContributing: " + this.numFilesContributing);
        this.dumpAdditionals(writer);
        writer.write("\nmoduleName: " + this.moduleName);
        writer.write("\nobjectFileName: " + this.objectFileName);
        writer.write("\n");
        PdbReaderUtils.dumpTail(writer, this);
    }
}

