/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.ModuleInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStream;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.util.datastruct.LRUMap;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class SymbolRecords {
    private AbstractPdb pdb;
    private boolean getSig = true;
    private int cvSignature = -1;
    private int cvSignatureCase1and2Stream = 65535;
    private double factor;
    private Map<Integer, LRUMap<Integer, SymLen>> symbolCache;

    public SymbolRecords(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    @Deprecated
    protected Map<Long, AbstractMsSymbol> getSymbolsByOffset() throws CancelledException, PdbException, IOException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return new TreeMap<Long, AbstractMsSymbol>();
        }
        int streamNumber = debugInfo.getSymbolRecordsStreamNumber();
        if (streamNumber <= 0) {
            return new TreeMap<Long, AbstractMsSymbol>();
        }
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNumber);
        return SymbolRecords.deserializeSymbolRecords(this.pdb, reader);
    }

    @Deprecated
    protected Map<Long, AbstractMsSymbol> getModuleSymbolsByOffset(int moduleNumber) throws CancelledException, IOException, PdbException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return new TreeMap<Long, AbstractMsSymbol>();
        }
        ModuleInformation moduleInfo = debugInfo.moduleInformationList.get(moduleNumber);
        int streamNumber = moduleInfo.getStreamNumberDebugInformation();
        if (streamNumber == 65535) {
            return new TreeMap<Long, AbstractMsSymbol>();
        }
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNumber);
        int sizeSymbolsSection = moduleInfo.getSizeLocalSymbolsDebugInformation();
        PdbByteReader symbolsReader = reader.getSubPdbByteReader(sizeSymbolsSection);
        symbolsReader.skip(this.getCvSigLength(streamNumber));
        return SymbolRecords.deserializeSymbolRecords(this.pdb, symbolsReader);
    }

    void initialize() throws IOException, PdbException, CancelledException {
        this.initializeCache(0.001);
        this.determineCvSigValues();
    }

    private void determineCvSigValues() throws CancelledException, IOException, PdbException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        ModuleInformation moduleInfo = debugInfo.getModuleInformationList().get(0);
        int streamNumber = moduleInfo.getStreamNumberDebugInformation();
        if (streamNumber == 65535) {
            return;
        }
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNumber);
        if (this.getSig) {
            this.cvSignature = reader.parseInt();
        }
        switch (this.cvSignature) {
            case 1: 
            case 2: {
                this.getSig = false;
                break;
            }
            case 4: {
                break;
            }
            default: {
                if (this.cvSignature >= 65536) break;
                throw new PdbException("Invalid module CV signature in stream " + streamNumber);
            }
        }
        this.cvSignatureCase1and2Stream = streamNumber;
    }

    public int getCvSigLength(int streamNumber) throws CancelledException, PdbException {
        PdbByteReader reader;
        if (streamNumber == 65535) {
            return 0;
        }
        try {
            reader = this.pdb.getReaderForStreamNumber(streamNumber, 0, 4);
        }
        catch (IOException e) {
            throw new PdbException("PDB Error: Not enough data to read CvSigLength");
        }
        if (this.getSig) {
            this.cvSignature = reader.parseInt();
        }
        int size = 0;
        switch (this.cvSignature) {
            case 1: 
            case 2: {
                if (streamNumber != this.cvSignatureCase1and2Stream) break;
                size = 4;
                break;
            }
            case 4: {
                size = 4;
                break;
            }
            default: {
                throw new PdbException("PDB Error: Bad CvSigLength state");
            }
        }
        return size;
    }

    public static Map<Long, AbstractMsSymbol> deserializeSymbolRecords(AbstractPdb pdb, PdbByteReader reader) throws PdbException, CancelledException {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        TreeMap<Long, AbstractMsSymbol> mySymbolsByOffset = new TreeMap<Long, AbstractMsSymbol>();
        while (reader.hasMore()) {
            pdb.checkCancelled();
            int offset = reader.getIndex();
            AbstractMsSymbol symbol = SymbolParser.parseLengthAndSymbol(pdb, reader);
            mySymbolsByOffset.put(Long.valueOf(offset), symbol);
        }
        return mySymbolsByOffset;
    }

    public SymLen getRandomAccessRecordUsingModuleNumber(int moduleNumber, int offset) throws PdbException, CancelledException {
        ModuleInformation moduleInfo = this.pdb.getDebugInfo().getModuleInformation(moduleNumber);
        int streamNumber = moduleInfo.getStreamNumberDebugInformation();
        if (streamNumber == 65535) {
            return null;
        }
        return this.getRandomAccessRecord(streamNumber, offset);
    }

    public SymLen getRandomAccessRecord(int streamNumber, int offset) throws CancelledException, PdbException {
        return this.getRandomAccessRecordFromStream(streamNumber, offset);
    }

    private SymLen getRandomAccessRecordFromStream(int streamNumber, int offset) throws CancelledException, PdbException {
        try {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNumber, offset, 2);
            int recordLength = reader.parseUnsignedShortVal();
            PdbByteReader recordReader = this.pdb.getReaderForStreamNumber(streamNumber, offset + 2, recordLength);
            AbstractMsSymbol symbol = SymbolParser.parse(this.pdb, recordReader);
            return new SymLen(symbol, recordLength + 2);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void initializeCache(double factorArg) {
        this.factor = factorArg;
        this.symbolCache = new HashMap<Integer, LRUMap<Integer, SymLen>>();
    }

    private LRUMap<Integer, SymLen> getSymbolCache(int streamNumber) {
        LRUMap streamSymbolCache = this.symbolCache.get(streamNumber);
        if (streamSymbolCache == null) {
            MsfStream stream = this.pdb.getMsf().getStream(streamNumber);
            if (stream == null) {
                return null;
            }
            int size = (int)(this.factor * (double)stream.getLength() + 256.0);
            streamSymbolCache = new LRUMap(size);
            this.symbolCache.put(streamNumber, (LRUMap<Integer, SymLen>)streamSymbolCache);
        }
        return streamSymbolCache;
    }

    protected void dump(Writer writer) throws IOException, CancelledException, PdbException {
        writer.write("SymbolRecords-----------------------------------------------\n");
        Map<Long, AbstractMsSymbol> symbolsByOffset = this.getSymbolsByOffset();
        this.dumpSymbolMap(symbolsByOffset, writer);
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        for (int i = 0; i < debugInfo.getNumModules(); ++i) {
            this.pdb.checkCancelled();
            Map<Long, AbstractMsSymbol> map = this.getModuleSymbolsByOffset(i);
            if (map == null) continue;
            writer.write("Module(" + i + ") List:\n");
            this.dumpSymbolMap(map, writer);
        }
        writer.write("\nEnd SymbolRecords-------------------------------------------\n");
    }

    protected void dumpSymbolMap(Map<Long, AbstractMsSymbol> mySymbolsByOffset, Writer writer) throws IOException, CancelledException {
        writer.write("SymbolMap---------------------------------------------------");
        for (Map.Entry<Long, AbstractMsSymbol> entry : mySymbolsByOffset.entrySet()) {
            this.pdb.checkCancelled();
            StringBuilder builder = new StringBuilder();
            builder.append("\n------------------------------------------------------------\n");
            builder.append(String.format("Offset: 0X%08X\n", entry.getKey()));
            builder.append(entry.getValue());
            writer.write(builder.toString());
        }
        writer.write("\nEnd SymbolMap-----------------------------------------------\n");
    }

    public record SymLen(AbstractMsSymbol symbol, int length) {
    }
}

