/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.SymbolPathParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.PdbNamespaceUtils;
import ghidra.app.util.pdb.pdbapplicator.CppCompositeType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsDataTypeApplier;
import ghidra.util.Msg;
import mdemangler.MDException;
import mdemangler.MDMangGhidra;
import mdemangler.MDMangUtils;
import mdemangler.MDParsableItem;
import mdemangler.datatype.MDDataType;

public abstract class AbstractComplexTypeApplier
extends MsDataTypeApplier {
    public AbstractComplexTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    SymbolPath getSymbolPath(AbstractComplexMsType type) {
        return AbstractComplexTypeApplier.getSymbolPath(type.getName(), type.getMangledName());
    }

    public <T extends AbstractComplexMsType> T getDefinitionType(AbstractComplexMsType mType, Class<T> type) {
        mType = (AbstractComplexMsType)this.applicator.getMappedTypeRecord(mType.getRecordNumber(), type);
        return (T)((AbstractComplexMsType)type.cast(mType));
    }

    SymbolPath getFixedSymbolPath(AbstractComplexMsType type) {
        SymbolPath path = this.getSymbolPath(type);
        RecordNumber mappedNumber = this.applicator.getMappedRecordNumber(type.getRecordNumber());
        Integer num = mappedNumber.getNumber();
        return PdbNamespaceUtils.convertToGhidraPathName(path, num);
    }

    public static SymbolPath getSymbolPath(DefaultPdbApplicator applicator, RecordNumber recordNumber) {
        AbstractMsType t = applicator.getTypeRecord(recordNumber);
        if (!(t instanceof AbstractComplexMsType)) {
            return null;
        }
        AbstractComplexMsType ct = (AbstractComplexMsType)t;
        CppCompositeType cpp = applicator.getClassType(ct);
        if (cpp != null) {
            return cpp.getSymbolPath();
        }
        return AbstractComplexTypeApplier.getSymbolPath(ct.getName(), ct.getMangledName());
    }

    private static SymbolPath getSymbolPath(String name, String mangledName) {
        SymbolPath symbolPath = null;
        if (mangledName != null) {
            symbolPath = AbstractComplexTypeApplier.getSymbolPathFromMangledTypeName(mangledName, name);
        }
        if (symbolPath == null) {
            symbolPath = MDMangUtils.standarizeSymbolPathUnderscores((SymbolPath)new SymbolPath(SymbolPathParser.parse((String)name)));
        }
        return symbolPath;
    }

    private static SymbolPath getSymbolPathFromMangledTypeName(String mangledString, String fullPathName) {
        MDMangGhidra demangler = new MDMangGhidra();
        try {
            MDDataType mdDataType = demangler.demangleType(mangledString, true);
            return MDMangUtils.consolidateSymbolPath((MDParsableItem)mdDataType, (String)fullPathName, (boolean)true);
        }
        catch (MDException e) {
            Msg.info(AbstractComplexTypeApplier.class, (Object)("PDB issue dmangling type name: " + e.getMessage() + " for : " + mangledString));
            return null;
        }
    }
}

