/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ClassFieldAttributes {
    private static final Map<ClassFieldAttributes, ClassFieldAttributes> map = new HashMap<ClassFieldAttributes, ClassFieldAttributes>();
    public static final ClassFieldAttributes UNKNOWN = ClassFieldAttributes.get(Access.UNKNOWN, Property.UNKNOWN);
    public static final ClassFieldAttributes BLANK = ClassFieldAttributes.get(Access.BLANK, Property.BLANK);
    private final Access access;
    private final Property property;

    public static ClassFieldAttributes get(Access access, Property property) {
        ClassFieldAttributes key = new ClassFieldAttributes(access, property);
        ClassFieldAttributes cfa = map.putIfAbsent(key, key);
        return cfa != null ? cfa : key;
    }

    static ClassFieldAttributes convert(ClassFieldMsAttributes msAtts, Access defaultAccess) {
        Access myAccess = switch (msAtts.getAccess()) {
            case ClassFieldMsAttributes.Access.PUBLIC -> Access.PUBLIC;
            case ClassFieldMsAttributes.Access.PROTECTED -> Access.PROTECTED;
            case ClassFieldMsAttributes.Access.PRIVATE -> Access.PRIVATE;
            case ClassFieldMsAttributes.Access.BLANK -> defaultAccess;
            default -> Access.UNKNOWN;
        };
        Property myProperty = switch (msAtts.getProperty()) {
            case ClassFieldMsAttributes.Property.VIRTUAL -> Property.VIRTUAL;
            case ClassFieldMsAttributes.Property.STATIC -> Property.STATIC;
            case ClassFieldMsAttributes.Property.FRIEND -> Property.FRIEND;
            case ClassFieldMsAttributes.Property.BLANK -> Property.BLANK;
            default -> Property.UNKNOWN;
        };
        return ClassFieldAttributes.get(myAccess, myProperty);
    }

    private ClassFieldAttributes(Access access, Property property) {
        this.access = access;
        this.property = property;
    }

    Access getAccess() {
        return this.access;
    }

    Property getProperty() {
        return this.property;
    }

    void emit(StringBuilder builder) {
        StringBuilder myBuilder = new StringBuilder();
        if (this.access.getValue() > Access.BLANK.getValue()) {
            myBuilder.append((Object)this.access);
            myBuilder.append(' ');
        }
        if (this.property.getValue() > Property.BLANK.getValue()) {
            myBuilder.append((Object)this.property);
            myBuilder.append(' ');
        }
        builder.append((CharSequence)myBuilder);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.emit(builder);
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.access, this.property});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassFieldAttributes other = (ClassFieldAttributes)obj;
        return this.access == other.access && this.property == other.property;
    }

    static enum Access {
        UNKNOWN("UNKNOWN_ACCESS", -1),
        BLANK("", 0),
        PUBLIC("public", 1),
        PROTECTED("protected", 2),
        PRIVATE("private", 3);

        private static final Map<Integer, Access> BY_VALUE;
        private final String label;
        private final int value;

        public String getString() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }

        public int getValue() {
            return this.value;
        }

        public static Access fromValue(int val) {
            return BY_VALUE.getOrDefault(val, UNKNOWN);
        }

        private Access(String label, int value) {
            this.label = label;
            this.value = value;
        }

        public Access mergeRestrictive(Access other) {
            if (this.value > other.value) {
                return this;
            }
            return other;
        }

        public Access mergePermissive(Access other) {
            if (this.value < other.value) {
                if (this == UNKNOWN) {
                    return other;
                }
                return this;
            }
            return other;
        }

        static {
            BY_VALUE = new HashMap<Integer, Access>();
            for (Access val : Access.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }

    static enum Property {
        UNKNOWN("INVALID_PROPERTY", -1),
        BLANK("", 0),
        VIRTUAL("virtual", 1),
        STATIC("static", 2),
        FRIEND("friend", 3);

        private static final Map<Integer, Property> BY_VALUE;
        private final String label;
        private final int value;

        public String getString() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }

        public int getValue() {
            return this.value;
        }

        public static Property fromValue(int val) {
            return BY_VALUE.getOrDefault(val, UNKNOWN);
        }

        private Property(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Property>();
            for (Property val : Property.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

