/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb.DefaultCompositeMember;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractCompositeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumerateMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractIndirectVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMethodListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMethodRecordMs;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractOneMethodMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractOverloadedMethodMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractPointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractStaticMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractStructureMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractUnionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.pdb.pdbapplicator.AbstractComplexTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ArrayTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.BaseClassTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ClassFieldAttributes;
import ghidra.app.util.pdb.pdbapplicator.CppCompositeType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbUniversalMember;
import ghidra.app.util.pdb.pdbapplicator.EnumerateTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.FieldListTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MemberTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.NestedTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PointerTypeApplier;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CompositeTypeApplier
extends AbstractComplexTypeApplier {
    public CompositeTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    CppCompositeType getClassType(AbstractMsType type) {
        return this.applicator.getClassType(type);
    }

    private ComboType create(AbstractCompositeMsType type) {
        AbstractCompositeMsType defType = this.getDefinitionType(type, AbstractCompositeMsType.class);
        SymbolPath fixedSp = this.getFixedSymbolPath(defType);
        CategoryPath categoryPath = this.applicator.getCategory(fixedSp.getParent());
        return CompositeTypeApplier.createComposite(this.applicator, fixedSp.getName(), defType, categoryPath, fixedSp);
    }

    private static ComboType createComposite(DefaultPdbApplicator myApplicator, String name, AbstractCompositeMsType compositeMsType, CategoryPath categoryPath, SymbolPath fixedSymbolPath) {
        CppCompositeType myClassType;
        StructureDataType myComposite;
        String mangledName = compositeMsType.getMangledName();
        int size = myApplicator.bigIntegerToInt(compositeMsType.getSize());
        if (compositeMsType instanceof AbstractClassMsType) {
            myApplicator.predefineClass(fixedSymbolPath);
            myComposite = new StructureDataType(categoryPath, fixedSymbolPath.getName(), size, myApplicator.getDataTypeManager());
            myClassType = new CppCompositeType(fixedSymbolPath, (Composite)myComposite, mangledName);
            myClassType.setClass();
        } else if (compositeMsType instanceof AbstractStructureMsType) {
            myComposite = new StructureDataType(categoryPath, fixedSymbolPath.getName(), size, myApplicator.getDataTypeManager());
            myClassType = new CppCompositeType(fixedSymbolPath, (Composite)myComposite, mangledName);
            myClassType.setStruct();
        } else if (compositeMsType instanceof AbstractUnionMsType) {
            myComposite = new UnionDataType(categoryPath, fixedSymbolPath.getName(), myApplicator.getDataTypeManager());
            myClassType = new CppCompositeType(fixedSymbolPath, (Composite)myComposite, mangledName);
            myClassType.setUnion();
        } else {
            String message = "Unsupported datatype (" + compositeMsType.getClass().getSimpleName() + "): " + fixedSymbolPath.getPath();
            myApplicator.appendLogMsg(message);
            return null;
        }
        myClassType.setName(name);
        myClassType.setSize(size);
        myClassType.setFinal(compositeMsType.getMsProperty().isSealed());
        return new ComboType((Composite)myComposite, myClassType);
    }

    @Override
    boolean apply(AbstractMsType type) throws PdbException, CancelledException {
        return this.apply((AbstractCompositeMsType)type);
    }

    private boolean applyInternal(ComboType combo, AbstractCompositeMsType type) throws CancelledException, PdbException {
        FieldListTypeApplier fieldListApplier = FieldListTypeApplier.getFieldListApplierSpecial(this.applicator, type.getFieldDescriptorListRecordNumber());
        FieldListTypeApplier.FieldLists lists = fieldListApplier.getFieldLists(type.getFieldDescriptorListRecordNumber());
        if (!this.precheckOrScheduleDependencies(lists)) {
            return false;
        }
        if (type instanceof AbstractUnionMsType) {
            this.applyBasic(combo, type, lists);
        } else {
            this.applyCpp(combo, type, lists);
        }
        return true;
    }

    private void applyBasic(ComboType combo, AbstractCompositeMsType type, FieldListTypeApplier.FieldLists lists) throws CancelledException, PdbException {
        Composite composite = combo.dt();
        CppCompositeType classType = combo.ct();
        boolean isClass = type instanceof AbstractClassMsType;
        int size = this.getSizeInt(type);
        CompositeTypeApplier.clearComponents(composite);
        if (!lists.methods().isEmpty()) {
            SymbolPath sp = this.getFixedSymbolPath(type);
            this.applicator.predefineClass(sp);
        }
        ArrayList<DefaultPdbUniversalMember> myMembers = new ArrayList<DefaultPdbUniversalMember>();
        this.addVftPtrs(composite, classType, lists.vftPtrs(), type, myMembers);
        this.addMembers(composite, classType, lists.nonstaticMembers(), type, myMembers);
        if (!DefaultCompositeMember.applyDataTypeMembers(composite, isClass, size, myMembers, msg -> this.reconstructionWarn((String)msg, this.hasHiddenComponents(lists)), this.applicator.getCancelOnlyWrappingMonitor())) {
            CompositeTypeApplier.clearComponents(composite);
        }
    }

    private void applyCpp(ComboType combo, AbstractCompositeMsType type, FieldListTypeApplier.FieldLists lists) throws PdbException, CancelledException {
        Composite composite = combo.dt();
        CppCompositeType classType = combo.ct();
        CompositeTypeApplier.clearComponents(composite);
        if (!lists.bases().isEmpty() || !lists.methods().isEmpty()) {
            SymbolPath sp = classType.getSymbolPath();
            this.applicator.predefineClass(sp);
        }
        ArrayList<DefaultPdbUniversalMember> myMembers = new ArrayList<DefaultPdbUniversalMember>();
        this.addClassTypeBaseClasses(composite, classType, lists.bases(), type);
        this.addVftPtrs(composite, classType, lists.vftPtrs(), type, myMembers);
        this.addMembers(composite, classType, lists.nonstaticMembers(), type, myMembers);
        if (!classType.validate()) {
            // empty if block
        }
        classType.createLayout(this.applicator.getPdbApplicatorOptions().getCompositeLayout(), this.applicator.getVbtManager(), this.applicator.getCancelOnlyWrappingMonitor());
    }

    private void reconstructionWarn(String msg, boolean hasHiddenComponents) {
        if (msg.contains("failed to align") && hasHiddenComponents) {
            msg = msg.replaceFirst("PDB", "PDB CLASS");
        }
        Msg.warn((Object)this, (Object)msg);
    }

    BigInteger getSize(AbstractCompositeMsType type) {
        AbstractCompositeMsType definition = this.getDefinitionType(type);
        return definition.getSize();
    }

    static final void clearComponents(Composite composite) {
        if (composite instanceof Structure) {
            ((Structure)composite).deleteAll();
        } else {
            while (composite.getNumComponents() > 0) {
                composite.delete(0);
            }
        }
    }

    private boolean hasHiddenComponents(FieldListTypeApplier.FieldLists lists) {
        return lists.methods().size() != 0 || lists.bases().size() != 0;
    }

    private void addClassTypeBaseClasses(Composite composite, CppCompositeType myClassType, List<AbstractMsType> msBases, AbstractMsType type) throws PdbException, CancelledException {
        AbstractCompositeMsType cType = (AbstractCompositeMsType)type;
        ClassFieldAttributes.Access defaultAccess = type instanceof AbstractClassMsType ? ClassFieldAttributes.Access.PRIVATE : ClassFieldAttributes.Access.PUBLIC;
        for (AbstractMsType baseType : msBases) {
            this.applicator.checkCancelled();
            MsTypeApplier baseApplier = this.applicator.getTypeApplier(baseType);
            if (!(baseApplier instanceof BaseClassTypeApplier)) {
                this.applicator.appendLogMsg(baseApplier.getClass().getSimpleName() + " seen where BaseClassTypeApplier expected for " + cType.getName());
                continue;
            }
            BaseClassTypeApplier baseTypeApplier = (BaseClassTypeApplier)baseApplier;
            if (baseType instanceof AbstractBaseClassMsType) {
                AbstractBaseClassMsType baseClassType = (AbstractBaseClassMsType)baseType;
                this.applyDirectBaseClass(baseClassType, myClassType, defaultAccess);
                continue;
            }
            if (baseType instanceof AbstractVirtualBaseClassMsType) {
                AbstractVirtualBaseClassMsType virtualBaseClassType = (AbstractVirtualBaseClassMsType)baseType;
                this.applyDirectVirtualBaseClass(virtualBaseClassType, myClassType, defaultAccess);
                continue;
            }
            if (baseType instanceof AbstractIndirectVirtualBaseClassMsType) {
                AbstractIndirectVirtualBaseClassMsType indirectVirtualBaseClassType = (AbstractIndirectVirtualBaseClassMsType)baseType;
                this.applyIndirectVirtualBaseClass(indirectVirtualBaseClassType, myClassType, defaultAccess);
                continue;
            }
            throw new AssertException("Unknown base class type: " + baseType.getClass().getSimpleName());
        }
    }

    private void applyDirectBaseClass(AbstractBaseClassMsType base, CppCompositeType myClassType, ClassFieldAttributes.Access defaultAccess) throws PdbException {
        CppCompositeType underlyingClassType = this.getUnderlyingClassType(base.getBaseClassRecordNumber());
        if (underlyingClassType == null) {
            return;
        }
        ClassFieldMsAttributes atts = base.getAttributes();
        int offset = this.applicator.bigIntegerToInt(base.getOffset());
        myClassType.addDirectBaseClass(underlyingClassType, ClassFieldAttributes.convert(atts, defaultAccess), offset);
    }

    private void applyDirectVirtualBaseClass(AbstractVirtualBaseClassMsType base, CppCompositeType myClassType, ClassFieldAttributes.Access defaultAccess) throws PdbException {
        CppCompositeType underlyingCt = this.getUnderlyingClassType(base.getBaseClassRecordNumber());
        if (underlyingCt == null) {
            return;
        }
        DataType vbtptr = this.getVirtualBaseTablePointerDataType(base.getVirtualBasePointerRecordNumber());
        ClassFieldMsAttributes atts = base.getAttributes();
        int basePointerOffset = this.applicator.bigIntegerToInt(base.getBasePointerOffset());
        int offsetFromVbt = this.applicator.bigIntegerToInt(base.getBaseOffsetFromVbt());
        myClassType.addDirectVirtualBaseClass(underlyingCt, ClassFieldAttributes.convert(atts, defaultAccess), basePointerOffset, vbtptr, offsetFromVbt);
    }

    private void applyIndirectVirtualBaseClass(AbstractIndirectVirtualBaseClassMsType base, CppCompositeType myClassType, ClassFieldAttributes.Access defaultAccess) throws PdbException {
        CppCompositeType underlyingCt = this.getUnderlyingClassType(base.getBaseClassRecordNumber());
        if (underlyingCt == null) {
            return;
        }
        DataType vbtptr = this.getVirtualBaseTablePointerDataType(base.getVirtualBasePointerRecordNumber());
        ClassFieldMsAttributes atts = base.getAttributes();
        int basePointerOffset = this.applicator.bigIntegerToInt(base.getBasePointerOffset());
        int offsetFromVbt = this.applicator.bigIntegerToInt(base.getBaseOffsetFromVbt());
        myClassType.addIndirectVirtualBaseClass(underlyingCt, ClassFieldAttributes.convert(atts, defaultAccess), basePointerOffset, vbtptr, offsetFromVbt);
    }

    private CppCompositeType getUnderlyingClassType(RecordNumber recordNumber) {
        AbstractMsType type = this.applicator.getTypeRecord(recordNumber);
        if (!(type instanceof AbstractCompositeMsType)) {
            this.applicator.appendLogMsg(type.getClass().getSimpleName() + " seen where Composite Type expected for base class.");
            return null;
        }
        AbstractCompositeMsType comp = (AbstractCompositeMsType)type;
        MsTypeApplier baseUnderlyingApplier = this.applicator.getTypeApplier(recordNumber);
        if (!(baseUnderlyingApplier instanceof CompositeTypeApplier)) {
            this.applicator.appendLogMsg(baseUnderlyingApplier.getClass().getSimpleName() + " seen where CompositeTypeApplier expected for base class.");
            return null;
        }
        CompositeTypeApplier baseApplier = (CompositeTypeApplier)baseUnderlyingApplier;
        CppCompositeType underlyingClassType = baseApplier.getClassType(type);
        if (underlyingClassType == null) {
            this.applicator.appendLogMsg("Underlying base class type is null.");
        }
        return underlyingClassType;
    }

    private DataType getVirtualBaseTablePointerDataType(RecordNumber recordNumber) throws PdbException {
        DataType dataType = this.applicator.getDataType(recordNumber);
        if (dataType == null) {
            throw new PdbException("Type not processed for record: " + String.valueOf(recordNumber));
        }
        return dataType;
    }

    private void addMembers(Composite composite, CppCompositeType myClassType, List<AbstractMemberMsType> msMembers, AbstractCompositeMsType type, List<DefaultPdbUniversalMember> myMembers) throws CancelledException, PdbException {
        ClassFieldAttributes.Access defaultAccess = type instanceof AbstractClassMsType ? ClassFieldAttributes.Access.PRIVATE : ClassFieldAttributes.Access.PUBLIC;
        for (int index = 0; index < msMembers.size(); ++index) {
            this.applicator.checkCancelled();
            AbstractMemberMsType memberType = msMembers.get(index);
            DefaultPdbUniversalMember member = this.getNonStaticMember(composite, defaultAccess, memberType, index);
            DataType dt = member.getDataType().getDataType();
            myMembers.add(member);
            myClassType.addMember(member.getName(), dt, member.isZeroLengthArray(), member.getAttributes(), member.getOffset(), member.getComment());
        }
    }

    private void addVftPtrs(Composite composite, CppCompositeType myClassType, List<AbstractVirtualFunctionTablePointerMsType> msVftPtrs, AbstractCompositeMsType type, List<DefaultPdbUniversalMember> myMembers) throws CancelledException, PdbException {
        for (AbstractVirtualFunctionTablePointerMsType vftPtr : msVftPtrs) {
            this.applicator.checkCancelled();
            RecordNumber recordNumber = vftPtr.getPointerTypeRecordNumber();
            DataType dataType = this.applicator.getDataType(recordNumber);
            if (dataType == null) {
                throw new PdbException("Type not processed for record: " + String.valueOf(recordNumber));
            }
            int offset = vftPtr.getOffset();
            String vftPtrMemberName = vftPtr.getName();
            DefaultPdbUniversalMember member = new DefaultPdbUniversalMember(vftPtrMemberName, dataType, offset);
            myMembers.add(member);
            myClassType.addVirtualFunctionTablePointer(member.getName(), member.getDataType().getDataType(), member.getOffset());
        }
    }

    private boolean precheckOrScheduleDependencies(FieldListTypeApplier.FieldLists lists) throws PdbException, CancelledException {
        DataType dt;
        RecordNumber recordNumber;
        boolean done = true;
        for (AbstractMsType base : lists.bases()) {
            DataType dt2;
            RecordNumber recordNumber2;
            this.applicator.checkCancelled();
            if (base instanceof AbstractBaseClassMsType) {
                AbstractBaseClassMsType bc = (AbstractBaseClassMsType)base;
                recordNumber2 = bc.getBaseClassRecordNumber();
                dt2 = this.applicator.getDataTypeOrSchedule(recordNumber2);
                if (dt2 != null) continue;
                done = false;
                continue;
            }
            if (base instanceof AbstractVirtualBaseClassMsType) {
                AbstractVirtualBaseClassMsType vbc = (AbstractVirtualBaseClassMsType)base;
                recordNumber2 = vbc.getVirtualBasePointerRecordNumber();
                dt2 = this.applicator.getDataTypeOrSchedule(recordNumber2);
                if (dt2 == null) {
                    done = false;
                }
                if ((dt2 = this.applicator.getDataTypeOrSchedule(recordNumber2 = vbc.getBaseClassRecordNumber())) != null) continue;
                done = false;
                continue;
            }
            if (base instanceof AbstractIndirectVirtualBaseClassMsType) {
                AbstractIndirectVirtualBaseClassMsType ivbc = (AbstractIndirectVirtualBaseClassMsType)base;
                recordNumber2 = ivbc.getVirtualBasePointerRecordNumber();
                dt2 = this.applicator.getDataTypeOrSchedule(recordNumber2);
                if (dt2 == null) {
                    done = false;
                }
                if ((dt2 = this.applicator.getDataTypeOrSchedule(recordNumber2 = ivbc.getBaseClassRecordNumber())) != null) continue;
                done = false;
                continue;
            }
            throw new PdbException("Unhandled type: " + base.getClass().getSimpleName());
        }
        for (AbstractMsType method : lists.methods()) {
            RecordNumber recordNumber3;
            this.applicator.checkCancelled();
            if (method instanceof AbstractOneMethodMsType) {
                AbstractOneMethodMsType oneMethod = (AbstractOneMethodMsType)method;
                recordNumber3 = oneMethod.getProcedureTypeRecordNumber();
                DataType dt3 = this.applicator.getDataTypeOrSchedule(recordNumber3);
                if (dt3 != null) continue;
                done = false;
                continue;
            }
            if (method instanceof AbstractOverloadedMethodMsType) {
                AbstractOverloadedMethodMsType overloadedMethod = (AbstractOverloadedMethodMsType)method;
                recordNumber3 = overloadedMethod.getTypeMethodListRecordNumber();
                AbstractMsType msType = this.applicator.getTypeRecord(recordNumber3);
                if (!(msType instanceof AbstractMethodListMsType)) continue;
                AbstractMethodListMsType methodList = (AbstractMethodListMsType)msType;
                List<AbstractMethodRecordMs> methodRecords = methodList.getList();
                for (AbstractMethodRecordMs methodRecord : methodRecords) {
                    recordNumber3 = methodRecord.getProcedureTypeRecordNumber();
                    DataType dt4 = this.applicator.getDataTypeOrSchedule(recordNumber3);
                    if (dt4 != null) continue;
                    done = false;
                }
                continue;
            }
            throw new PdbException("Unhandled type: " + method.getClass().getSimpleName());
        }
        for (AbstractMemberMsType nonstaticMember : lists.nonstaticMembers()) {
            this.applicator.checkCancelled();
            recordNumber = nonstaticMember.getFieldTypeRecordNumber();
            dt = this.applicator.getDataTypeOrSchedule(recordNumber);
            if (dt != null) continue;
            done = false;
        }
        for (AbstractStaticMemberMsType staticMember : lists.staticMembers()) {
            this.applicator.checkCancelled();
            recordNumber = staticMember.getFieldTypeRecordNumber();
            dt = this.applicator.getDataTypeOrSchedule(recordNumber);
            if (dt != null) continue;
            done = false;
        }
        for (AbstractVirtualFunctionTablePointerMsType msVftPtr : lists.vftPtrs()) {
            this.applicator.checkCancelled();
            recordNumber = msVftPtr.getPointerTypeRecordNumber();
            dt = this.applicator.getDataTypeOrSchedule(recordNumber);
            if (dt != null) continue;
            done = false;
        }
        return done;
    }

    private DefaultPdbUniversalMember getNonStaticMember(Composite container, ClassFieldAttributes.Access defaultAccess, AbstractMemberMsType memberMsType, int ordinal) throws CancelledException, PdbException {
        ArrayTypeApplier arrayApplier;
        MsTypeApplier applier = this.applicator.getTypeApplier(memberMsType);
        if (!(applier instanceof MemberTypeApplier)) {
            throw new PdbException("Member applier expected");
        }
        MemberTypeApplier memberApplier = (MemberTypeApplier)applier;
        String memberName = memberMsType.getName();
        int offset = this.applicator.bigIntegerToInt(memberMsType.getOffset());
        ClassFieldMsAttributes memberAttributes = memberMsType.getAttribute();
        memberAttributes.getAccess();
        RecordNumber typeRecordNumber = memberMsType.getFieldTypeRecordNumber();
        AbstractMsType fieldType = this.applicator.getTypeRecord(typeRecordNumber);
        MsTypeApplier fieldApplier = this.applicator.getTypeApplier(fieldType);
        String memberComment = null;
        RecordNumber fieldRecordNumber = memberMsType.getFieldTypeRecordNumber();
        DataType fieldDataType = this.applicator.getDataType(fieldRecordNumber);
        if (fieldDataType == null) {
            throw new PdbException("Type not processed for record: " + String.valueOf(fieldRecordNumber));
        }
        if (fieldApplier instanceof PointerTypeApplier) {
            PointerTypeApplier ptrApplier = (PointerTypeApplier)fieldApplier;
            AbstractPointerMsType pointerType = (AbstractPointerMsType)fieldType;
            memberComment = ptrApplier.getPointerCommentField(pointerType);
        }
        boolean isZeroLengthArray = fieldDataType instanceof Array && fieldApplier instanceof ArrayTypeApplier && (arrayApplier = (ArrayTypeApplier)fieldApplier).isFlexibleArray(fieldType);
        DefaultPdbUniversalMember member = new DefaultPdbUniversalMember(memberName, fieldDataType, isZeroLengthArray, offset, ClassFieldAttributes.convert(memberAttributes, defaultAccess), memberComment);
        return member;
    }

    private void processEnumerate(AbstractCompositeMsType type, EnumerateTypeApplier applier, AbstractEnumerateMsType enumerateType) {
        String fieldName = enumerateType.getName();
        Numeric numeric = enumerateType.getNumeric();
        this.pdbLogAndInfoMessage(this, "Don't know how to apply EnumerateTypeApplier fieldName " + fieldName + " and value " + String.valueOf(numeric) + ".");
    }

    private void processNestedType(AbstractCompositeMsType type, NestedTypeApplier nestedTypeApplier, AbstractMsType enumerateType) {
        String memberTypeName = enumerateType.getName();
        if (type.getName().equals(memberTypeName)) {
            // empty if block
        }
    }

    boolean apply(AbstractCompositeMsType type) throws CancelledException, PdbException {
        ComboType combo;
        RecordNumber recordNumber = type.getRecordNumber();
        AbstractMsType msType = this.applicator.getMappedTypeRecord(recordNumber);
        if (!(msType instanceof AbstractCompositeMsType)) {
            throw new PdbException("PDB processing error");
        }
        type = (AbstractCompositeMsType)msType;
        CppCompositeType myClassType = this.getClassType(type);
        if (myClassType == null) {
            combo = this.create(type);
            Composite composite = combo.dt();
            myClassType = combo.ct();
            this.applicator.putClassType(type, myClassType);
            this.applicator.putDataType(msType, (DataType)composite);
        } else {
            Composite composite = myClassType.getComposite();
            combo = new ComboType(composite, myClassType);
        }
        return this.applyInternal(combo, type);
    }

    private AbstractCompositeMsType getDefinitionType(AbstractComplexMsType type) {
        return this.getDefinitionType(type, AbstractCompositeMsType.class);
    }

    private record ComboType(Composite dt, CppCompositeType ct) {
    }
}

