/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb.DefaultCompositeMember;
import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.WrappedDataType;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.pdb.pdbapplicator.ClassFieldAttributes;
import ghidra.app.util.pdb.pdbapplicator.ObjectOrientedClassLayout;
import ghidra.app.util.pdb.pdbapplicator.PdbVbtManager;
import ghidra.app.util.pdb.pdbapplicator.VbtManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class CppCompositeType {
    private List<SyntacticBaseClass> syntacticBaseClasses;
    private List<LayoutBaseClass> layoutBaseClasses;
    private List<AbstractMember> myMembers;
    private List<Member> layoutMembers;
    private List<Member> layoutVftPtrMembers;
    private boolean isFinal;
    private Type type;
    private String className;
    private String mangledName;
    private int size;
    private SymbolPath symbolPath;
    private Composite composite;
    private CategoryPath categoryPath;
    private ObjectOrientedClassLayout classLayout = null;
    private List<ClassPdbMember> memberData;
    private boolean hasDirect;
    private Map<Integer, PlaceholderVirtualBaseTable> placeholderVirtualBaseTables;

    static String createDirectClassName(Composite composite) {
        return composite.getName() + "_direct";
    }

    static CategoryPath createDirectCategoryPath(CppCompositeType cppType) {
        return cppType.getBaseCategoryName(CppCompositeType.createDirectClassName(cppType.getComposite()));
    }

    public CppCompositeType(SymbolPath symbolPath, Composite composite, String mangledName) {
        Objects.requireNonNull(symbolPath, "symbolPath may not be null");
        Objects.requireNonNull(composite, "composite may not be null");
        this.syntacticBaseClasses = new ArrayList<SyntacticBaseClass>();
        this.layoutBaseClasses = new ArrayList<LayoutBaseClass>();
        this.myMembers = new ArrayList<AbstractMember>();
        this.layoutMembers = new ArrayList<Member>();
        this.memberData = new ArrayList<ClassPdbMember>();
        this.layoutVftPtrMembers = new ArrayList<Member>();
        this.isFinal = false;
        this.type = Type.UNKNOWN;
        this.symbolPath = symbolPath;
        this.composite = composite;
        this.placeholderVirtualBaseTables = new HashMap<Integer, PlaceholderVirtualBaseTable>();
        this.categoryPath = new CategoryPath(composite.getCategoryPath(), new String[]{composite.getName()});
        this.mangledName = mangledName;
    }

    public static CppClassType createCppClassType(SymbolPath symbolPath, Composite composite, String mangledName) {
        return new CppClassType(symbolPath, composite, mangledName);
    }

    public static CppClassType createCppClassType(SymbolPath symbolPath, Composite composite, String name, String mangledName, int size) {
        CppClassType cppType = new CppClassType(symbolPath, composite, mangledName);
        cppType.setName(name);
        cppType.setSize(size);
        return cppType;
    }

    public static CppStructType createCppStructType(SymbolPath symbolPath, Composite composite, String mangledName) {
        return new CppStructType(symbolPath, composite, mangledName);
    }

    public static CppStructType createCppStructType(SymbolPath symbolPath, Composite composite, String name, String mangledName, int size) {
        CppStructType cppType = new CppStructType(symbolPath, composite, mangledName);
        cppType.setName(name);
        cppType.setSize(size);
        return cppType;
    }

    static boolean validateMangledCompositeName(String mangledCompositeTypeName, Type type) {
        if (mangledCompositeTypeName == null) {
            return false;
        }
        if (!mangledCompositeTypeName.startsWith(".?")) {
            return false;
        }
        if (mangledCompositeTypeName.length() < 7) {
            return false;
        }
        if (mangledCompositeTypeName.charAt(2) != 'A') {
            PdbLog.message("Mangled composite type name not plain 'A'");
        }
        switch (mangledCompositeTypeName.charAt(3)) {
            case 'T': {
                if (type.compareTo(Type.UNION) == 0 || type.compareTo(Type.UNKNOWN) == 0) break;
                PdbLog.message("Warning: Mismatched complex type 'T' for " + String.valueOf((Object)type));
                break;
            }
            case 'U': {
                if (type.compareTo(Type.STRUCT) == 0 || type.compareTo(Type.UNKNOWN) == 0) break;
                PdbLog.message("Warning: Mismatched complex type 'U' for " + String.valueOf((Object)type));
                break;
            }
            case 'V': {
                if (type.compareTo(Type.CLASS) == 0 || type.compareTo(Type.UNKNOWN) == 0) break;
                PdbLog.message("Warning: Mismatched complex type 'V' for " + String.valueOf((Object)type));
                break;
            }
            default: {
                PdbLog.message("Not composite");
                return false;
            }
        }
        return true;
    }

    public boolean validate() {
        return !StringUtils.isEmpty((CharSequence)this.className) || this.isFinal;
    }

    private List<LayoutBaseClass> getLayoutBaseClasses() {
        return this.layoutBaseClasses;
    }

    SymbolPath getSymbolPath() {
        return this.symbolPath;
    }

    Composite getComposite() {
        return this.composite;
    }

    private CategoryPath getCategoryPath() {
        return this.categoryPath;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setClass() {
        this.type = Type.CLASS;
    }

    public void setStruct() {
        this.type = Type.STRUCT;
    }

    public void setUnion() {
        this.type = Type.UNION;
    }

    public Type getType() {
        return this.type;
    }

    public void setName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.className;
    }

    public void setMangledName(String mangledName) {
        this.mangledName = mangledName;
    }

    public String getMangledName() {
        return this.mangledName;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumMembers() {
        return this.myMembers.size();
    }

    public int getNumLayoutMembers() {
        return this.layoutMembers.size();
    }

    public void addVirtualFunctionTablePointer(String name, DataType dataType, int offset) {
        Member newMember = new Member(this, name, dataType, false, ClassFieldAttributes.UNKNOWN, offset);
        this.layoutVftPtrMembers.add(newMember);
    }

    private void insertVirtualFunctionTablePointers(List<ClassPdbMember> pdbMembers) {
        for (Member vftPtrMember : this.layoutVftPtrMembers) {
            ClassPdbMember vftPtrPdbMember = new ClassPdbMember(vftPtrMember.getName(), vftPtrMember.getDataType(), vftPtrMember.isFlexibleArray(), vftPtrMember.getOffset(), vftPtrMember.getComment());
            int index = 0;
            for (ClassPdbMember member : pdbMembers) {
                if (member.getOffset() > vftPtrMember.getOffset()) break;
                ++index;
            }
            pdbMembers.add(index, vftPtrPdbMember);
        }
    }

    public void addMember(String memberName, DataType dataType, boolean isFlexibleArray, int offset, String comment) {
        this.addMember(memberName, dataType, isFlexibleArray, ClassFieldAttributes.UNKNOWN, offset, comment);
    }

    public void addMember(String memberName, DataType dataType, boolean isFlexibleArray, int offset) {
        this.addMember(memberName, dataType, isFlexibleArray, ClassFieldAttributes.UNKNOWN, offset, null);
    }

    public void addMember(String memberName, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, int offset) {
        Member newMember = new Member(this, memberName, dataType, isFlexibleArray, attributes, offset);
        this.myMembers.add(newMember);
        this.addMember(this.layoutMembers, newMember);
    }

    public void addMember(String memberName, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, int offset, String comment) {
        Member newMember = new Member(this, memberName, dataType, isFlexibleArray, attributes, offset, comment);
        this.myMembers.add(newMember);
        this.addMember(this.layoutMembers, newMember);
    }

    private void addMember(List<Member> members, Member newMember) {
        members.add(newMember);
    }

    public void insertMember(String memberName, DataType dataType, boolean isFlexibleArray, int offset, String comment) {
        this.insertMember(memberName, dataType, isFlexibleArray, ClassFieldAttributes.UNKNOWN, offset, comment);
    }

    public void insertMember(String memberName, DataType dataType, boolean isFlexibleArray, int offset) {
        this.insertMember(memberName, dataType, isFlexibleArray, ClassFieldAttributes.UNKNOWN, offset, null);
    }

    public void insertMember(String memberName, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, int offset) {
        Member newMember = new Member(this, memberName, dataType, isFlexibleArray, attributes, offset);
        this.myMembers.add(newMember);
        this.insertMember(this.layoutMembers, newMember);
    }

    public void insertMember(String memberName, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, int offset, String comment) {
        Member newMember = new Member(this, memberName, dataType, isFlexibleArray, attributes, offset, comment);
        this.myMembers.add(newMember);
        this.insertMember(this.layoutMembers, newMember);
    }

    private void insertMember(List<Member> members, Member newMember) {
        int index = 0;
        for (Member member : members) {
            if (member.getOffset() > newMember.getOffset()) break;
            ++index;
        }
        members.add(index, newMember);
    }

    public void addStaticMember(String memberName, DataType dataType) {
        this.addStaticMember(memberName, dataType, ClassFieldAttributes.UNKNOWN);
    }

    public void addStaticMember(String memberName, DataType dataType, ClassFieldAttributes attributes) {
        this.myMembers.add(new StaticMember(this, memberName, dataType, attributes));
    }

    public int getNumLayoutBaseClasses() {
        return this.layoutBaseClasses.size();
    }

    public int getNumLayoutVirtualBaseClasses() {
        int num = 0;
        for (LayoutBaseClass base : this.layoutBaseClasses) {
            if (!(base instanceof DirectLayoutBaseClass)) continue;
            ++num;
        }
        return this.layoutBaseClasses.size() - num;
    }

    public int getNumSyntacticBaseClasses() {
        return this.syntacticBaseClasses.size();
    }

    public void addSyntacticBaseClass(CppCompositeType baseClassType) throws PdbException {
        this.addSyntacticBaseClass(baseClassType, ClassFieldAttributes.UNKNOWN);
    }

    public void addSyntacticBaseClass(CppCompositeType baseClassType, ClassFieldAttributes attributes) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        this.syntacticBaseClasses.add(new SyntacticBaseClass(this, baseClassType, attributes));
    }

    public void addDirectSyntacticBaseClass(CppCompositeType baseClassType) throws PdbException {
        this.addDirectSyntacticBaseClass(baseClassType, ClassFieldAttributes.UNKNOWN);
    }

    public void addDirectSyntacticBaseClass(CppCompositeType baseClassType, ClassFieldAttributes attributes) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        this.syntacticBaseClasses.add(new DirectSyntacticBaseClass(this, baseClassType, attributes));
    }

    public void addVirtualSyntacticBaseClass(CppCompositeType baseClassType) throws PdbException {
        this.addVirtualSyntacticBaseClass(baseClassType, ClassFieldAttributes.UNKNOWN);
    }

    public void addVirtualSyntacticBaseClass(CppCompositeType baseClassType, ClassFieldAttributes attributes) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        this.syntacticBaseClasses.add(new VirtualSyntacticBaseClass(this, baseClassType, attributes));
    }

    public void insertSyntacticBaseClass(CppCompositeType baseClassType, int ordinal) throws PdbException {
        this.insertSyntacticBaseClass(baseClassType, ClassFieldAttributes.UNKNOWN, ordinal);
    }

    public void insertSyntacticBaseClass(CppCompositeType baseClassType, ClassFieldAttributes attributes, int ordinal) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        if (ordinal < 0 || ordinal > this.getNumSyntacticBaseClasses()) {
            throw new PdbException("Invalid base class insertion index.");
        }
        this.syntacticBaseClasses.add(ordinal, new SyntacticBaseClass(this, baseClassType, attributes));
    }

    public void insertDirectSyntacticBaseClass(CppCompositeType baseClassType, int ordinal) throws PdbException {
        this.insertDirectSyntacticBaseClass(baseClassType, ClassFieldAttributes.UNKNOWN, ordinal);
    }

    public void insertDirectSyntacticBaseClass(CppCompositeType baseClassType, ClassFieldAttributes attributes, int ordinal) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        if (ordinal < 0 || ordinal > this.getNumSyntacticBaseClasses()) {
            throw new PdbException("Invalid base class insertion index.");
        }
        this.syntacticBaseClasses.add(ordinal, new DirectSyntacticBaseClass(this, baseClassType, attributes));
    }

    public void insertVirtualSyntacticBaseClass(CppCompositeType baseClassType, int ordinal) throws PdbException {
        this.insertVirtualSyntacticBaseClass(baseClassType, ClassFieldAttributes.UNKNOWN, ordinal);
    }

    public void insertVirtualSyntacticBaseClass(CppCompositeType baseClassType, ClassFieldAttributes attributes, int ordinal) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        if (ordinal < 0 || ordinal > this.getNumSyntacticBaseClasses()) {
            throw new PdbException("Invalid base class insertion index.");
        }
        this.syntacticBaseClasses.add(ordinal, new VirtualSyntacticBaseClass(this, baseClassType, attributes));
    }

    public void addDirectBaseClass(CppCompositeType baseClassType, int offset) throws PdbException {
        this.addDirectBaseClass(baseClassType, ClassFieldAttributes.UNKNOWN, offset);
    }

    public void addDirectBaseClass(CppCompositeType baseClassType, ClassFieldAttributes attributes, int offset) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        this.layoutBaseClasses.add(new DirectLayoutBaseClass(this, baseClassType, attributes, offset));
    }

    public void addDirectVirtualBaseClass(CppCompositeType baseClassType, int basePointerOffset, DataType vbptr, int offsetFromVbt) throws PdbException {
        this.addDirectVirtualBaseClass(baseClassType, ClassFieldAttributes.UNKNOWN, basePointerOffset, vbptr, offsetFromVbt);
    }

    public void addDirectVirtualBaseClass(CppCompositeType baseClassType, ClassFieldAttributes attributes, int basePointerOffset, DataType vbptr, int offsetFromVbt) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        this.layoutBaseClasses.add(new DirectVirtualLayoutBaseClass(this, baseClassType, attributes, basePointerOffset, vbptr, offsetFromVbt));
    }

    public void addIndirectVirtualBaseClass(CppCompositeType baseClassType, int basePointerOffset, DataType vbptr, int offsetFromVbt) throws PdbException {
        this.addIndirectVirtualBaseClass(baseClassType, ClassFieldAttributes.UNKNOWN, basePointerOffset, vbptr, offsetFromVbt);
    }

    public void addIndirectVirtualBaseClass(CppCompositeType baseClassType, ClassFieldAttributes attributes, int basePointerOffset, DataType vbptr, int offsetFromVbt) throws PdbException {
        CppCompositeType.validateBaseClass(baseClassType);
        this.layoutBaseClasses.add(new IndirectVirtualLayoutBaseClass(this, baseClassType, attributes, basePointerOffset, vbptr, offsetFromVbt));
    }

    private static void validateBaseClass(CppCompositeType baseClassType) throws PdbException {
        if (baseClassType.isFinal) {
            throw new PdbException("Cannot inherit base class marked final.");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.type);
        builder.append(this.className);
        if (this.isFinal) {
            builder.append(" final");
        }
        StringBuilder baseBuilder = new StringBuilder();
        for (BaseClass baseClass : this.syntacticBaseClasses) {
            if (baseBuilder.length() == 0) {
                baseBuilder.append(" : ");
            } else {
                baseBuilder.append(", ");
            }
            baseBuilder.append(baseClass);
        }
        builder.append((CharSequence)baseBuilder);
        return builder.toString();
    }

    public ObjectOrientedClassLayout getLayout(ObjectOrientedClassLayout layoutOptions) {
        if (this.classLayout == null) {
            this.classLayout = this.determineClassLayout(layoutOptions);
        }
        return this.classLayout;
    }

    private ObjectOrientedClassLayout determineClassLayout(ObjectOrientedClassLayout layoutOptions) {
        if (layoutOptions == ObjectOrientedClassLayout.MEMBERS_ONLY) {
            return ObjectOrientedClassLayout.MEMBERS_ONLY;
        }
        ObjectOrientedClassLayout initialLayoutDetermination = this.getNumLayoutBaseClasses() == 0 ? ObjectOrientedClassLayout.BASIC_SIMPLE_COMPLEX : (this.getNumLayoutVirtualBaseClasses() == 0 ? ObjectOrientedClassLayout.SIMPLE_COMPLEX : ObjectOrientedClassLayout.COMPLEX);
        ObjectOrientedClassLayout classLayoutOption = layoutOptions;
        return classLayoutOption.compareTo(initialLayoutDetermination) >= 0 ? classLayoutOption : initialLayoutDetermination;
    }

    boolean isZeroSize() {
        return this.memberData.size() == 0;
    }

    public void createLayoutFromSyntacticDescription(VbtManager vbtManager, TaskMonitor monitor) {
        for (SyntacticBaseClass base : this.syntacticBaseClasses) {
            if (!(base instanceof DirectSyntacticBaseClass)) continue;
        }
    }

    public void createLayout(ObjectOrientedClassLayout layoutOptions, VbtManager vbtManager, TaskMonitor monitor) throws PdbException, CancelledException {
        if (vbtManager instanceof PdbVbtManager) {
            this.createVbtBasedLayout(layoutOptions, vbtManager, monitor);
        } else {
            this.createSpeculativeLayout(layoutOptions, vbtManager, monitor);
        }
    }

    public void createVbtBasedLayout(ObjectOrientedClassLayout layoutOptions, VbtManager vbtManager, TaskMonitor monitor) throws PdbException, CancelledException {
        this.hasDirect = false;
        switch (this.getLayout(layoutOptions)) {
            case MEMBERS_ONLY: {
                this.addLayoutPdbMembers(this.memberData, this.layoutMembers);
                break;
            }
            case BASIC_SIMPLE_COMPLEX: {
                this.addLayoutPdbMembers(this.memberData, this.layoutMembers);
                this.insertVirtualFunctionTablePointers(this.memberData);
                break;
            }
            case SIMPLE_COMPLEX: 
            case COMPLEX: {
                int directClassLength;
                CategoryPath cn = CppCompositeType.createDirectCategoryPath(this);
                StructureDataType directDataType = new StructureDataType(cn.getParent(), cn.getName(), 0, this.composite.getDataTypeManager());
                List<ClassPdbMember> directClassPdbMembers = this.getDirectBaseClassMembers(monitor);
                List<VirtualLayoutBaseClass> myVirtualLayoutBases = this.preprocessVirtualBases(monitor);
                boolean allVbtFound = this.reconcileVirtualBaseTables(this.composite.getDataTypeManager(), vbtManager);
                this.addLayoutPdbMembers(directClassPdbMembers, this.layoutMembers);
                this.insertVirtualFunctionTablePointers(directClassPdbMembers);
                if (!DefaultCompositeMember.applyDataTypeMembers((Composite)directDataType, false, 0, directClassPdbMembers, msg -> Msg.warn((Object)this, (Object)msg), monitor)) {
                    CppCompositeType.clearComponents((Composite)directDataType);
                }
                if ((directClassLength = this.getCompositeLength((Composite)directDataType)) == 0) {
                    directDataType.getDataTypeManager().remove((DataType)directDataType, monitor);
                } else {
                    if (directClassLength > this.size) {
                        directDataType.getDataTypeManager().remove((DataType)directDataType, monitor);
                        directDataType = new StructureDataType(cn.getParent(), cn.getName(), 0, this.composite.getDataTypeManager());
                        if (!DefaultCompositeMember.applyDataTypeMembers((Composite)directDataType, false, this.size, directClassPdbMembers, msg -> Msg.warn((Object)this, (Object)msg), monitor)) {
                            CppCompositeType.clearComponents((Composite)directDataType);
                        }
                        directClassLength = this.getCompositeLength((Composite)directDataType);
                    }
                    if (this.getLayout(layoutOptions) == ObjectOrientedClassLayout.SIMPLE_COMPLEX) {
                        directDataType.getDataTypeManager().remove((DataType)directDataType, monitor);
                        this.memberData.addAll(directClassPdbMembers);
                    } else {
                        ClassPdbMember directClassPdbMember = new ClassPdbMember("", (DataType)directDataType, false, 0, null);
                        this.memberData.add(directClassPdbMember);
                        this.hasDirect = true;
                    }
                }
                this.addVirtualBases(directClassLength, this.memberData, myVirtualLayoutBases, allVbtFound, monitor);
                break;
            }
            default: {
                throw new PdbException("Unhandled layout mode");
            }
        }
        if (!DefaultCompositeMember.applyDataTypeMembers(this.composite, false, this.size, this.memberData, msg -> Msg.warn((Object)this, (Object)msg), monitor)) {
            CppCompositeType.clearComponents(this.composite);
        }
    }

    private List<ClassPdbMember> getDirectBaseClassMembers(TaskMonitor monitor) throws CancelledException {
        ArrayList<ClassPdbMember> myDirectClassPdbMembers = new ArrayList<ClassPdbMember>();
        TreeMap<Integer, Member> orderedBaseMembers = new TreeMap<Integer, Member>();
        for (LayoutBaseClass base : this.getLayoutBaseClasses()) {
            monitor.checkCancelled();
            CppCompositeType baseComposite = base.getBaseClassType();
            if (!(base instanceof DirectLayoutBaseClass) || baseComposite.isZeroSize()) continue;
            Composite baseDataType = base.getDirectDataType();
            int offset = ((DirectLayoutBaseClass)base).getOffset();
            CategoryPath cn = this.getBaseCategoryName("BaseClass_" + base.getBaseClassType().getName());
            Member baseMember = new Member(this, "", (DataType)baseDataType, false, null, offset, cn.toString());
            orderedBaseMembers.put(offset, baseMember);
        }
        for (Member baseMember : orderedBaseMembers.values()) {
            this.addPdbMember(myDirectClassPdbMembers, baseMember);
        }
        return myDirectClassPdbMembers;
    }

    private List<VirtualLayoutBaseClass> preprocessVirtualBases(TaskMonitor monitor) throws CancelledException, PdbException {
        ArrayList<VirtualLayoutBaseClass> myVirtualLayoutBases = new ArrayList<VirtualLayoutBaseClass>();
        for (LayoutBaseClass base : this.getLayoutBaseClasses()) {
            monitor.checkCancelled();
            if (!(base instanceof VirtualLayoutBaseClass)) continue;
            this.addPlaceholderVirtualBaseTableEntry((VirtualLayoutBaseClass)base);
            myVirtualLayoutBases.add((VirtualLayoutBaseClass)base);
        }
        return myVirtualLayoutBases;
    }

    public void createSpeculativeLayout(ObjectOrientedClassLayout layoutOptions, VbtManager vbtManager, TaskMonitor monitor) throws PdbException, CancelledException {
        this.hasDirect = false;
        switch (this.getLayout(layoutOptions)) {
            case MEMBERS_ONLY: {
                this.addLayoutPdbMembers(this.memberData, this.layoutMembers);
                break;
            }
            case BASIC_SIMPLE_COMPLEX: {
                CategoryPath cn = this.composite.getCategoryPath();
                this.addLayoutPdbMembers(this.memberData, this.layoutMembers);
                this.insertVirtualFunctionTablePointers(this.memberData);
                break;
            }
            case SIMPLE_COMPLEX: 
            case COMPLEX: {
                int directClassLength;
                CategoryPath cn = CppCompositeType.createDirectCategoryPath(this);
                StructureDataType directDataType = new StructureDataType(cn.getParent(), cn.getName(), 0, this.composite.getDataTypeManager());
                ArrayList<LayoutBaseClass> myAccumulatedDirectBases = new ArrayList<LayoutBaseClass>();
                ArrayList<VirtualLayoutBaseClass> myAccumulatedVirtualBases = new ArrayList<VirtualLayoutBaseClass>();
                ArrayList<ClassPdbMember> directClassPdbMembers = new ArrayList<ClassPdbMember>();
                this.processBaseClassesRecursive(this, true, directClassPdbMembers, myAccumulatedDirectBases, myAccumulatedVirtualBases, 0, monitor);
                boolean allVbtFound = this.reconcileVirtualBaseTables(this.composite.getDataTypeManager(), vbtManager);
                this.addLayoutPdbMembers(directClassPdbMembers, this.layoutMembers);
                this.insertVirtualFunctionTablePointers(directClassPdbMembers);
                if (!DefaultCompositeMember.applyDataTypeMembers((Composite)directDataType, false, 0, directClassPdbMembers, msg -> Msg.warn((Object)this, (Object)msg), monitor)) {
                    CppCompositeType.clearComponents((Composite)directDataType);
                }
                if ((directClassLength = this.getCompositeLength((Composite)directDataType)) == 0) {
                    directDataType.getDataTypeManager().remove((DataType)directDataType, monitor);
                } else {
                    if (directClassLength > this.size) {
                        directDataType.getDataTypeManager().remove((DataType)directDataType, monitor);
                        directDataType = new StructureDataType(cn.getParent(), cn.getName(), 0, this.composite.getDataTypeManager());
                        if (!DefaultCompositeMember.applyDataTypeMembers((Composite)directDataType, false, this.size, directClassPdbMembers, msg -> Msg.warn((Object)this, (Object)msg), monitor)) {
                            CppCompositeType.clearComponents((Composite)directDataType);
                        }
                        directClassLength = this.getCompositeLength((Composite)directDataType);
                    }
                    if (this.getLayout(layoutOptions) == ObjectOrientedClassLayout.SIMPLE_COMPLEX) {
                        directDataType.getDataTypeManager().remove((DataType)directDataType, monitor);
                        this.memberData.addAll(directClassPdbMembers);
                    } else {
                        ClassPdbMember directClassPdbMember = new ClassPdbMember("", (DataType)directDataType, false, 0, null);
                        this.memberData.add(directClassPdbMember);
                        this.hasDirect = true;
                    }
                }
                this.addVirtualBasesSpeculatively(directClassLength, this.memberData, myAccumulatedVirtualBases, monitor);
                break;
            }
            default: {
                throw new PdbException("Unhandled layout mode");
            }
        }
        if (!DefaultCompositeMember.applyDataTypeMembers(this.composite, false, this.size, this.memberData, msg -> Msg.warn((Object)this, (Object)msg), monitor)) {
            CppCompositeType.clearComponents(this.composite);
        }
    }

    private void processBaseClassesRecursive(CppCompositeType cppType, boolean isDirect, List<ClassPdbMember> myPdbMembers, List<LayoutBaseClass> myAccumulatedDirectBases, List<VirtualLayoutBaseClass> myAccumulatedVirtualBases, int depth, TaskMonitor monitor) throws PdbException, CancelledException {
        ++depth;
        for (LayoutBaseClass base : cppType.getLayoutBaseClasses()) {
            monitor.checkCancelled();
            CppCompositeType baseComposite = base.getBaseClassType();
            if (base instanceof DirectLayoutBaseClass) {
                if (isDirect) {
                    if (CppCompositeType.alreadyAccumulatedByName(myAccumulatedDirectBases, base)) {
                        throw new PdbException("Direct base already seen: " + base.getBaseClassType().getName());
                    }
                    if (!baseComposite.isZeroSize()) {
                        Composite baseDataType = base.getDirectDataType();
                        int offset = ((DirectLayoutBaseClass)base).getOffset();
                        CategoryPath cn = this.getBaseCategoryName("BaseClass_" + base.getBaseClassType().getName());
                        Member baseMember = new Member(this, "", (DataType)baseDataType, false, null, offset, cn.toString());
                        this.addPdbMember(myPdbMembers, baseMember);
                    }
                    myAccumulatedDirectBases.add(base);
                }
                this.processBaseClassesRecursive(baseComposite, false, myPdbMembers, myAccumulatedDirectBases, myAccumulatedVirtualBases, depth, monitor);
                continue;
            }
            if (base instanceof VirtualLayoutBaseClass) {
                if (depth == 1) {
                    this.addPlaceholderVirtualBaseTableEntry((VirtualLayoutBaseClass)base);
                }
                if (CppCompositeType.alreadyAccumulatedByName(myAccumulatedVirtualBases, base)) continue;
                if (!baseComposite.isZeroSize()) {
                    this.processBaseClassesRecursive(baseComposite, false, myPdbMembers, myAccumulatedDirectBases, myAccumulatedVirtualBases, depth, monitor);
                }
                myAccumulatedVirtualBases.add((VirtualLayoutBaseClass)base);
                continue;
            }
            throw new PdbException("Unknown base class type");
        }
    }

    void addPlaceholderVirtualBaseTableEntry(VirtualLayoutBaseClass base) throws PdbException {
        PlaceholderVirtualBaseTableEntry entry;
        PlaceholderVirtualBaseTable table = this.placeholderVirtualBaseTables.get(base.getBasePointerOffset());
        if (table == null) {
            table = new PlaceholderVirtualBaseTable();
            this.placeholderVirtualBaseTables.put(base.getBasePointerOffset(), table);
        }
        if ((entry = table.getEntryByIndexInTable(base.getOffetFromVbt())) != null) {
            throw new PdbException("Entry already exists at offset (" + base.getOffetFromVbt() + "): " + String.valueOf(entry));
        }
        entry = new PlaceholderVirtualBaseTableEntry(base);
        table.addEntry(base.getOffetFromVbt(), entry);
    }

    PlaceholderVirtualBaseTable getPlaceholderVirtualBaseTable(int basePointerOffset) {
        return this.placeholderVirtualBaseTables.get(basePointerOffset);
    }

    Map<Integer, PlaceholderVirtualBaseTable> getPlaceholderVirtualBaseTables() {
        return this.placeholderVirtualBaseTables;
    }

    private boolean reconcileVirtualBaseTables(DataTypeManager dtm, VbtManager vbtManager) throws PdbException {
        if (this.placeholderVirtualBaseTables.size() > 1) {
            // empty if block
        }
        boolean allVbtFound = true;
        for (Map.Entry<Integer, PlaceholderVirtualBaseTable> tableEntry : this.placeholderVirtualBaseTables.entrySet()) {
            int vbtptrOffset = tableEntry.getKey();
            PlaceholderVirtualBaseTable table = tableEntry.getValue();
            if (!table.validateOffset()) {
                // empty if block
            }
            DataType vbptr = this.getVbptrDataType(dtm, vbtManager, table);
            allVbtFound &= this.addOrUpdateVbtAndVbtptrMember(vbtManager, table, vbptr, vbtptrOffset, this.getName());
        }
        return allVbtFound;
    }

    private DataType getVbptrDataType(DataTypeManager dtm, VbtManager vbtManager, PlaceholderVirtualBaseTable table) {
        PlaceholderVirtualBaseTableEntry entry;
        PointerDataType vbptr = null;
        for (int index = 1; index < table.getMaxOffset() && (vbptr = (entry = table.getEntryByIndexInTable(index)).getVirtualBaseClass().getVbptr()) == null; ++index) {
        }
        if (vbptr == null) {
            vbptr = vbtManager.getFallbackVbptr();
        }
        return vbptr;
    }

    private boolean addOrUpdateVbtAndVbtptrMember(VbtManager vbtManager, PlaceholderVirtualBaseTable table, DataType vbptr, int vbtptrOffset, String myClass) throws PdbException {
        ArrayList<String> subMangled = new ArrayList<String>();
        CppCompositeAndMember cAndM = this.findDirectBaseCompositeAndMember(this, 0, vbtptrOffset);
        if (cAndM == null) {
            this.insertMember("{vbptr}", vbptr, false, vbtptrOffset, "{vbptr} for " + myClass);
        } else {
            if (!"{vbptr}".equals(cAndM.getMember().getName())) {
                String message = "PDB: Collision of non-{vbptr}.";
                PdbLog.message(message);
                Msg.info((Object)this, (Object)message);
                return false;
            }
            CppCompositeType compositeThatContainsMember = cAndM.getComposite();
            String mangled = compositeThatContainsMember.getMangledName();
            subMangled.add(mangled);
        }
        if (!(vbtManager instanceof PdbVbtManager)) {
            return false;
        }
        int entrySize = 4;
        if (vbptr instanceof PointerDataType) {
            entrySize = ((PointerDataType)vbptr).getDataType().getLength();
        }
        return this.findVbtBySymbolConstruction(table, (PdbVbtManager)vbtManager, entrySize, this.getMangledName(), this.type, subMangled);
    }

    private boolean findVbtBySymbolConstruction(PlaceholderVirtualBaseTable table, PdbVbtManager vbtm, int entrySize, String mangledCompositeTypeName, Type mainType, List<String> subMangledCompositeTypeNames) {
        if (!CppCompositeType.validateMangledCompositeName(mangledCompositeTypeName, mainType)) {
            return false;
        }
        for (String mangled : subMangledCompositeTypeNames) {
            if (CppCompositeType.validateMangledCompositeName(mangled, Type.UNKNOWN)) continue;
            return false;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("??_8");
        builder.append(mangledCompositeTypeName.substring(4));
        builder.append("7B");
        builder.append("@");
        String possibleName = builder.toString();
        if (this.findAndUpdate(table, vbtm, entrySize, possibleName)) {
            return true;
        }
        for (String mangled : subMangledCompositeTypeNames) {
            builder.deleteCharAt(builder.length() - 1);
            builder.append(mangled.substring(4));
            builder.append("@");
            possibleName = builder.toString();
            if (!this.findAndUpdate(table, vbtm, entrySize, possibleName)) continue;
            return true;
        }
        return false;
    }

    boolean findAndUpdate(PlaceholderVirtualBaseTable table, PdbVbtManager vbtm, int entrySize, String mangledTableName) {
        PdbVbtManager.PdbVirtualBaseTable vbt = vbtm.createVirtualBaseTableByName(mangledTableName, entrySize);
        if (vbt == null) {
            return false;
        }
        table.setName(mangledTableName);
        table.setVirtualBaseTable(vbt);
        return true;
    }

    private CppCompositeAndMember findDirectBaseCompositeAndMember(CppCompositeType cppType, int offsetCppType, int vbtptrOffset) throws PdbException {
        for (LayoutBaseClass base : cppType.layoutBaseClasses) {
            if (!(base instanceof DirectLayoutBaseClass)) continue;
            DirectLayoutBaseClass directBase = (DirectLayoutBaseClass)base;
            int directBaseOffset = directBase.getOffset() + offsetCppType;
            int directBaseLength = directBase.getDirectDataType().getLength();
            if (vbtptrOffset < directBaseOffset || vbtptrOffset >= directBaseOffset + directBaseLength) continue;
            CppCompositeType childCppType = directBase.getBaseClassType();
            CppCompositeAndMember cAndM = this.findDirectBaseCompositeAndMember(childCppType, directBaseOffset, vbtptrOffset);
            if (cAndM == null) {
                Member member = childCppType.findLayoutMemberOrVftPtrMember(vbtptrOffset);
                if (member == null) {
                    return null;
                }
                cAndM = new CppCompositeAndMember(this, childCppType, member);
            }
            return cAndM;
        }
        return null;
    }

    private Member findLayoutMemberOrVftPtrMember(int offset) {
        for (Member member : this.layoutMembers) {
            if (member.getOffset() != offset) continue;
            return member;
        }
        for (Member member : this.layoutVftPtrMembers) {
            if (member.getOffset() != offset) continue;
            return member;
        }
        return null;
    }

    private void addVirtualBases(int startOffset, List<ClassPdbMember> pdbMembers, List<VirtualLayoutBaseClass> virtualBases, boolean allVbtFound, TaskMonitor monitor) throws PdbException, CancelledException {
        Object accumulatedComment = "";
        int memberOffset = startOffset;
        ArrayList<VirtualLayoutBaseClass> orderedBases = new ArrayList<VirtualLayoutBaseClass>();
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        if (!this.orderVirtualBases(orderedBases, offsets, virtualBases, monitor)) {
            this.addVirtualBasesSpeculatively(startOffset, pdbMembers, virtualBases, monitor);
            return;
        }
        for (int index = 0; index < offsets.size(); ++index) {
            String comment;
            monitor.checkCancelled();
            VirtualLayoutBaseClass virtualBase = (VirtualLayoutBaseClass)orderedBases.get(index);
            memberOffset = (Integer)offsets.get(index);
            Composite baseDataType = virtualBase.getDirectDataType();
            int virtualBaseLength = this.getCompositeLength(baseDataType);
            int basePointerOffset = virtualBase.getBasePointerOffset();
            memberOffset += basePointerOffset;
            if (virtualBaseLength != 0) {
                comment = "(Virtual Base " + virtualBase.getDataTypePath().getDataTypeName() + ")";
                accumulatedComment = (String)accumulatedComment + comment;
                ClassPdbMember virtualClassPdbMember = new ClassPdbMember("", (DataType)baseDataType, false, memberOffset, (String)accumulatedComment);
                pdbMembers.add(virtualClassPdbMember);
                memberOffset += virtualBaseLength;
                accumulatedComment = "";
                continue;
            }
            comment = "(Virtual Base (empty) " + virtualBase.getDataTypePath().getDataTypeName() + ")";
            accumulatedComment = (String)accumulatedComment + comment;
        }
    }

    private boolean orderVirtualBases(List<VirtualLayoutBaseClass> ordered, List<Integer> offsets, List<VirtualLayoutBaseClass> unordered, TaskMonitor monitor) throws PdbException, CancelledException {
        for (VirtualLayoutBaseClass insertBase : unordered) {
            int existingOffset;
            int index;
            monitor.checkCancelled();
            PlaceholderVirtualBaseTable pvbt = this.getPlaceholderVirtualBaseTable(insertBase.getBasePointerOffset());
            if (pvbt == null || !pvbt.canLookupOffset()) {
                return false;
            }
            long offset = pvbt.getOffset(insertBase.getOffetFromVbt());
            int memberOffset = (int)(offset & 0xFFFFFFFFL);
            for (index = 0; index < offsets.size() && (existingOffset = offsets.get(index).intValue()) <= memberOffset; ++index) {
            }
            ordered.add(index, insertBase);
            offsets.add(index, memberOffset);
        }
        return true;
    }

    private void addVirtualBasesSpeculatively(int startOffset, List<ClassPdbMember> pdbMembers, List<VirtualLayoutBaseClass> virtualBases, TaskMonitor monitor) throws CancelledException {
        Object accumulatedComment = "";
        int memberOffset = startOffset;
        for (VirtualLayoutBaseClass virtualBase : virtualBases) {
            String comment;
            monitor.checkCancelled();
            Composite baseDataType = virtualBase.getDirectDataType();
            int virtualBaseLength = this.getCompositeLength(baseDataType);
            if (virtualBaseLength != 0) {
                comment = "((Speculative Placement) Virtual Base " + virtualBase.getDataTypePath().getDataTypeName() + ")";
                accumulatedComment = (String)accumulatedComment + comment;
                ClassPdbMember virtualClassPdbMember = new ClassPdbMember("", (DataType)baseDataType, false, memberOffset, (String)accumulatedComment);
                pdbMembers.add(virtualClassPdbMember);
                memberOffset += virtualBaseLength;
                accumulatedComment = "";
                continue;
            }
            comment = "((empty) (Speculative Placement) Virtual Base " + virtualBase.getDataTypePath().getDataTypeName() + ")";
            accumulatedComment = (String)accumulatedComment + comment;
        }
    }

    private void addLayoutPdbMembers(List<ClassPdbMember> pdbMembers, List<Member> members) {
        for (Member member : members) {
            this.addPdbMember(pdbMembers, member);
        }
    }

    void addPdbMember(List<ClassPdbMember> pdbMembers, Member member) {
        ClassPdbMember classPdbMember = new ClassPdbMember(member.getName(), member.getDataType(), member.isFlexibleArray(), member.getOffset(), member.getComment());
        pdbMembers.add(classPdbMember);
    }

    void insertPdbMember(List<ClassPdbMember> pdbMembers, Member member) {
        ClassPdbMember classPdbMember = new ClassPdbMember(member.getName(), member.getDataType(), member.isFlexibleArray(), member.getOffset(), null);
        int index = 0;
        for (ClassPdbMember existingMember : pdbMembers) {
            if (existingMember.getOffset() > member.getOffset()) break;
            ++index;
        }
        pdbMembers.add(index, classPdbMember);
    }

    private int getCompositeLength(Composite myComposite) {
        if (!myComposite.isZeroLength()) {
            return myComposite.getLength();
        }
        return 0;
    }

    private static boolean alreadyAccumulatedByName(List<? extends LayoutBaseClass> list, LayoutBaseClass item) {
        DataTypePath dtp = item.getDataTypePath();
        for (LayoutBaseClass layoutBaseClass : list) {
            if (!dtp.equals((Object)layoutBaseClass.getDataTypePath())) continue;
            return true;
        }
        return false;
    }

    CategoryPath getBaseCategoryName(String baseName) {
        CategoryPath cn = this.getCategoryPath();
        return new CategoryPath(cn, new String[]{baseName});
    }

    static final void clearComponents(Composite composite) {
        if (composite instanceof Structure) {
            ((Structure)composite).deleteAll();
        } else {
            while (composite.getNumComponents() > 0) {
                composite.delete(0);
            }
        }
    }

    static enum Type {
        UNKNOWN("UNKNOWN_TYPE", -1),
        BLANK("", 1),
        CLASS("class", 2),
        STRUCT("struct", 3),
        UNION("union", 4);

        private static final Map<Integer, Type> BY_VALUE;
        private final String label;
        private final int value;

        public String getString() {
            return this.label;
        }

        public String toString() {
            if (this.label.length() != 0) {
                return this.label + " ";
            }
            return this.label;
        }

        public int getValue() {
            return this.value;
        }

        public static Type fromValue(int val) {
            return BY_VALUE.getOrDefault(val, UNKNOWN);
        }

        private Type(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Type>();
            for (Type val : Type.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }

    private static class CppClassType
    extends CppCompositeType {
        private CppClassType(SymbolPath symbolPath, Composite composite, String mangledName) {
            super(symbolPath, composite, mangledName);
            this.setClass();
        }
    }

    private static class CppStructType
    extends CppCompositeType {
        private CppStructType(SymbolPath symbolPath, Composite composite, String mangledName) {
            super(symbolPath, composite, mangledName);
            this.setStruct();
        }
    }

    private class Member
    extends AbstractMember {
        private int offset;

        private Member(CppCompositeType cppCompositeType, String name, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, int offset) {
            this(cppCompositeType, name, dataType, isFlexibleArray, attributes, offset, null);
        }

        private Member(CppCompositeType cppCompositeType, String name, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, int offset, String comment) {
            super(cppCompositeType, name, dataType, isFlexibleArray, attributes, comment);
            this.offset = offset;
        }

        int getOffset() {
            return this.offset;
        }
    }

    private static class ClassPdbMember
    extends PdbMember {
        private DataType dataType;
        private boolean isFlexibleArray;

        ClassPdbMember(String name, DataType dataType, boolean isFlexibleArray, int offset, String comment) {
            super(name, dataType.getName(), offset, comment);
            this.dataType = dataType;
            this.isFlexibleArray = isFlexibleArray;
        }

        @Override
        public String getDataTypeName() {
            return this.dataType.getName();
        }

        @Override
        protected WrappedDataType getDataType() throws CancelledException {
            return new WrappedDataType(this.dataType, this.isFlexibleArray, false);
        }
    }

    private class StaticMember
    extends AbstractMember {
        private StaticMember(CppCompositeType cppCompositeType, String name, DataType dataType, ClassFieldAttributes attributes) {
            super(cppCompositeType, name, dataType, false, attributes);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(super.toString());
            if (builder.length() > 0) {
                builder.insert(0, "static ");
            }
            return builder.toString();
        }
    }

    private abstract class LayoutBaseClass
    extends BaseClass {
        Structure layout = null;

        LayoutBaseClass(CppCompositeType cppCompositeType, CppCompositeType baseClassType, ClassFieldAttributes attributes) {
            super(cppCompositeType, baseClassType, attributes);
        }

        void setLayout(Structure layout) {
            this.layout = layout;
        }

        Structure getLayout() {
            if (this.layout == null) {
                // empty if block
            }
            return this.layout;
        }
    }

    private class DirectLayoutBaseClass
    extends LayoutBaseClass {
        private int offset;

        private DirectLayoutBaseClass(CppCompositeType cppCompositeType, CppCompositeType baseClassType, ClassFieldAttributes attributes, int offset) {
            super(cppCompositeType, baseClassType, attributes);
            this.offset = offset;
        }

        int getOffset() {
            return this.offset;
        }
    }

    private class SyntacticBaseClass
    extends BaseClass {
        private SyntacticBaseClass(CppCompositeType cppCompositeType, CppCompositeType baseClassType, ClassFieldAttributes attributes) {
            super(cppCompositeType, baseClassType, attributes);
        }
    }

    private class DirectSyntacticBaseClass
    extends SyntacticBaseClass {
        private DirectSyntacticBaseClass(CppCompositeType cppCompositeType, CppCompositeType baseClassType, ClassFieldAttributes attributes) {
            super(cppCompositeType, baseClassType, attributes);
        }
    }

    private class VirtualSyntacticBaseClass
    extends SyntacticBaseClass {
        private VirtualSyntacticBaseClass(CppCompositeType cppCompositeType, CppCompositeType baseClassType, ClassFieldAttributes attributes) {
            super(cppCompositeType, baseClassType, attributes);
        }
    }

    private class DirectVirtualLayoutBaseClass
    extends VirtualLayoutBaseClass {
        private DirectVirtualLayoutBaseClass(CppCompositeType cppCompositeType, CppCompositeType baseClass, ClassFieldAttributes attributes, int basePointerOffset, DataType vbptr, int offsetFromVbt) {
            super(cppCompositeType, baseClass, attributes, basePointerOffset, vbptr, offsetFromVbt);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(super.toString());
            if (builder.length() > 0) {
                builder.append(">");
                builder.insert(0, "<");
            }
            return builder.toString();
        }
    }

    private class IndirectVirtualLayoutBaseClass
    extends VirtualLayoutBaseClass {
        private IndirectVirtualLayoutBaseClass(CppCompositeType cppCompositeType, CppCompositeType baseClass, ClassFieldAttributes attributes, int basePointerOffset, DataType vbptr, int offsetFromVbt) {
            super(cppCompositeType, baseClass, attributes, basePointerOffset, vbptr, offsetFromVbt);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(super.toString());
            if (builder.length() > 0) {
                builder.append(">");
                builder.insert(0, "<indirect ");
            }
            return builder.toString();
        }
    }

    private abstract class BaseClass {
        private CppCompositeType baseClassType;
        private ClassFieldAttributes attributes;

        private BaseClass(CppCompositeType cppCompositeType, CppCompositeType baseClassType, ClassFieldAttributes attributes) {
            this.baseClassType = baseClassType;
            this.attributes = attributes;
        }

        CppCompositeType getBaseClassType() {
            return this.baseClassType;
        }

        ClassFieldAttributes getAttributes() {
            return this.attributes;
        }

        ObjectOrientedClassLayout getLayoutMode(ObjectOrientedClassLayout layoutOptions) {
            return this.baseClassType.getLayout(layoutOptions);
        }

        DataTypePath getDataTypePath() {
            return new DataTypePath(this.baseClassType.getCategoryPath().getParent(), this.baseClassType.getCategoryPath().getName());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.attributes);
            builder.append(this.baseClassType.getName());
            return builder.toString();
        }

        Composite getDirectDataType() {
            Composite c = this.getBaseClassType().getComposite();
            if (c.getNumComponents() == 0) {
                return c;
            }
            if (!this.baseClassType.hasDirect) {
                return c;
            }
            DataTypeComponent dtc = c.getComponent(0);
            DataType dt = dtc.getDataType();
            if (!(dt instanceof Structure)) {
                throw new AssertException("Not Structure for Direct");
            }
            Structure bdt = (Structure)dt;
            return bdt;
        }
    }

    private abstract class VirtualLayoutBaseClass
    extends LayoutBaseClass {
        private int basePointerOffset;
        private DataType vbptr;
        private int offsetFromVbt;

        private VirtualLayoutBaseClass(CppCompositeType cppCompositeType, CppCompositeType baseClass, ClassFieldAttributes attributes, int basePointerOffset, DataType vbptr, int offsetFromVbt) {
            super(cppCompositeType, baseClass, attributes);
            this.basePointerOffset = basePointerOffset;
            this.vbptr = vbptr;
            this.offsetFromVbt = offsetFromVbt;
        }

        DataType getVbptr() {
            return this.vbptr;
        }

        int getOffetFromVbt() {
            return this.offsetFromVbt;
        }

        int getBasePointerOffset() {
            return this.basePointerOffset;
        }
    }

    static class PlaceholderVirtualBaseTable {
        private String name;
        private PdbVbtManager.PdbVirtualBaseTable pdbVirtualBaseTable = null;
        private Map<Integer, PlaceholderVirtualBaseTableEntry> entriesByIndex;

        PlaceholderVirtualBaseTable() {
            this("");
        }

        PlaceholderVirtualBaseTable(String name) {
            this.name = name;
            this.entriesByIndex = new HashMap<Integer, PlaceholderVirtualBaseTableEntry>();
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        void setVirtualBaseTable(PdbVbtManager.PdbVirtualBaseTable pdbVirtualBaseTable) {
            this.pdbVirtualBaseTable = pdbVirtualBaseTable;
        }

        boolean canLookupOffset() {
            return this.pdbVirtualBaseTable != null;
        }

        long getOffset(int ordinal) throws PdbException {
            if (this.pdbVirtualBaseTable == null) {
                throw new PdbException("pdbVirtualBaseTable not initialized");
            }
            return this.pdbVirtualBaseTable.getOffset(ordinal);
        }

        Map<Integer, PlaceholderVirtualBaseTableEntry> getEntries() {
            return this.entriesByIndex;
        }

        int getMaxOffset() {
            return this.entriesByIndex.size() + 1;
        }

        boolean validateOffset() {
            int num = this.entriesByIndex.size() + 1;
            for (int index : this.entriesByIndex.keySet()) {
                if (index <= num && index >= 0) continue;
                return false;
            }
            return true;
        }

        void addEntry(int indexInTable, PlaceholderVirtualBaseTableEntry entry) {
            this.entriesByIndex.put(indexInTable, entry);
        }

        PlaceholderVirtualBaseTableEntry getEntryByIndexInTable(int indexInTable) {
            return this.entriesByIndex.get(indexInTable);
        }

        PlaceholderVirtualBaseTableEntry getEntryByName(String nameParam) {
            for (Map.Entry<Integer, PlaceholderVirtualBaseTableEntry> entry : this.entriesByIndex.entrySet()) {
                if (!nameParam.equals(entry.getValue().getVirtualBaseClass().getBaseClassType().getName())) continue;
                return entry.getValue();
            }
            return null;
        }
    }

    static class PlaceholderVirtualBaseTableEntry {
        VirtualLayoutBaseClass virtualBaseClass;
        int offsetInClass;

        PlaceholderVirtualBaseTableEntry(VirtualLayoutBaseClass virtualBaseClass) {
            this.virtualBaseClass = virtualBaseClass;
        }

        void setOffsetInClass(int offsetInClass) {
            this.offsetInClass = offsetInClass;
        }

        int getOffsetInClass() {
            return this.offsetInClass;
        }

        String getName() {
            return this.virtualBaseClass.getBaseClassType().getName();
        }

        VirtualLayoutBaseClass getVirtualBaseClass() {
            return this.virtualBaseClass;
        }
    }

    private class CppCompositeAndMember {
        private CppCompositeType cppType;
        private Member member;

        private CppCompositeAndMember(CppCompositeType cppCompositeType, CppCompositeType cppType, Member member) {
            this.cppType = cppType;
            this.member = member;
        }

        private CppCompositeType getComposite() {
            return this.cppType;
        }

        private Member getMember() {
            return this.member;
        }
    }

    private abstract class AbstractMember {
        private String memberName;
        private DataType dataType;
        private boolean isFlexibleArray;
        private ClassFieldAttributes attributes;
        private String comment;

        private AbstractMember(CppCompositeType cppCompositeType, String name, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes) {
            this(cppCompositeType, name, dataType, isFlexibleArray, attributes, null);
        }

        private AbstractMember(CppCompositeType cppCompositeType, String name, DataType dataType, boolean isFlexibleArray, ClassFieldAttributes attributes, String comment) {
            this.memberName = name;
            this.dataType = dataType;
            this.isFlexibleArray = isFlexibleArray;
            this.attributes = attributes;
            this.comment = comment;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.dataType);
            if (builder.length() > 0 && this.memberName.length() > 0) {
                builder.append(' ');
            }
            builder.append(this.memberName);
            return builder.toString();
        }

        String getName() {
            return this.memberName;
        }

        DataType getDataType() {
            return this.dataType;
        }

        boolean isFlexibleArray() {
            return this.isFlexibleArray;
        }

        ClassFieldAttributes getAttributes() {
            return this.attributes;
        }

        void setComment(String comment) {
            this.comment = comment;
        }

        String getComment() {
            return this.comment;
        }
    }
}

