/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb.PdbBitField;
import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.WrappedDataType;
import ghidra.app.util.pdb.pdbapplicator.ClassFieldAttributes;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;

public class DefaultPdbUniversalMember
extends PdbMember {
    private DataType dataType;
    private ClassFieldAttributes attributes;
    private boolean isZeroLengthArray;

    DefaultPdbUniversalMember(String name, DataType dataType, int offset) {
        super(name, dataType.getName(), offset, null);
        this.dataType = dataType;
        this.attributes = ClassFieldAttributes.BLANK;
        this.isZeroLengthArray = false;
    }

    DefaultPdbUniversalMember(String name, DataType dataType, boolean isZeroLengthArray, int offset, ClassFieldAttributes attributes, String memberComment) {
        super(name, dataType.getName(), offset, memberComment);
        this.dataType = dataType;
        this.attributes = attributes;
        this.isZeroLengthArray = isZeroLengthArray;
    }

    private DataType getDataTypeInternal() {
        return this.dataType;
    }

    public boolean isZeroLengthArray() {
        return this.isZeroLengthArray;
    }

    public ClassFieldAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public String getDataTypeName() {
        return this.getDataTypeInternal().getName();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name=");
        builder.append(this.getName());
        DataType dt = this.getDataTypeInternal();
        if (dt instanceof PdbBitField) {
            PdbBitField bfDt = (PdbBitField)dt;
            builder.append(", type=");
            builder.append(bfDt.getBaseDataType().getName());
            builder.append(", offset=");
            builder.append(this.getOffset());
            builder.append(", bitSize=");
            builder.append(bfDt.getDeclaredBitSize());
            builder.append(", bitOffset=");
            builder.append(bfDt.getBitOffsetWithinBase());
        } else {
            builder.append(", type=");
            builder.append(dt.getName());
            builder.append(", offset=");
            builder.append(this.getOffset());
        }
        return builder.toString();
    }

    @Override
    protected WrappedDataType getDataType() throws CancelledException {
        DataType dt = this.getDataTypeInternal();
        return new WrappedDataType(dt, this.isZeroLengthArray, false);
    }
}

