/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb.DefaultCompositeMember;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VtShapeDescriptorMsProperty;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VtShapeMsType;
import ghidra.app.util.pdb.pdbapplicator.CompositeTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbUniversalMember;
import ghidra.app.util.pdb.pdbapplicator.MsDataTypeApplier;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.Undefined2DataType;
import ghidra.program.model.data.Undefined4DataType;
import ghidra.program.model.data.Undefined6DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;
import java.util.List;

public class VtShapeTypeApplier
extends MsDataTypeApplier {
    public VtShapeTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    String getName(VtShapeMsType type) {
        return "vtshape_" + type.getRecordNumber().getNumber();
    }

    @Override
    boolean apply(AbstractMsType type) throws PdbException, CancelledException {
        DataType dataType = this.createVtShape((VtShapeMsType)type);
        this.applicator.putDataType(type, dataType);
        return true;
    }

    private DataType createVtShape(VtShapeMsType msShape) throws CancelledException {
        List<VtShapeDescriptorMsProperty> list = msShape.getDescriptorList();
        StructureDataType shape = new StructureDataType(this.applicator.getAnonymousTypesCategory(), "vtshape" + msShape.getRecordNumber().getNumber(), 0, this.applicator.getDataTypeManager());
        ArrayList<DefaultPdbUniversalMember> members = new ArrayList<DefaultPdbUniversalMember>();
        int offset = 0;
        int defaultSize = this.applicator.getDataTypeManager().getDataOrganization().getPointerSize();
        for (VtShapeDescriptorMsProperty descriptor : list) {
            Undefined2DataType elementType;
            switch (descriptor) {
                case NEAR: {
                    elementType = Undefined2DataType.dataType;
                    break;
                }
                case FAR: {
                    elementType = Undefined4DataType.dataType;
                    break;
                }
                case NEAR32: {
                    elementType = Undefined4DataType.dataType;
                    break;
                }
                case FAR32: {
                    elementType = Undefined6DataType.dataType;
                    break;
                }
                case UNUSED: {
                    this.applicator.appendLogMsg("PDB Warning: UNUSED propery found in VTShape.");
                }
                default: {
                    this.applicator.appendLogMsg("PDB Warning: No type conversion for " + msShape.toString() + " as underlying type for pointer. Using void.");
                    return VoidDataType.dataType;
                }
            }
            int size = elementType.getLength();
            if (size == defaultSize) {
                elementType = PointerDataType.dataType;
            }
            DefaultPdbUniversalMember member = new DefaultPdbUniversalMember("", (DataType)elementType, offset);
            offset += size;
            members.add(member);
        }
        if (!DefaultCompositeMember.applyDataTypeMembers((Composite)shape, false, offset, members, msg -> Msg.warn((Object)this, (Object)msg), this.applicator.getCancelOnlyWrappingMonitor())) {
            CompositeTypeApplier.clearComponents((Composite)shape);
        }
        return shape;
    }
}

