/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.lldb.util;

import agent.lldb.lldb.DebugBreakpoint;
import agent.lldb.lldb.DebugClient;
import agent.lldb.lldb.DebugEventCallbacks;
import agent.lldb.lldb.DebugModuleInfo;
import agent.lldb.lldb.DebugProcessInfo;
import agent.lldb.lldb.DebugSessionInfo;
import agent.lldb.lldb.DebugThreadInfo;
import ghidra.comm.util.BitmaskSet;
import java.lang.reflect.Method;

public class DebugEventCallbacksAdapter
implements DebugEventCallbacks {
    private BitmaskSet<DebugEventCallbacks.DebugEvent> interests = new BitmaskSet(DebugEventCallbacks.DebugEvent.class);

    public DebugEventCallbacksAdapter() {
        try {
            for (Method im : DebugEventCallbacks.class.getDeclaredMethods()) {
                Method m = this.getClass().getMethod(im.getName(), im.getParameterTypes());
                if (m.getDeclaringClass() == DebugEventCallbacksAdapter.class) continue;
                DebugEventCallbacks.ForInterest fi = im.getAnnotation(DebugEventCallbacks.ForInterest.class);
                if (fi == null) {
                    throw new AssertionError((Object)("No ForInterest annotation present on " + String.valueOf(m)));
                }
                this.interests.add((Enum)fi.value());
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public BitmaskSet<DebugEventCallbacks.DebugEvent> getInterestMask() {
        return this.interests;
    }

    @Override
    public DebugClient.DebugStatus breakpoint(DebugBreakpoint bp) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus createThread(DebugThreadInfo debugThreadInfo) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus exitThread(int exitCode) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus createProcess(DebugProcessInfo debugProcessInfo) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus exitProcess(int exitCode) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus createSession(DebugSessionInfo debugSessionInfo) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus exitSession(int exitCode) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus loadModule(DebugModuleInfo debugModuleInfo) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus unloadModule(String imageBaseName, long baseOffset) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus systemError(int error, int level) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus sessionStatus(DebugClient.SessionStatus status) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus changeSessionState(BitmaskSet<DebugClient.ChangeSessionState> flags) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus changeProcessState(BitmaskSet<DebugClient.ChangeProcessState> flags) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    @Override
    public DebugClient.DebugStatus changeThreadState(BitmaskSet<DebugClient.ChangeThreadState> flags) {
        return DebugClient.DebugStatus.NO_CHANGE;
    }
}

