/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBBreakpoint;
import SWIG.SBError;
import SWIG.SBStream;
import SWIG.SBTarget;
import SWIG.SBWatchpoint;
import agent.lldb.manager.breakpoint.LldbBreakpointInfo;
import agent.lldb.manager.breakpoint.LldbBreakpointType;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import ghidra.util.Msg;
import java.math.BigInteger;

public class LldbInsertBreakpointCommand
extends AbstractLldbCommand<LldbBreakpointInfo> {
    private final LldbBreakpointType type;
    private LldbBreakpointInfo bkpt;
    private int len;
    private final String expression;
    private final BigInteger loc;

    public LldbInsertBreakpointCommand(LldbManagerImpl manager, String expression, LldbBreakpointType type) {
        super(manager);
        this.type = type;
        this.expression = expression;
        this.loc = null;
    }

    public LldbInsertBreakpointCommand(LldbManagerImpl manager, long loc, int len, LldbBreakpointType type) {
        super(manager);
        this.len = len;
        this.type = type;
        this.expression = null;
        this.loc = BigInteger.valueOf(loc);
    }

    @Override
    public LldbBreakpointInfo complete(LldbPendingCommand<?> pending) {
        SBTarget currentSession = this.manager.getCurrentSession();
        this.manager.doBreakpointCreated(currentSession, this.bkpt.getBreakpoint(), pending);
        return this.bkpt;
    }

    @Override
    public void invoke() {
        SBTarget currentSession = this.manager.getCurrentSession();
        if (this.type.equals((Object)LldbBreakpointType.BREAKPOINT) || this.type.equals((Object)LldbBreakpointType.HW_BREAKPOINT)) {
            SBBreakpoint bpt = this.loc != null ? currentSession.BreakpointCreateByAddress(this.loc) : currentSession.BreakpointCreateByRegex(this.expression);
            bpt.SetEnabled(true);
            this.bkpt = new LldbBreakpointInfo(bpt, this.manager.getCurrentProcess());
        } else {
            boolean read = true;
            boolean write = true;
            SBError error = new SBError();
            this.len = 8;
            if (this.type.equals((Object)LldbBreakpointType.READ_WATCHPOINT)) {
                write = false;
            }
            if (this.type.equals((Object)LldbBreakpointType.WRITE_WATCHPOINT)) {
                read = false;
            }
            SBWatchpoint wpt = currentSession.WatchAddress(this.loc, (long)this.len, read, write, error);
            if (!error.Success()) {
                SBStream stream = new SBStream();
                error.GetDescription(stream);
                Msg.error((Object)this, (Object)(String.valueOf(error.GetType()) + ":" + stream.GetData()));
                return;
            }
            if (!wpt.IsValid()) {
                Msg.error((Object)this, (Object)"Error creating watchpoint");
                return;
            }
            wpt.SetEnabled(true);
            this.bkpt = new LldbBreakpointInfo(wpt, this.manager.getCurrentProcess());
        }
    }
}

