/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import agent.lldb.manager.LldbCause;
import agent.lldb.manager.LldbCommand;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.cmd.LldbCommandError;
import agent.lldb.manager.evt.AbstractLldbCompletedCommandEvent;
import agent.lldb.manager.evt.LldbCommandErrorEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class LldbPendingCommand<T>
extends CompletableFuture<T>
implements LldbCause {
    private final LldbCommand<? extends T> cmd;
    private final Set<LldbEvent<?>> evts = new LinkedHashSet();

    public LldbPendingCommand(LldbCommand<? extends T> cmd) {
        this.cmd = cmd;
    }

    public LldbCommand<? extends T> getCommand() {
        return this.cmd;
    }

    public void finish() {
        try {
            T result = this.cmd.complete(this);
            this.complete(result);
        }
        catch (Throwable e) {
            this.completeExceptionally(e);
        }
    }

    public boolean handle(LldbEvent<?> evt) {
        return this.cmd.handle(evt, this);
    }

    public void claim(LldbEvent<?> evt) {
        evt.claim(this);
        this.evts.add(evt);
    }

    public void steal(LldbEvent<?> evt) {
        this.claim(evt);
        evt.steal();
    }

    public <E extends LldbEvent<?>> E castSingleEvent(Class<E> cls) {
        if (this.evts.size() != 1) {
            throw new IllegalStateException("Command did not claim exactly one event");
        }
        return (E)((LldbEvent)cls.cast(this.evts.iterator().next()));
    }

    public <E extends LldbEvent<?>> E findFirstOf(Class<E> cls) {
        for (LldbEvent<?> evt : this.evts) {
            if (!cls.isAssignableFrom(evt.getClass())) continue;
            return (E)((LldbEvent)cls.cast(evt));
        }
        throw new IllegalStateException("Command did not claim any " + String.valueOf(cls));
    }

    public <E extends LldbEvent<?>> List<E> findAllOf(Class<E> cls) {
        ArrayList<LldbEvent> found = new ArrayList<LldbEvent>();
        for (LldbEvent<?> evt : this.evts) {
            if (!cls.isAssignableFrom(evt.getClass())) continue;
            found.add((LldbEvent)cls.cast(evt));
        }
        return found;
    }

    public <E extends LldbEvent<?>> E findSingleOf(Class<E> cls) {
        List<E> found = this.findAllOf(cls);
        if (found.size() != 1) {
            throw new IllegalStateException("Command did not claim exactly one " + String.valueOf(cls) + ". Have " + String.valueOf(this.evts));
        }
        return (E)((LldbEvent)found.get(0));
    }

    @SafeVarargs
    public final <E extends AbstractLldbCompletedCommandEvent> E checkCompletion(Class<E> ... classes) {
        AbstractLldbCompletedCommandEvent completion = this.findSingleOf(AbstractLldbCompletedCommandEvent.class);
        for (Class<E> cls : classes) {
            if (cls != completion.getClass()) continue;
            return (E)((AbstractLldbCompletedCommandEvent)cls.cast(completion));
        }
        if (completion instanceof LldbCommandErrorEvent) {
            throw new LldbCommandError(completion.getInfo(), this.cmd);
        }
        for (Class<E> cls : classes) {
            if (!cls.isAssignableFrom(completion.getClass())) continue;
            return (E)((AbstractLldbCompletedCommandEvent)cls.cast(completion));
        }
        throw new IllegalStateException("Command completed with " + String.valueOf(completion) + ", not any of " + String.valueOf(Arrays.asList(classes)));
    }

    @Override
    public String toString() {
        return super.toString() + "(" + String.valueOf(this.cmd) + ")";
    }
}

