/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBError;
import SWIG.SBStream;
import SWIG.SBThread;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.evt.AbstractLldbCompletedCommandEvent;
import agent.lldb.manager.evt.LldbCommandErrorEvent;
import agent.lldb.manager.evt.LldbRunningEvent;
import agent.lldb.manager.impl.LldbManagerImpl;
import ghidra.util.Msg;
import java.math.BigInteger;

public class LldbRunToAddressCommand
extends AbstractLldbCommand<Void> {
    private SBThread thread;
    private final BigInteger addr;

    public LldbRunToAddressCommand(LldbManagerImpl manager, SBThread thread, BigInteger addr) {
        super(manager);
        this.thread = thread;
        this.addr = addr;
    }

    @Override
    public boolean handle(LldbEvent<?> evt, LldbPendingCommand<?> pending) {
        if (evt instanceof AbstractLldbCompletedCommandEvent && pending.getCommand().equals(this)) {
            return evt instanceof LldbCommandErrorEvent || !pending.findAllOf(LldbRunningEvent.class).isEmpty();
        }
        if (evt instanceof LldbRunningEvent) {
            pending.claim(evt);
            return !pending.findAllOf(AbstractLldbCompletedCommandEvent.class).isEmpty();
        }
        return false;
    }

    @Override
    public void invoke() {
        if (this.thread == null || !this.thread.IsValid()) {
            this.thread = this.manager.getCurrentThread();
        }
        SBError error = new SBError();
        this.thread.RunToAddress(this.addr, error);
        if (!error.Success()) {
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)(String.valueOf(error.GetType()) + " while running to address: " + stream.GetData()));
        }
    }
}

