/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBError;
import SWIG.SBThread;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import ghidra.util.Msg;

public class LldbThreadHoldCommand
extends AbstractLldbCommand<Void> {
    static final String FREEZE_ALL_THREADS_COMMAND = "~* f";
    static final String FREEZE_CURRENT_THREAD_COMMAND = "~. f";
    static final String UNFREEZE_CURRENT_THREAD_COMMAND = "~. u";
    static final String UNFREEZE_ALL_THREADS_COMMAND = "~* u";
    static final String SUSPEND_ALL_THREADS_COMMAND = "~* n";
    static final String SUSPEND_CURRENT_THREAD_COMMAND = "~. n";
    static final String RESUME_CURRENT_THREAD_COMMAND = "~. m";
    static final String RESUME_ALL_THREADS_COMMAND = "~* m";
    static final Boolean preferFreeze = true;
    private SBThread thread;
    private Boolean set;

    public LldbThreadHoldCommand(LldbManagerImpl manager, SBThread thread, Boolean set) {
        super(manager);
        this.thread = thread;
        this.set = set;
    }

    @Override
    public void invoke() {
        SBError error = new SBError();
        if (this.set.booleanValue()) {
            this.thread.Suspend(error);
        } else {
            this.thread.Resume(error);
        }
        if (!error.Success()) {
            Msg.error((Object)this, (Object)(String.valueOf(error.GetType()) + " while placing hold"));
        }
    }
}

