/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.ByteArray;
import SWIG.SBError;
import SWIG.SBProcess;
import SWIG.SBStream;
import SWIG.SWIGTYPE_p_void;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import ghidra.program.model.address.Address;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class LldbWriteMemoryCommand
extends AbstractLldbCommand<Void> {
    private final SBProcess process;
    private final Address addr;
    private final ByteBuffer buf;
    private final int len;

    public LldbWriteMemoryCommand(LldbManagerImpl manager, SBProcess process, Address addr, ByteBuffer buf, int len) {
        super(manager);
        this.process = process;
        this.addr = addr;
        this.buf = buf.duplicate();
        this.len = len;
    }

    @Override
    public void invoke() {
        BigInteger offset = this.addr.getOffsetAsBigInteger();
        byte[] byteArray = this.buf.array();
        ByteArray buffer = new ByteArray(this.len);
        for (int i = 0; i < this.len; ++i) {
            buffer.setitem(i, byteArray[i]);
        }
        SBError error = new SBError();
        this.process.WriteMemory(offset, (SWIGTYPE_p_void)buffer, (long)this.len, error);
        if (!error.Success()) {
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)(String.valueOf(error.GetType()) + ":" + stream.GetData()));
        }
        buffer.delete();
    }
}

