/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.iface1;

import agent.lldb.model.iface1.LldbModelSelectableObject;
import agent.lldb.model.iface2.LldbModelTargetObject;
import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetActiveScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface LldbModelTargetActiveScope
extends LldbModelTargetObject,
TargetActiveScope {
    default public CompletableFuture<Void> requestActivation(TargetObject obj) {
        return this.getModel().gateFuture(this.getManager().requestActivation(this, obj));
    }

    default public CompletableFuture<Void> doRequestActivation(TargetObject obj) {
        if (this.getManager().isWaiting()) {
            return AsyncUtils.nil();
        }
        this.getModel().assertMine(TargetObject.class, obj);
        if (!PathUtils.isAncestor((List)this.getPath(), (List)obj.getPath())) {
            throw new DebuggerIllegalArgumentException("Can only focus a successor of the scope");
        }
        TargetObject cur = obj;
        while (cur != null) {
            if (cur instanceof LldbModelSelectableObject) {
                LldbModelSelectableObject sel = (LldbModelSelectableObject)cur;
                return sel.setActive();
            }
            if (cur instanceof LldbModelTargetObject) {
                LldbModelTargetObject def = (LldbModelTargetObject)cur;
                cur = def.getParent();
                continue;
            }
            throw new AssertionError();
        }
        return AsyncUtils.nil();
    }
}

